---
description: >-
  Frameworks help prevent repetition and provide great organization. They tend
  to force you to organize your files and code in a way that keeps it highly
  modular and really clean.
---

# Frameworks

## What are frameworks?

If you're programming with any other language, you pretty much start with a blank text file and go from there. Programmers, the best of whom are pretty lazy folk \(in a good way\), got tired of having to write the same code over and over and over again just to cover the basic tasks that they wanted their applications to perform. So they batched that recycled code together and called it a framework.

In addition to preventing repetition, frameworks provide great organization. They tend to force you to organize your files and code in a way that keeps it highly modular and really clean. When you start a new app with any framework, you're given dozens of folders already organized in a hierarchy which makes sense and follows good practice such as Model-View-Controller \(MVC\) separation principles. It's not quite "color-by-numbers" for code but it certainly keeps things ordered.

There are often several different popular frameworks for a given language. They can have exciting names like [Ember](http://emberjs.com/), [Meteor](http://www.meteor.com/), [Django](https://www.djangoproject.com/), [Rails](http://rubyonrails.org/), [Grok](http://grok.zope.org/), etc. Wikipedia has a [comprehensive comparison of frameworks](http://en.wikipedia.org/wiki/Comparison_of_web_application_frameworks) that should give you an appreciation for the number of them. For Ruby alone, though Rails is the most popular, there is also [Sinatra](http://www.sinatrarb.com/) and [Padrino](http://www.padrinorb.com/) and more.

A final thing to note is about licensing -- frameworks are typically \(though not always\) open-source and their license allows you to use them, modify them, make money off them, sell products with them, etc., all without owing any fees to their original creators. You may not think too much about that as you blithely code away using other people's frameworks, but it's a very important distinction between open-source frameworks and commercially produced/sold software. We'll get more into [Open Source Software \(OSS\)](https://en.wikipedia.org/wiki/Open-source_software) in later units.

## Learning outcomes

Look through these now and then use them to test yourself after doing the assignment:

* What is a framework?
* What's the difference between a programming language and a framework?
* What languages have frameworks?

## Assignment

1. Get introduced to frameworks by reading these brief articles from [Wired \(originally from WebMonkey\)](https://web.archive.org/web/20180402231229/https://www.wired.com/2010/02/get_started_with_web_frameworks/) and [Dev.to](https://dev.to/aspittel/what-is-a-web-framework-and-why-should-i-use-one-38c0).
2. Glance over [this article](https://rubygarage.org/blog/technology-stack-for-web-development) from RubyGarage or [this description](https://developer.mozilla.org/en-US/docs/Learn/Server-side/First_steps/Web_frameworks) from Mozilla's website to understand some of the thought process that goes into picking a framework.

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental for if you need to dive deeper into something.

* [StackOverflow: What is a Web Framework? How does it compare with LAMP?](http://stackoverflow.com/questions/4507506/what-is-a-web-framework-how-does-it-compare-with-lamp)

