---
description: The backend is the server side of a web application.
---

# Backend

## What is the backend?

The three languages of the front end are fairly standardized -- HTML for Markup, CSS for Presentation, and JavaScript for Scripting. The back end is a different story... you can run pretty much anything you want to on your server since it doesn't rely on your user's browser understanding what's going on. All the browser cares about is whether you've sent it properly formatted HTML, CSS and JavaScript files \(and other assets like images\). That's led to a whole lot of different choices for back-end languages. As long as it can take in an HTTP request and spit out some HTML, you can probably put it on a server somehow.

That said, some languages are more popular and practical than others. If you're running your own server, you have a ton of flexibility but plenty of headaches. If you're deploying to the cloud \(which we will be doing later\), you may be restricted to those languages which your cloud provider has installed on their platform... it doesn't do you much good if the servers you're "borrowing" from can't understand your code!

Some of the most popular server-side languages are PHP, ASP.NET, Ruby, Python and Java \(not to be confused with JavaScript\). Just as we can say "Which way to the nearest pub?" in Swedish, French, Italian, English, and Bad English, so too can all of those languages perform almost exactly the same functions, just using different syntaxes.

As we covered back in the [Requirements Overview](https://www.learnhowtocodebook.com/foundations/requirements/overview), the front end languages live in the browser so there are no extra installations required. For the reasons listed above, the back end languages do require you to install them on your computer in order to get them running. NodeJS has already been installed as it is required in the JavaScript section of Foundations. Ruby and Rails is installed in their own respective sections as they aren't required until then.

## Learning outcomes

* What is the difference between front-end and back-end development ?
* Why are we required to install back-end languages to our computer \(besides to run them\)?

## Assignment

1. Check out [this blog post on back end vs front end programming](http://blog.teamtreehouse.com/i-dont-speak-your-language-frontend-vs-backend) for a quick refresher on the difference between the two.
2. Read over [this quick interview with Matt Jording](https://www.bizjournals.com/washington/inno/stories/news/2014/03/31/what-is-back-end-web-development.html) about what back end web development is.

