---
description: >-
  Learn how to build a command line Chess game where two players can play
  against each other.
---

# Project: Chess

## Introduction

Chess is a classic game that appears very complicated at first but can be broken down into logical steps that make it a great Ruby capstone project. If you've never played, be sure to read up on the rules \(see the [Wikipedia Page](http://en.wikipedia.org/wiki/Chess)\) first.

The problem specification is deliberately sparse for this, your final project of Ruby -- it's up to you to attack the problem with very little prior information or structure, which is good practice for real world programming challenges. You have all the tools you need. You already did a lot of the heavy thinking in the [Knight's Travails project](https://www.learnhowtocodebook.com/deep-dives/ruby/computer-science/project-knight-travails).

The main difference is that this problem has the broadest scope of anything you've done yet. The keys here will be thinking it through logically ahead of time and maintaining a disciplined workflow. It'll be much easier on you if you're able to stay organized and break it down into components that you can tackle one by one.

This is a great project to have as a part of your portfolio going forward because it shows you can take on something with a lot of different components to it.

## Assignment

1. Build a command line Chess game where two players can play against each other.
2. The game should be properly constrained -- it should prevent players from making illegal moves and declare check or check mate in the correct situations.
3. Make it so you can save the board at any time \(remember how to serialize?\)
4. Write tests for the important parts. You don't need to TDD it \(unless you want to\), but be sure to use RSpec tests for anything that you find yourself typing into the command line repeatedly.
5. Do your best to keep your classes modular and clean and your methods doing only one thing each. This is the largest program that you've written, so you'll definitely start to see the benefits of good organization \(and testing\) when you start running into bugs.
6. Have fun! Check out the [unicode characters](http://en.wikipedia.org/wiki/Chess_symbols_in_Unicode) for a little spice for your game board.

### Extra credit

* Build a very simple AI computer player \(perhaps who does a random legal move\)

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental for if you need to dive deeper into something.

* [Illustrated rules of Chess](http://www.chessvariants.org/d.chess/chess.html)
* [A series of hints from RubyQuiz](http://rubyquiz.com/quiz35.html), where this was one of their challenges. You don't need these. Resist the temptation!

