---
description: >-
  We're taking a look at some more Computer Science-y concepts here because they
  are fundamental to your career as a developer.
---

# Computer Science

## Introduction

You've learned how to build some cool stuff already and, frankly, you could probably make some decent websites without a crazy amount of additional formal education. However, just because you can write English at a grade school level doesn't mean you will be editing the New York Times anytime soon.

In the world of programming, there's a difference between solving a problem the brute force way and solving a problem WELL. We touched on the first layer of this when we covered basic object-oriented programming and how you should break apart your code into well-organized chunks.

If you assume those lessons were all about learning how to write good code, these next few lessons are going to be about training yourself to figure out the best code to write -- the most elegant solution to the problem at hand. It becomes particularly important whenever you start working with large data sets, like when your website becomes highly successful.

We're taking a look at some more Computer Science-y concepts here because they are fundamental for a reason. Some problems require you to use tools beyond just arrays and iterators. You're going to build chess and it's not fundamentally difficult \(it's just a rules-based game after all\) but there are some tricks that you'll want to use to help you solve it. There's no sense reinventing the wheel when others have already figured out good methods for solving certain types of problems.

If that doesn't get you interested, remember that this curriculum is meant to prepare you for life beyond the web page. If you're interested in applying for a job, you'll be asked questions that directly touch on some of this stuff. It's going to require you to put on your thinking cap \(sorry, it had to happen sometime\), but we won't be doing anything too crazy. We'll stick to the practical side of this material as opposed to getting too stuck in theory.

## Learning outcomes

Look through these now and then use them to test yourself after doing the assignment:

* What is an algorithm?
* What is pseudo-code?

## Assignment

1. Skim this [Introduction to Algorithms by David Malan](http://ed.ted.com/lessons/your-brain-can-solve-algorithms-david-j-malan) on TedEd to see how to think about algorithms.
2. Watch [What is an Algorithm?](https://youtu.be/e_WfC8HwVB8) on YouTube. for a more structured look at solving problems using algorithms.
3. Read [this Quora question about the importance of algorithms in web development](http://www.quora.com/Algorithms/What-is-the-importance-of-algorithms-in-web-development) to get some context for why we're going over this stuff.
4. Watch [What is pseudocode?](https://www.youtube.com/watch?v=Rg-fO7rDsds)

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental for if you need to dive deeper into something.

* [Wikipedia on Computer Science](http://en.wikipedia.org/wiki/Computer_science)
* [Wikipedia on Algorithms](http://en.wikipedia.org/wiki/Algorithm)
* [Map of Computer Science](https://youtu.be/SzJ46YA_RaA)

