---
description: >-
  Learn everything you need to know in order to start building applications with
  Ruby.
---

# Ruby

## Introduction

This course is all about teaching you **Ruby**, the language designed specifically for programmer happiness. What could possibly be better than that?! A task that takes dozens of lines of code to accomplish in Java or a hundred in C could take just a few in Ruby thanks to Ruby prepackaging so many useful functions into easy-to-use and convenient methods.

Ruby and Python are quite similar and in some ways resemble Romance languages: once you've learned one, it's not terribly hard to pick up the other because they tend to follow many of the same conventions. Python tends to be taught more in colleges and is often used for more data-intensive and processor-heavy applications.

However, Ruby has a secret weapon that makes it the love of fast-iterating web developers: the **Ruby on Rails** framework, which we'll cover in a later course. Rails has been optimized for writing code faster and with less headache, allowing you to iterate more frequently when building a website. Faster iteration means that the end product is more likely to suit the client's or users' needs, making your projects more successful.

You'll do a healthy chunk of learning in this course, but by the end of it all, you'll have built some pretty sweet projects including **Tic Tac Toe**, **Hangman**, and even **Chess**. You'll be able to save and open files, write tests for your code, separate out your spaghetti code into nice, distinct classes, and even reproduce some basic algorithms and data structures to solve complex problems.

**Basically, you're going to start feeling a whole lot more like a real programmer, and that feeling will be justified.**

## Learning Ruby before Ruby on Rails

Some people believe you can just dive right into Rails and start firing out websites. So why do we have an entire course dedicated to only Ruby before we start looking at Rails? Rails is a framework built using exclusively Ruby, and every bit of code in it is written with Ruby. When \(_not_ "if"\) something in your project breaks, you'd better be able to debug it, which means having a strong understanding of Ruby, how it works, and what its error messages look like. Beyond that, when you start to stretch your wings and do something just a bit beyond what the vanilla tutorials explicitly show you how to do, you'll quickly discover a world of frustration if you don't have a strong foundation in Ruby. The amount of time you would spend Googling your error messages and staring blankly at help docs would be better spent learning Ruby now.

## The path ahead

Ruby is a big language with lots of syntax, so we've broken the concepts up into smaller chunks to make it more digestible. Some of the early material will be fairly straightforward and will rely on simple exercises to help reinforce your understanding. As you progress through the course, the goal is for you to get a much deeper and more practical understanding of the material. As you move into some of the more advanced topics, you'll be reading less and building more--just the way it should be!

* In the first section, you'll learn all about the basics of Ruby along with some classic programming basics.
* In the second section, you'll learn about object-oriented programming, which will show you how to cleanly and neatly organize your code into reusable objects.
* In the third section, you'll dive into some basic computer science, where you'll learn about recursion and common data structures.
* In the fourth section, you'll learn the basics of test-driven development.
* In the fifth section, you'll learn some more advanced features of Git and the Git workflow used by professional developers.
* In the sixth and final section, you'll tie everything together by building a fully fledged chess game.

## Assignment

1. Read the [Introduction](https://launchschool.com/books/ruby/read/introduction) of Launch School's _Introduction to Programming with Ruby_ book to learn a bit more about the history of Ruby.
2. To understand how you'll be interacting with Ruby throughout this course, read through the [Your Tools chapter](http://ruby-for-beginners.rubymonstas.org/your_tools.html) of The _Ruby for Beginners_ book from Ruby Monstas. \(Note that even though they recommend using Sublime as your text editor, any code editor will work. For the record, we still tend to prefer VS Code around here!\)
3. Skip the installation instructions and read through the [Preparations](https://launchschool.com/books/ruby/read/preparations#usingacodeeditor) of Launch School's _Introduction to Programming with Ruby_ book for some helpful advice about using and learning Ruby effectively. Don't worry, you will install Ruby in the next lesson.
4. Now that you've learned a few ways to interact with your Ruby code, read about [how to use code files inside IRB](https://stackoverflow.com/questions/13112245/ruby-how-to-load-a-file-into-interactive-ruby-console-irb/38533339), which will be helpful for quick troubleshooting and experimenting. 

## Optional materials

The resources listed below cover Ruby basics, and you may want to go through these on the side while going through the first section of this Ruby Basics course. Repetition is the mother of all learning after all!

Consider the resources here optional, though we recommend them to help supplement your learning.

1. [The Codecademy Ruby course](https://www.codecademy.com/learn/learn-ruby) covers Ruby basics and OOP basics.
2. [Chris Pine's Learn to Program book](https://pine.fm/LearnToProgram/) covers Ruby basics along with plenty of exercises.

**Okay, enough talk. Let's learn Ruby!**

