---
description: >-
  The point of this course has been to get you to a place where you can start
  thinking about actually getting that first job.
---

# Next steps

## Great work

You've reached the end of the scope of this course and should feel pretty good about your Rails skills. That doesn't mean you should feel like you understand everything, but you should be able to build a Rails application with the kind of functionality which is actually useful in the real world. It probably won't look too pretty, but that will come in the next few courses.

This isn't the last course in the curriculum and you've got quite a way to go before hitting that "full stack" point, but it's as far as we'll get with Rails and it's pretty darn far. Despite how far you've come, it's up to you to keep building stuff, asking questions, and digging deeper into both Rails and best practices of software engineering in general.

At this point, you've got the Rails building blocks but the learning is never finished. Your first six months on the job as a Rails dev will involve learning at least as much information as you just did. The point of this course has been to get you to a place where you can start thinking about actually getting that first job.

## Next steps

This final lesson isn't designed to explicitly teach new material, just point you in the right direction if you'd like to dig a bit deeper before moving on. Or maybe you'll bookmark it and come back when you want to see where to head next in your Rails journey.

Rails is deep... there's a lot going on behind the scenes and it will take a long time to actually understand how it all works and the best ways to use it. The best way to figure it out is to work for a company that uses it and get paid to learn. If that's not an option, building your own stuff and reading on your own time can be a good substitute. There's new information being created every day in blog posts, Stack Overflow posts, and podcasts.

A good first step is to reread the [Rails Guides](http://guides.rubyonrails.org/index.html). There are some sections we skipped and some guides we never got to \(especially in the "digging deeper" section\). In particular, the following sections might be interesting:

### **Security**

If you start working on more public-facing applications, security will become more important. Check out the [Rails Guide on Security](http://guides.rubyonrails.org/security.html) for more information.

### **Rails tasks**

Rails tasks are a special way of running scripts that can use your application. You're already familiar with some like `$ rails db:migrate`, but you can also create your own. This website uses a Rails task to populate the curriculum from its GitHub repo. Check out the [Rails Guide on Command Line and bin/rails](http://guides.rubyonrails.org/command_line.html) for more information.

### **Caching**

Caching makes your application faster by reducing database calls. Check out the [Rails Guide on Caching](http://guides.rubyonrails.org/caching_with_rails.html) to learn more.

## Books

Here are a few books that will take you a bit deeper as well:

* [The Rails 5 Way](https://leanpub.com/tr5w) by Obie Fernandez is a comprehensive guide to the framework.
* [Agile Web Development with Rails 6](https://pragprog.com/titles/rails6/agile-web-development-with-rails-6/) is sort of an in-depth guide combined with a tutorial that follows Agile practices along the way.
* [Rails Antipatterns](http://www.amazon.com/Rails-AntiPatterns-Refactoring-Addison-Wesley-Professional/dp/0321604814) is a good best-practices guide.

## Other resources

* [RailsCasts by Ryan Bates](http://railscasts.com/) are incredibly valuable. Great ways to actually see the implementation of various gems or practices.
* [GoRails](https://gorails.com/) alternative to RailsCasts.
* The [RailsApps Project](https://tutorials.railsapps.org/) provides lots of great tutorials that walk you through building real-life scenarios like integrating Devise and CanCan with your app or building a payments backend.
* [RubyFlow community blog](http://www.rubyflow.com/) will have some interesting stuff pop up from time to time.

## Conclusion

We want to emphasize again that the learning never really stops but also that you've come a long way. Stick around for the next few courses and you'll take a good core and build some very interesting things. In the HTML/CSS course, you'll learn to make your Rails applications look like actual websites instead of text dumps. In the Javascript course, you'll learn how to take everyday web apps and make them much faster and more dynamic in the browser.

So there's a lot left to go but it gets better and better. Stick with it!

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental for if you need to dive deeper into something.

* [How I Learned Ruby on Rails](https://medium.com/how-i-learned-ruby-rails/e08c94e2a51e) by Richardson Dackam
* A [listing of Rails tutorials](https://tutorials.railsapps.org/rails-tutorial) from Daniel Kehoe of RailsApps
* A list of some slightly [longer Rails Tutorials by Jumpstart Lab](http://tutorials.jumpstartlab.com/)
* The [University of Texas Rails Course Online](http://schneems.com/ut-rails) \(incomplete/dated?\)
* [Rails Cheat Sheet](http://pragtob.github.io/rails-beginner-cheatsheet/index.html) by Tobias Pfeiffer
* [Rails Best Practices list](http://rails-bestpractices.com/)
* [Building a Simple CMS in Sinatra Tutorial](http://www.sitepoint.com/a-simple-content-management-system-in-sinatra/)
* [Why not to hardcode your application's secret token in production](http://daniel.fone.net.nz/blog/2013/05/20/a-better-way-to-manage-the-rails-secret-token/)
* [How I Test by Ryan Bates](http://railscasts.com/episodes/275-how-i-test)
* [Why use the `%Q` methods?](http://stackoverflow.com/questions/10144543/what-is-the-use-case-for-rubys-q-q-quoting-methods)
* [Build 10 Apps video series by Web-Crunch](https://www.youtube.com/watch?v=4ABesTeDKmQ&list=PL01nNIgQ4uxNkDZNMON-TrzDVNIk3cOz4)
* [Mackenzie Child 12 apps in 12 weeks](https://medium.com/ruby-on-rails/how-i-finally-learned-rails-95e9b832675b#.mw99m5wat)
* [Intro to API Video](https://www.youtube.com/watch?v=oBW_VNg4qD0)

