---
description: Learn how to build a blog with Rails.
---

# Project: Blog

## Introduction

In this project, you'll get the opportunity to actually build a real Rails application. It's not a trivially simple one either -- it's got a lot of wrinkles and things that you're not going to understand.

To be honest, you're kind of going into the deep end so don't worry if you don't understand what exactly you're doing in all the steps. The point here is to get familiar with the process of creating a Rails app, what things generally look like, and what you don't know. When you get to the end of this project, you can consider yourself remarkably persistent and resilient.

## Assignment

1. Do the [The Ruby on Rails Guides: Getting Started](http://guides.rubyonrails.org/getting_started.html) project through section 8.2, from the Rails Guides. It gives a pretty good overview of the common commands you'll use when using Rails. Section 8.3 is causing a few problems, but they should be resolved soon.
2. You should have Rails installed already so section 3.1 might not be relevant. It still might be prudent to run the `--version` commands to check you have everything you need though.
3. Make sure you commit to git regularly so if you run into any issues you can revert to an earlier commit without having to start over from scratch. As a rough guide look to commit at the end of each section.
4. Pay attention to any error messages you get as you build the app, even though they'll be unplanned.  You'll see all these messages again and again when you're building Rails apps, so it's helpful to start getting familiar with which portions of the message you should pay attention to \(and maybe put into Google if you can't figure out what caused it\).
5. Try to make a mental note of the commands and generators you can use. Rails provides a lot of very helpful generators taking a lot of the pain out of creating different parts of a web application.
6. When you're finished push up your code to [github](https://github.com/)
7. Don't forget to deploy your app to Heroku!

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental for if you need to dive deeper into something.

* The [official Ruby on Rails guides](http://guides.rubyonrails.org/) are an excellent resource if you want to build on your knowledge.
* You can read the [Introduction to Core Ruby Tools](https://launchschool.com/books/core_ruby_tools/read/introduction) from LaunchSchool to get a better understanding of Ruby and Rails concepts such as gems, version managers, bundler, and rake.

