---
description: >-
  Learn everything you need to know in order to start building web applications
  with Ruby on Rails.
---

# Ruby on Rails

## Introduction

Welcome to Rails! Maybe you've skipped right here because you just want to start building websites or maybe you made it through the Ruby course and have a great base to work from. Either way, we're about to have some fun.

This portion of the curriculum will be the most build-heavy so far. You will still be asked to read docs, check out blog posts, and watch videos before building, of course, but projects will be the major focus.

After each lesson or two, you'll be asked to build one or more independent projects utilizing the concepts that were just covered \(which is exactly what we've been doing up until now\).

## The roadmap

After preparing for deployment and installing Rails, we'll be starting with an overview of important topics like HTTP, MVC, REST, APIs, Cookies and Authentication for some context before moving into the really fun stuff.

We'll move front-to-back, starting with the routing layer and moving into controllers and views so you can build a functional \(if not yet pretty\) interface for your data. Next you'll learn about storing and finding data in databases with SQL then how to turn that SQL into Active Record queries. We next cover web forms, an area that has a lot more going on behind the scenes than you might expect, and authentication, which is essential to securing your application. We'll cover some other intermediate topics like state and the asset pipeline to round out your initial understanding of Rails.

But we can't stop there, so we'll get back into ActiveRecord to give you the tools to really make your data dance, as well as the knowledge of the forms that is required to bring that advanced functionality to the User. This is the really important side of Rails, so we'll spend a good bit of time working with it.

Finally, we'll cover additional useful topics like how to send emails from your application, building and interfacing with APIs, design patterns, metaprogramming and advanced routing before having you build your final project.

## Our tools and texts

The most important resource that we'll leverage are the [Rails Guides](http://guides.rubyonrails.org/).

The Guides are comprehensive, basically a completely open-source textbook and reference manual for Rails. At times they'll get a bit more technical than you might like, and it may be okay to skim some of that. When you Google for a solution later, if it's not showing up on Stack Overflow then it's probably going to give you a link to the Guides.

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental for if you need to dive deeper into something.

* [StackOverflow: Summary of Ruby on Rails Fundamental Concepts](http://stackoverflow.com/questions/5205002/summary-of-ruby-on-rails-fundamental-concepts)
* [How to study the Rails Guides](http://www.sihui.io/how-to-study-the-rails-guides/)

