---
description: Learn how to build a shopping cart.
---

# Project: Shopping cart

## Introduction

Now we are getting to our final React application. It's going to be a shopping cart. This application should also have at least two routes to give you a chance to make some use of your newly acquired react-router-dom skills.

## Assignment

1. Create a new project with `create-react-app` and get rid of the boilerplate as in the previous projects.
2. Think about the component and the folder structure. How could you set up your application? Which components or functionalities do you need?
3. You should have at least have two pages \(a homepage and a shop page, which includes your shopping cart\). Let a user navigate between the pages with a navigation bar, which will be shown on both routes.
4. To your homepage, you can add whatever you'd like! A few images or information will be totally fine; it doesn't have to be something fancy. The main goal of the project is to focus on setting up the shopping cart. The homepage is there to practice routing using `react-router-dom`.
5. On your shopping cart route, a user should see a sticky bar \(it can be just a top section as well\), which displays the number of items currently in the cart. You should also have a button next to it where you can go to the cart to checkout and pay \(however we are not going to implement this logic here\).
6. Build individual card items for each of your products. Display an input field on it, which lets a user manually type in how many items they want to buy. Also, add an increment and decrement button next to it for fine-tuning. You can also display a title for each product as well as an "Add To Cart" button.
7. Once a user has submitted their order, the amount on the cart itself should adjust.
8. As usual, style your application so you can show it off!
9. Lastly, push the project to GitHub!

