---
description: Learn how to build a CV with React.
---

# Project: CV

## Introduction

Congratulations, you made it to the first project. In this project, you will be creating a small CV application. It's a great project to get you started, because it includes many of the basic concepts you've learned so far.

## Just a quick reminder

Learning a new technology is never easy. Along the way you might think: "Well, I could easily implement this in plain JavaScript", but don't let that demotivate you. If you keep pushing, you will end up far more productive than you were before with the ability to add a new skill to your skillset.

So let's get started.

## Assignment

1. Create a new project using `npx create-react-app cv-project`. If you need a reminder on how it works, check out the previous lessons. Don't forget to setup a GitHub repository for you project, to push your progress.
2. Remove the boilerplate code created by `create-react-app`.
3. Think about how to structure your application into components. Your application should include:
   * A section to add general information like name, email, phone number.
   * A section to add your educational experience \(school name, title of study, date of study\)
   * A section to add practical experience \(company name, position title, main tasks of your jobs, date from and until when you worked for that company\)
4. Be sure to include an edit and submit button for each section or for the whole CV, your preference. The submit button should submit your form and display the value of your input fields in HTML elements. The edit button should add back \(display\) the input fields, with the previously displayed information as values. In those input fields, you should be able to edit and resubmit the content. You're going to make heavy use of state and props, so make sure you understood those concepts.
5. Create a `components` folder in your `src` directory and add your components.
6. Include a `styles` folder in your `src` directory for your CSS files. You'll need to import these in the component files to use them.
7. Don't forget to push your solution to GitHub. You should be proud of your work and show it off to the world!

Tip: If you're confused on how to deploy using GitHub Pages, take a look at [this article](https://blog.usejournal.com/how-to-deploy-your-react-app-into-github-pages-b2c96292b18e).

