# Project: Going to school

## Introduction

Like we learned in the introduction lesson, Node.js is really just JavaScript. So a basic understanding of JavaScript is necessary in order to understand Node. For this reason, it is highly recommended that you take our prerequisite [JavaScript course](https://www.learnhowtocodebook.com/deep-dives/javascript) before continuing with this course.

This lesson will take you through a tutorial that will teach you the basic modules and functions that you need to get up and running with Node.js. The project that comes right after this assignment will ask you to use Node to create a basic website that will include an `Index`, `About` and `Contact Me` page. So while learning the topics in this lesson, be on the lookout for things that might help you complete the project.

## Learning outcomes

By the end of this lesson, you should be able to do the following:

* Explain some things that Node.js is commonly used for.
* Create and use modules in Node.js \(both built-in and user created\).
* Set up a basic webserver with Node.js using the HTTP module.
* Read, create, update, and delete files from Node.js.
* Use the URL module to parse a url address and split it into readable parts.
* Understand how to use NPM.
* Create, fire and listen for your own events.

## Assignment

* Let's dive in and write your first bit of Node server-side code! Go to the [w3 schools node tutorial](https://www.w3schools.com/nodejs/default.asp) and code along with the following lessons \(which should be listed on the sidebar of their site\):
  * Node.js Intro
  * Node.js Get Started
  * Node.js Modules
  * Node.js HTTP Module
  * Node.js File System
  * Node.js URL Module
  * Node.js NPM
  * Node.js Events
  * The File Uploads and Email lessons are optional at this point but it might be useful to at least skim them so you can know where to look if you need that functionality.

## Knowledge check

This section contains questions for you to check your understanding of this lesson.

**What is a File System Module? How and why would you use it?**

* The Node.js file system module allows you to work with the file system in your computer. It's included by using the require\(\) method and can be used to read, create, update, delete, and rename files.

**What is the command for installing a package locally in with npm?**

* npm install \`package-name\`

**What is the command for installing a package globally in with npm?**

* npm install -g \`package-name\`

**What is the difference between a global and local package install with npm?**

* Global installs are available from anywhere on your computer, local installs are only available within a specified project.

