# Refresher

## Introduction

This course assumes that you have a decent grasp on the fundamentals of JavaScript. If you have recently taken our JavaScript fundamentals series then you will be in good shape to skip this review and move on. If it's been a while, you will probably want to take a day or two to refresh yourself on the basics.

## Review

Running through "part 1" of [MDN's JavaScript basics course](https://developer.mozilla.org/en-US/docs/Learn/Getting_started_with_the_web/JavaScript_basics) or doing the Basic JavaScript portion of [FreeCodeCamp](https://www.freecodecamp.org/learn/javascript-algorithms-and-data-structures/basic-javascript/) is a great idea for a refresher on the syntax. If you just want a quick reference to skim, try [LearnXinY](https://learnxinyminutes.com/docs/javascript/).

It might also be a good idea to do a little practicing before moving on. It may be a good idea to redo one of the later projects from our fundamentals course such as the calculator or rock-paper-scissors. If you want something fresh to work on, now would be a fine time to do some coding exercises from across the net. The following sites are all great places to look.

* [Exercism](http://exercism.io/)
* [CodeWars](https://www.codewars.com/)
* [FreeCodeCamp](https://www.freecodecamp.org/) \(especially their "Object Oriented", "Functional Programming", and "Algorithm Scripting" sections\)
* [JavaScript30](https://javascript30.com/) is a great set of tutorials that cover a ton of JS concepts.

## Why no jQuery?

Before you press on, a note about jQuery. We occasionally get questions about why we don't include jQuery in our curriculum. jQuery was very popular in the past, but has fallen out of the limelight in recent years. One of the biggest reasons it's begun to fall out of favor is that you simply don't _need_ it anymore. When it became popular, doing things like DOM manipulation and AJAX calls were difficult in plain JavaScript, but that is no longer the case.

A quick web-search on the topic will be more useful than any explanations here, and if you still want to learn it \(many older codebases still use it, and you will see it on many older Stack Overflow posts\) we are confident that you can pick it up quite easily by reading the documentation on [their website](https://jquery.com/).

