# Project: All-Star

## Introduction

We hope you enjoyed this course and the projects you've completed. In this last section you'll combine everything you've learned into a project that demonstrates what an all-star you are!

## Assignment

Replicate your favorite website as close as possible - Pinterest, Facebook, Twitter, etc. Just make sure it has lots of interesting functionality. You'll be integrating a full array of skills into this one. If you have completed a backend course, you may use that for this project, otherwise use Firebase. This should prove that you now have all the tools and knowledge needed to build a website, just like the ones you use every day.

Of course, you can't replicate every feature, and the user interface will probably be a bit clunkier. However, if you can get yourself 80% of the way there, that's darn impressive!

1. Set up a GitHub Repo for this project. Follow the instructions in [Git basics](https://www.learnhowtocodebook.com/foundations/git/git-basics) if you need help.
2. Think about what you need to do. It's really helpful to write your plan down on paper or whiteboard ahead of time! A few hours of thought now will save you days of coding. Try to lay it ALL out. An important part of planning is **scope**. You obviously can't build the entire website \(which presumably took a full team of engineers years to produce\), so you'll need to identify the site's core functionality and the "nice-to-have" stuff. **Make sure you finish the core functionality BEFORE working on the rest.** If you try to do everything at once, you'll get lost and frustrated. Trust me. Everything takes longer than you expect.
3. Roll up your sleeves and start building!
4. Try to test the high-level functionality using a suitable testing library, for example, Javascript with Jest or Rails with RSpec. Don't get too bogged down in testing, but try and save yourself time by adding high-level tests, so you don't need to click around 100 times every time you make a change to something that seems important.
5. Once you finish, push to GitHub and share it with the world!

**Congratulations!**

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental for if you need to dive deeper into something.

* [A Rock Solid, Modern Web Stack—Rails 5 API + ActiveAdmin + Create React App on Heroku](https://blog.heroku.com/a-rock-solid-modern-web-stack)
* [How to Build a React App that Works with a Rails 5.1 API](https://www.sitepoint.com/react-rails-5-1/)
* [Firebase Documentation](https://firebase.google.com/)

