# Organization

## Organizing your JavaScript code

One of the most daunting parts of JavaScript is learning how to organize your code. The reason this subject can be so overwhelming is _not_ because JavaScript is so much more complex than other languages, but because it is incredibly forgiving! Many languages force you into using specific patterns and data structures in your code but that is not true in JavaScript.

In the beginning, this is a great thing! For example, if you just want to make a simple button on your webpage do something you can set that up in a couple lines of code. However, as your program becomes more complex, it can become hard to maintain unless you take care to organize your code and because JavaScript is such a flexible language how you do that is entirely up to you. For many coders making decisions about design patterns is crippling so we're here to help.

This lesson series is going to cover a few of the most common design patterns that occur in modern JavaScript code, we will discuss some pros and cons of each pattern and will give you a chance to practice using each pattern in a project.

The patterns we'll be covering in this series are:

* Plain Old JavaScript Objects and Object Constructors
* Factory Functions and the Module Pattern
* Classes
* ES6 Modules

Going through these will give us a chance to learn about a few other important concepts in JavaScript such as "closure", "prototypes", "IIFEs" and more! This series covers the most important parts of JavaScript after simply learning the basics of the language... are you ready?

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental for if you need to dive deeper into something.

* The book [You Don't Know JS \(YDKJS\)](https://github.com/getify/You-Dont-Know-JS/tree/1st-ed#titles) is free on GitHub, and explains how JavaScript works "under the hood". If you ever wondered why JavaScript works the way it does, this book is for you!

