---
description: >-
  Learn everything you need to know in order to start building web applications
  with JavaScript.
---

# JavaScript

## Introduction

JavaScript is the future of the web. More and more of the logic is making its way to the client side in order to facilitate lightning fast user experiences. JavaScript is even moving to the server side with Node.js. That's why in this course we'll be diving deep into it to make sure you come out with a good understanding of how it works.

You've already completed the [Foundations course](https://www.learnhowtocodebook.com/foundations/introduction), right? Good, because now we'll be moving at warp speed into new frontiers. This section will cover a lot of ground and your brain may meltdown a few times, but don't worry, that's just a flesh wound. Patch 'er up and keep going! When in doubt, build something.

## The Path

How is this course set up? It starts with a deeper look at the basics. We won't be focusing deeply on the really basic coding items, so it will move quickly. You should, however, already have completed the [Foundations course](https://www.learnhowtocodebook.com/foundations/introduction), specifically the [frontend section](https://www.learnhowtocodebook.com/foundations/frontend) before starting this course. You might also find this [Git Section](https://www.learnhowtocodebook.com/deep-dives/ruby/git) on more intermediate-level uses of Git helpful.

The last thing you'll do is a final project which integrates everything you've learned in all the courses of this curriculum. This is the kind of project that you'll be telling employers all about and a great chance to prove that you're now, officially, a serious web developer.

## Format

There is a lot to cover, but this course has been broken up into bite-sized lessons and their accompanying projects. These projects will give you a chance to apply what you have learned and to show what you are capable of. After a few of them, you'll really start getting the hang of things.

## In each lesson:

1. We will introduce the topic briefly and provide you with a list of things you should pay attention to \("Points to Ponder"\).
2. You will be asked to do readings, watch videos, do online courses or otherwise consume content to initially learn the material.
3. Every few lessons you will be asked to build a larger project.
4. Finally, we will include supplemental resources and other potentially useful tidbits at the end of each lesson.

**Enough talk, get learning!**

