# Project: Make a form

## Introduction

In this project, you'll get a chance to rebuild the form used by [Mint.com](http://www.mint.com) for signing up new users. They have been highly praised for the design and simplicity of their site, and their signup process is very clean. If the link isn't working for you, an alternative form to rebuild is by [Mailchimp.com](https://login.mailchimp.com/signup/).

The page is very straightforward, so you should be able to clone it even if your CSS skills aren't perfect. As usual, don't worry about any of the dynamic functionality on the page or finding the specific icons they use or having the form actually submit. The point is to make it _look_ like the real page as much as you reasonably can.

## Assignment

1. Go to [Mint.com's signup page](https://wwws.mint.com/login.event?task=S) and have a look around.  The form isn't exceptionally complicated.
2. Follow the instructions atop the [Google Homepage project](https://www.learnhowtocodebook.com/foundations/frontend/project-create-a-web-page) to set up a GitHub repository for this project \(of course you'll need to change the title\).
3. Create a blank HTML document.
4. Plan out how the elements on the page need to be grouped together.
5. Lay out the empty semantic HTML elements for the major sections \(form, sidebar, footer...\) and make them the proper size and alignment.  It may be helpful to change their background colors while you're positioning them on the page.  Don't forget to use your browser's developer tools \(right click on the page, click "inspect element"\)!
6. Fill in those elements with the content you want to include.
7. Now style them to look like the real webpage.
8. Push your solution up to GitHub and you're good to go!

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental for if you need to dive deeper into something.

