# Project: Embedding media

## Introduction

Back in the Foundations course you built Google's homepage. People consistently report that to be a fun project but they also say that it's more difficult than it looks. In this course, you'll build so many webpages that you'll laugh at something as simple as Google.com.

Our first project will require you to draw on your new understanding of working with media by building [YouTube's video player page](https://www.youtube.com/watch?v=V74l_zS1x8E) \(the example video is one describing making contributions to open source\).

The goal here isn't to produce an exact replica of the YouTube video page, but to focus on making the media elements show up. That means two things -- embedding the YouTube video player into the page so it actually plays and showing little thumbnail images along the right side.

How far you go from there in terms of styling is up to you -- some of you will already be more comfortable with CSS than others, so knock yourself out.

There are other elements on the YouTube page which are produced with Javascript and you don't need to worry about them -- basically, anything that changes the page by clicking on it is wired up using Javascript. An example is the "Show more" link below the description, which dynamically expands to show more. Again, don't worry about these dynamic elements!.

Also, don't worry about making the comment form work properly... your goal is to make the page look similar and display video.

## Assignment

1. Follow the instructions atop the [Create a web page](https://www.learnhowtocodebook.com/foundations/frontend/project-create-a-web-page) project to set up a GitHub repository for this project \(of course you'll need to change the title\).
2. Create a blank HTML document.
3. Come up with a plan -- which sections of the page should be grouped together \(e.g. the navigation bar vs the video vs the sidebar etc\)?
4. Create empty semantic HTML elements to enclose those sections.
5. Use basic CSS to size and position them appropriately on the page. It may be helpful to make their backgrounds different colors so you can see the different sections. Don't forget to use your browser's developer tools \(right click on the page, click "inspect element"\)!
6. Now let's start filling in those divs with content by creating the navbar.
7. Watch [this YouTube video on embedding a YouTube video in a webpage](https://www.youtube.com/watch?v=lJIrF4YjHfQ&feature=emb_title).
8. Embed a YouTube video of your choice into your page.
9. Next, build the sidebar section where previews of suggested videos show up. Obviously don't worry about generating those previews... just grab some thumbnail-sized images and plug them in.
10. Next, finish up by filling in some of the elements below the video -- the title, description and number of views. Ignore the icons \(many of them are produced using sprites or more advanced techniques so you won't be able to just grab them by copying them\).
11. Push your solution up to GitHub.

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental for if you need to dive deeper into something.

