# Images and media

## Introduction

Images and other media are an essential part of providing a good user experience and they are ubiquitous on websites today. They are also your biggest, clunkiest set of assets and can ruin your page load times if you're not careful. When your site is slow, the easiest way to get it running faster is to optimize your image sizes and filetypes.

There is also a big difference between each of the image filetypes, so pay attention to the use cases for each. Remember, the trade-offs are usually image size vs quality \(though sometimes you want animation or clear backgrounds too\), so figure out the differences between `gif` and `jpg` and `bmp` and `png` and `svg`.

## Learning outcomes

* What are common attributes of image tags?
* How do you load a smaller version of an image?
* How do you get an image to fill up an element?
* How do you save load times by using appropriately sized images?
* When should you store images externally vs on your server?
* What are the main types of image files and how are they different?
* Which file types let you use animation?
* Which file types let you use transparent colors?
* Which file types are best for photos?  Graphics?
* Which file type lets you scale an image as big as you want without affecting file size \(and why\)?
* What's the difference between raster and vector images?
* How do you add video to your page? \(please don't autoplay...\)
* How do you add audio to your page? \(please don't autoplay...\)

## Assignment

1. Read [Shay Howe on Images and Media \(includes CSS\)](http://learn.shayhowe.com/html-css/images-audio-video)
2. Read about the [Differences between image types \(see first answer\) from SO](http://stackoverflow.com/questions/2336522/png-vs-gif-vs-jpeg-when-best-to-use)
3. Watch this [YouTube video about adding video to your page](https://www.youtube.com/watch?v=4I1WgJz_lmA)
4. Skim through this article about [the difference between raster and vector](https://www.psprint.com/resources/difference-between-raster-vector/). Don’t worry if you don’t absorb it all – you’ll have time to pick it up later.

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental for if you need to dive deeper into something.

* [Another look at differences between image types](http://www.practicalecommerce.com/articles/1821-Image-Formats-What-s-the-Difference-Between-JPG-GIF-PNG-)

