# HTML5

## Introduction

HTML5 brought in a lot of nice new features, many geared specifically towards giving webpages the ability to display media and interactive features more easily. The downside is that there are still browser compatibility issues with some of that functionality, but that will get sorted over time. Another set of new features is the use of more semantic tags in your markup so you don't need to put a `div` around everything \(you can use the `aside` or `footer` etc\).

## Learning outcomes

* What are semantic tags and how are there more of them in HTML5?
* What does the canvas element do for you?
* Seriously, why is canvas potentially amazing?
* What are the new video control features?
* What are the new audio control features?
* What is local storage and how is it used?
* What are data attributes and how are they used?
* For people who have already done Rails and maybe some JS, how can data attributes be used to pass off data from your back end to your front end?
* What are the compatibility trade-offs of the new features?
* Are there any performance trade-offs with the new features?
* How does HTML5 fix the problem of needing Flash installed to play movies on many devices?

## Assignment

1. Check out [Dive into HTML5](http://diveintohtml5.it/), which is a website and book on the cool stuff about HTML5.
2. Look over [What's new in HTML5 from About](http://webdesign.about.com/od/html5/a/html_5_whats_new.htm)

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental for if you need to dive deeper into something.

* [HTML5 - New Tags \(Elements\) from tutorialspoint](https://www.tutorialspoint.com/html5/html5_new_tags.htm)
* [28 must-know HTML5 tips and techniques from tutsplus](https://code.tutsplus.com/tutorials/28-html5-features-tips-and-techniques-you-must-know--net-13520)
* [Testing compliance of various tags in HTML5 with CanIUse?](http://caniuse.com)

