# Forms

## Introduction

Forms are one of the most important parts of your site. They are your user's gateway into your back end -- the user provides data in a form and you do stuff with it.

Forms are important to get right not just because you want the correct data getting sent to your back end but also because you want the experience of interacting with the form to be as dead-stupid-simple as humanly possible so you don't lose users while they are doing it. You need to specify the proper types of inputs for each possible data item, since there are often multiple ways to collect a piece of data but only one way which is easiest for your user and eliminates the chances of that user inputting erroneous data.

## Learning outcomes

* Why are forms probably the most important part of your site?
* How do you construct a basic form?
* How do you specify which path the form gets submitted to?
* When would you want to submit using `GET` vs `POST` requests?
* What are all the possible form element types?
* When should you use checkboxes instead of radio buttons?
* When should you use a combobox/dropdown instead of a text field?
* How do you make a very large text field?
* How do you link elements with their labels?
* How do you link element selections together \(e.g. check boxes\) so they are nicely formatted when your server receives them?
* What should your "submit" button probably say instead of "submit"?

## Assignment

1. Read [Shay Howe on Forms](http://learn.shayhowe.com/html-css/building-forms)
2. Browse through [Form Basics from MDN](https://developer.mozilla.org/en-US/docs/Web/Guide/HTML/Forms/My_first_HTML_form) to see if you've missed anything.

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental for if you need to dive deeper into something.

* [HTML Forms Docs](http://www.w3schools.com/html/html_forms.asp)

