# Project: Your own framework

## Introduction

In this final project, you'll get to take everything you've learned and use it to build your own simple grid-based framework. As with the other final projects, we'll keep it relatively open-ended to give you a chance to exercise your creativity and problem-solving skills. It will be a great project to show off to potential employers as well.

Once you're done setting up your framework, you will use it to clone any website you like. If you're out of ideas, try cloning this website!

## Assignment

You'll be creating your own grid-based framework.

1. Follow the instructions atop the [Google Homepage project](https://www.learnhowtocodebook.com/foundations/frontend/project-create-a-web-page) to set up a GitHub repository for this project \(of course you'll need to change the title\).
2. Create a new CSS document.
3. Think about the major elements that are required of a framework. This includes a CSS reset, a fixed number of grids separated by "gutters", a way to make new rows, and default values for the font properties of elements.
4. Write the CSS necessary to create a basic 12-column grid framework. Check out the [960 Grid System documentation](http://960.gs) for a look at how they do it. The complexity is up to you -- there's no need to go too crazy with details \(you're not trying to rebuild Bootstrap\).
5. Push your framework to GitHub.

### **Applying the framework**

1. Create a new HTML document and a new GitHub repository.
2. Identify the webpage you'd like to clone and break it down into its major elements like we have in the previous projects.
3. Add your framework to your project.
4. Use your framework to lay out the structure of the page.
5. Fill in the necessary details/images etc.
6. Push your solution to GitHub.
7. Have a frosty beverage, you're done with the HTML/CSS projects!

