# Project: Breaking news

## Introduction

The New York Times has been a leader in experimenting with the inclusion of multimedia content in traditional stories. That creates all kinds of interesting position questions.

In this project, your assignment is to copy [this article from the New York Times](http://www.nytimes.com/2014/03/18/science/space/detection-of-waves-in-space-buttresses-landmark-theory-of-big-bang.html?_r=0) \(open in an "incognito" window without cookies to view it if you're over your monthly limit\). Notice how the section titled "The Theory of Inflation" \(you may need to widen your viewing window for it to show up\) is laid out.

You can use any or all of the positioning techniques you've learned in this section. The modern way would be to use Flexbox or Grid. There are certain times where Flexbox and Grid can't achieve the layout you want, knowing floats and other positioning techniques is valuable practice and you should try and use a combination of techniques for this project.

## Assignment

Note: As usual, ignore any ads, comments or interactive elements \(which use JavaScript\) and don't worry about what happens when you change the page width \(they use some media queries to rearrange things\). Focus on making it look similar.

1. Go to [the NYT article in question](http://www.nytimes.com/2014/03/18/science/space/detection-of-waves-in-space-buttresses-landmark-theory-of-big-bang.html?_r=0) and have a look around.
2. Follow the instructions atop the [Google Homepage project](https://www.learnhowtocodebook.com/foundations/frontend/project-create-a-web-page) to set up a GitHub repository for this project \(of course you'll need to change the title\).
3. Create a new HTML document.
4. Think about all the elements on the page and how they are grouped together.
5. Lay out the basic structure of the page using empty semantic HTML elements that are appropriately sized and positioned.  You may want to make their background colors different so you can see them.  Don't forget to use your browser's developer tools \(right click on the page, click "Inspect Element"\)!
6. Set up the top navigation bar \(again, don't worry about making it change when you scroll down the page\).  How can you get it to stick to the top of the page as you scroll down?
7. Fill in and position the additional sections.  Don't worry about enclosing every paragraph of text in `<p>` tags.
8. Push your solution to GitHub.

