# Preprocessors

## Introduction

Preprocessors \(aka precompilers\) can make your life much easier by eliminating code repetition and providing all sorts of yummy time-saving and code-saving features. If you've been using Rails, you'll be familiar with SASS already since it's baked in. If you're not using Rails, you may need to add some additional steps to your workflow to get your preprocessor set up but it's worth it.

## Learning outcomes

* What is a preprocessor?
* Why do preprocessors rock?
* What does it mean that a preprocessor "compiles to CSS"?
* What is SASS/SCSS?
* How can you use SASS to nest CSS?
* How can you use SASS to work with variables in your code?
* Why is it awesome to use mix-ins with SASS?
* If you're not using Rails, how do you set up SASS?
* What is LESS and how is it different from SASS?
* What other preprocessors are out there?

## Assignment

1. Read [Introduction to CSS Preprocessors from Steven Bradley](http://www.vanseodesign.com/css/css-preprocessors/)
2. Read [6 Reasons You Should Use a Preprocessor](https://raygun.com/blog/6-reasons-you-should-use-a-css-preprocessor/)
3. Read [Choosing the Right CSS Preprocessor from Treehouse](http://blog.teamtreehouse.com/how-to-choose-the-right-css-preprocessor)
4. Look over [SASS's getting started guide, which provides a brief look at its awesome features](http://sass-lang.com/guide)
5. [A List Apart walks through specifically how you should be using SASS \(lots of best practices in there\)](http://alistapart.com/article/getting-started-with-sass) so read up and enjoy!

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental for if you need to dive deeper into something.

* [SASS's main website](http://sass-lang.com/)
* [LESS's main website](http://www.lesscss.org/)

