# Flexbox

## Introduction

Floats were never intended for layout, however clever developers found ways in which to use them to create their layouts. Having worked with floats you may have noticed some limitations and bugs \(clearfix anyone? vertical centering?\).

## Learning outcomes

* How do you define a flex container?
* What items will become a flex-item?
* Can a flex item also be a flex container?
* When to use Flexbox?
* What is the difference between `justify-content` and `align-items`.
* How can you change the direction of the axis of Flexbox. What will this do to `justify-content` and `align items`?
* How do you change the display order of content with Flexbox. What is a drawback with this \(for screen readers\)?

## Overview

Flexbox is a new layout mode in CSS3 initially developed by Mozilla to make layouts. There were 3 different iterations of the flex property, the final 2012 spec — `display: flex` has excellent [browser support](https://caniuse.com/#search=flex). The current Flexbox spec is fully supported in all modern browsers, including mobile, IE11 and Edge.

## Assignment

* Watch [Wes Bos'](https://twitter.com/wesbos) tutorial [What the Flexbox?!](https://flexbox.io/). This course consists of 20 videos covering Flexbox and are all available to [watch on YouTube](https://www.youtube.com/playlist?list=PLu8EoSxDXHP7xj_y6NIAhy0wuCd4uVdid). 
* Once you have completed the course you can read through [CSS-Tricks Complete Guide to Flexbox](https://css-tricks.com/snippets/css/a-guide-to-flexbox/) if you want more in depth information. 
* Read through [Interneting is hard's](https://www.internetingishard.com/html-and-css/flexbox/) tutorial to see how to use Flexbox to help create flexible layouts.

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental for if you need to dive deeper into something.

* Try the interactive [Flexbox froggy](http://flexboxfroggy.com/) game.
* This [MDN Flex article](https://developer.mozilla.org/en-US/docs/Web/CSS/flex), which shows examples of what you can achieve with Flexbox.
* [Dive Into Flexbox](https://bocoup.com/blog/dive-into-flexbox) is an in depth article with examples.

