# Box model

## Introduction

To do CSS correctly, you need to have a model in your head for how everything fits together on the page. Otherwise, you're just randomly guessing and checking what works to move things around. The Box Model is that model. It defines how every element on the page gets placed and how they relate to each other.

You can't be shaky on how it works if you want to be efficient with your work flow. So take the time to really nail down your mental model for how elements interact with each other on the page.

## Learning outcomes

* What's the difference between margin and padding?
* How do borders affect the size of the box?
* How can margins be used to center an element horizontally on the page?
* What does it mean that "margins are collapsed"?
* What is the difference between `block`, `inline-block` and `inline` elements when thinking about the box model?
* When are you required to specify the width of an element vs letting the browser figure it out for you?
* How do box shadows affect element box sizing?
* How can you check an element's box model in your developer tools \(it's a helpful graphic\)?

## Assignment

1. Read the [CSS Box Model from Shaye Howe \(gets into floats and positioning a bit too\)](http://learn.shayhowe.com/html-css/box-model)
2. Read [The CSS Box Model from CSS-Tricks](http://css-tricks.com/the-css-box-model/)

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental for if you need to dive deeper into something.

* [CSS Box Model Docs](http://www.w3schools.com/css/css_boxmodel.asp)

