# Backgrounds and gradients

## Introduction

Backgrounds are usually ignored until they become a problem and then you're left trying to figure out why your elements are coming out looking so odd. This brief section should get you thinking properly about backgrounds and the kinds of things you can do with them by just using regular old CSS.

## Learning outcomes

* How do you set the background color?
* Which color is used when elements are stacked on top of each other \(on the z-axis\)?
* How do you set a partially transparent color? \(rgba anyone?\)
* Where are gradients most commonly used in "real world" websites?
* How do you set a gradient background?
* How do you make an image the background of an element?
* Why is it useful to make the image the background of an element instead of using a regular `<img>` tag?
* How do you make a background image of a fixed size?
* How do you make a background image repeat?
* How do you get your page's background image to fill the page even when you resize the browser?

## Assignment

1. Read [Shay Howe on Backgrounds & Gradients](http://learn.shayhowe.com/html-css/setting-backgrounds-and-gradients/)
2. Skim through this [CSS Tricks article](https://css-tricks.com/css3-gradients/) on the different types of gradients

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental for if you need to dive deeper into something.

* [CSS Backgrounds](http://www.w3schools.com/css/css_background.asp)
* [Do you really understand CSS linear-gradients?](https://patrickbrosset.com/articles/2015-03-27-do-you-really-understand-CSS-linear-gradients/)

