# CSS Basics

## Introduction

This again should represent a review from what you've already covered in the [Foundations Lesson on HTML/CSS](https://www.learnhowtocodebook.com/foundations/frontend/html-and-css), but if you're unable to answer the questions posed below in the "Learning Outcomes" section, you could probably benefit from the review of the basic stuff.

## Learning outcomes

* What are selectors?
* In general, how specific should you be when targeting elements using selectors?
* What's the difference between using `%`, `em` and `rem` to specify sizes?
* How do you select an element inside another element?
* How can you shorten up a long batch of CSS that's doing the same thing to many different elements by putting them all in one line?
* How do you target the immediate child of an element?
* How do you target a class inside a class?
* How do you target a class inside an ID?
* How would you target "all the links inside `li` elements that have the class `bunny` which are inside the unordered list with the id `things-that-hop`"?
* What are the three ways to include CSS in your project?
* How do you import an external stylesheet?
* What is the browser's default stylesheet?
* What is a "CSS Reset" file and why is it helpful?
* Which stylesheet has preference if you import multiple ones and there are overlapping styles?
* What is the order of priority of selectors \(e.g. if you specify that the `<body>` has color `black` but `<h1>` tags have the color `blue` but class `main-title` has the color `red`, which will be used by `<body style="color:yellow"><h1 class="main-title" style="color:green">Howdy!</h1><body>`?\)

## Assignment

1. Read [Shay Howe on the Basics of HTML/CSS](https://learn.shayhowe.com/html-css/getting-to-know-css/).
2. Read [CSS Tricks on Attribute Selectors](https://css-tricks.com/attribute-selectors/).

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental for if you need to dive deeper into something.

* [Learn CSS Selectors Interactively Using CSS Diner](http://flukeout.github.io/)
* [Smashing Magazine on Taming Advanced CSS Selectors](http://coding.smashingmagazine.com/2009/08/17/taming-advanced-css-selectors/)

