# Responsive design

## Introduction

Responsive design is creating websites that respond to the user's context, whether that is the device they are viewing on, the size of their browser, or their accessibility needs. Lucky for you, there are lots of good tools that help you easily start making websites responsive. It's not rocket science to do a pretty good job at a responsive site, though it's a lot more work to get one that really nails it.

## Learning outcomes

* What is responsive design?
* Why is responsive design important to your users?
* How do you make a "fluid" layout?
* What are Media Queries?
* How do you use media queries to make your website responsive?

## Assignment

1. Read [A List Apart's comprehensive introduction to responsive design](http://alistapart.com/article/responsive-web-design)
2. Read over the [Responsive Web Tutorial from Lingulo](http://www.lingulo.com/tutorials/css/how-to-build-a-html5-website-from-scratch), though you don't have to build it.

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental for if you need to dive deeper into something.

* [Responsive Grids Tutorial from TutsPlus](http://webdesign.tutsplus.com/tutorials/htmlcss-tutorials/a-basic-responsive-grid-plus-handy-css3-media-query-reporter/)
* [Responsive Navigation Patterns from Brad Frost](https://bradfrost.com/blog/post/responsive-nav-patterns/)
* [Techniques for Gracefully Degrading Media Queries](http://coding.smashingmagazine.com/2011/08/10/techniques-for-gracefully-degrading-media-queries/)
* [Best Practices of Responsive Web Design](https://medium.com/level-up-web/best-practices-of-responsive-web-design-6da8578f65c4)
* [An approach to Responsive design by Kevin Powell](https://www.youtube.com/watch?v=0ohtVzCSHqs)

