# Project: Teardown

## Introduction

In this simple project, you'll be breaking apart the website for a popular design magazine with which you're probably familiar by now -- [Smashing Magazine](http://smashingmagazine.com). The goal for this exercise is to start training yourself to think in terms of visual hierarchy, typography and design principles.

Your job is to create a grayscale heat map of the website that indicates which elements have the greatest weight in the visual hierarchy. For inspiration, check out [this image from vanseodesign.com](https://web.archive.org/web/20170628134444/http://www.vanseodesign.com/blog/wp-content/uploads/2009/12/visual-hierarchy-compared.png) which compares a site layout with no differentiation on the left to one with a thoughtful hierarchy on the right. Your final product will look much like the site on the right.

This is also an opportunity to get better at positioning `<div>` elements without worrying too much about what's inside them, which will serve you well later.

## Assignment

### **Playing with visual hierarchy**

1. Go to [Smashing Magazine's website](http://smashingmagazine.com) and check out their homepage.  Think about where your eye got drawn to first, second, and third on the page.  What elements on the page carry the greatest visual weight?
2. Think for a minute about whether or not they've achieved the right hierarchy for getting you to consume content on their site.  What's distracting?
3. Follow the instructions atop the [Google Homepage project](https://www.learnhowtocodebook.com/foundations/frontend/project-create-a-web-page) to set up a GitHub repository for this project \(of course you'll need to change the title\).
4. Create a new HTML document.
5. Think about all the elements on the Smashing homepage and how they are grouped together.
6. Copy the basic structure of the page using empty semantic HTML elements that are appropriately sized and positioned.
7. Now make the background colors of those divs different shades of gray which correspond to their visual weight on the Smashing homepage.  If you squint your eyes and look from your solution to their page, does your eye get drawn to the same places?

### **Playing with typography**

1. Add in some meaningless text to those divs \(whether copied from the homepage or a [lorem ipsum generator](http://generator.lorem-ipsum.info)\) for the main headlines and paragraphs.  You'll obviously want to change the div backgrounds back to white for those elements. You only need to add text to the main content areas, don't worry too much about the side areas and navigation.
2. Change around the font styles and weights and see how that affects the visual weight and feel of the page.  You should see some major differences between using serif and sans-serif fonts as well as moving from font-weight 100 to 700.
3. Load in a few web fonts from the [Google Web Fonts](https://www.google.com/fonts) page you saw in the lesson on fonts to test those out too.
4. Find a font/weight combination that approximates that of the original Smashing homepage and apply it to your solution.
5. Push your solution to GitHub.

