# Project: Mobile friendly

## Introduction

In this project, you'll get the chance to build a responsive website. We'll be analyzing [The Next Web](http://thenextweb.com), a tech-focused magazine which uses media queries to gracefully degrade their site as the window size is reduced.

The process will be quite similar to what we've done before. At this point, you should be much faster at setting up a site layout and positioning the elements than when you first started.

## Assignment

As usual, don't worry about the small stuff like sharing buttons or comments or javascript-enabled widgets like the endless scroll feature.

1. Visit [The Next Web](http://thenextweb.com) and poke around their home page.  Play with changing the window width and see how the site changes \(for instance when the sidebar gets hidden\).
2. Follow the instructions atop the [Google Homepage project](https://www.learnhowtocodebook.com/foundations/frontend/project-create-a-web-page) to set up a GitHub repository for this project \(of course you'll need to change the title\).
3. Create a new HTML document.
4. Think about all the elements on the page and how they are grouped together.
5. Research "responsive design mode" for your browser, and then use it to discover which browser widths are "breakpoints" where element properties change \(e.g. the sidebar disappearing\).  Make a plan for which elements need to be modified at which widths.
6. Lay out the basic structure of a page using empty semantic HTML elements that are appropriately sized and positioned.  Make the background colors different so you can see them.  Don't forget to use your browser's developer tools \(right click on the page, click "inspect element"\)!
7. Now -- before you've filled in any of these divs -- add in the media queries and positioning/floating attributes that are needed to make them rearrange as necessary when the browser changes sizes.
8. Once you've got the page layout performing as it should, fill in the divs and style them to look like the original homepage.  Don't get lost in the details -- it's okay if it isn't exact.
9. Double check that all the elements still behave just like the original when the browser size is changed.
10. Push your solution to GitHub.

