# Grids

## Introduction

Grids are another extension of the design world. There's just something much more pleasing about navigating through a site that properly uses a grid to lay out the content than one which has ignored all the C.R.A.P principles and put things in place willy-nilly.

In this section, you'll get a look at how to use CSS to lay out the elements of your page using a grid.

## Learning outcomes

* Why are grids effective for helping site layout?
* What are the major different types of grids in use today?
* How could you design your own grid \(on paper\)?
* How can you implement your own grid in CSS?

## Assignment

1. Read [Basic Grids from CSS-Tricks](http://css-tricks.com/dont-overthink-it-grids/).
2. Read [Fluid Grids from A List Apart](http://alistapart.com/article/fluidgrids).
3. Read through the [Responsive Grid with Media Queries Tutorial from TutsPlus](http://webdesign.tutsplus.com/tutorials/a-basic-responsive-grid-plus-handy-css3-media-query-reporter--webdesign-5121).  You don't need to actually build it, but feel free to.
4. Glance through [Unsemantic](https://unsemantic.com), which is a fluid grid system which can be really useful for building layouts. They have demos that you can take a look at. Just look through the site; we'll be covering the Bootstrap and Foundation grid systems later.

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental for if you need to dive deeper into something.

* [Supplemental reading on the history of grids and why they're awesome](https://web.archive.org/web/20130906170258/http://www.subtraction.com/pics/0703/grids_are_good.pdf)
* [Getting images to display fluidly in fluid grids, from A List Apart](http://alistapart.com/article/fluid-images)
* [CSS Grids Lessons](https://hackdesign.org/lessons/32)

