# Fonts and typography

## Introduction

Something like 95% of the web is text and yet most web developers don't pay any heed whatsoever to typography -- it's this mysterious esoteric subject reserved for designer geeks and their lattes. You are not "most web developers".

Typography is important stuff! It can have a major effect on how your page _feels_ when the user is reading through it and can also influence how easy the page is to digest, both major factors in your user deciding to continue or turn back. You got introduced to it in the section on Design and UX, and here you'll see it implemented.

Do what you can to get at least a familiarity with the high level decisions involved with choosing a typeface and font sizes. You don't need to dive into kerning and what ligatures are, but you should understand when it's appropriate to use serif vs sans-serif fonts and how font weights and line heights impact readability \(recall how to build a good visual hierarchy\).

## Learning outcomes

* Why do fonts matter?
* What's the difference between a serif and sans-serif font?
* What are `font-family` attributes used for?
* How is the active font determined in a `font-family`?
* Where does the browser actually get its fonts from?
* Where can you get additional fonts from and how do you get them onto your page?
* What are the disadvantages of using web fonts? Of loading your own?
* What are the important properties of fonts that you can specify using CSS?

## Assignment

1. Read [Shay Howe on Fonts and Typography](http://learn.shayhowe.com/html-css/typography)
2. Browse through [A Beginner's Guide to Using Google Web Fonts by DesignShack](http://designshack.net/articles/css/a-beginners-guide-to-using-google-web-fonts/), but don't get too lost in the details.
3. Browse the [Google Web Fonts](http://www.google.com/fonts) and see if any of them seem interesting to you.

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental for if you need to dive deeper into something.

* [Importing your own fonts](http://www.html5rocks.com/en/tutorials/webfonts/quick/)

