# CSS frameworks

## Introduction

You've spent plenty of time building up a great base of knowledge of HTML and CSS and even design. But it's still a pain in the butt to lay out everything manually and keep repeating yourself all the time when writing your code. If only there was a way to save yourself all kinds of effort...

Frameworks to the rescue! Frameworks like [Twitter Bootstrap](http://getbootstrap.com) and [Zurb Foundation](http://foundation.zurb.com) have done all the heavy lifting of packaging up commonly used CSS code and even icons and interactions \(like menu dropdowns\) for you. All you have to do is understand how they expect you to lay out your site and which classes they use to designate particular batches of styles.

Frameworks let you focus more on building great sites and less on how they are actually coded up on the front end. They are great for learning and great for rapidly producing sites. Once you've taken a tour through Bootstrap, you'll start looking at every site you see \(especially startup ones\) and notice an awful lot of similarities... one of the downsides of the frameworks.

## Learning outcomes

* What are CSS frameworks?
* How do frameworks actually work?
* How do you interact with the framework to get the look you want?
* What is Twitter Bootstrap?
* What is Zurb Foundation?
* What is TailwindCSS?
* What other frameworks can you find out there?
* What are the disadvantages of using frameworks?

## Assignment

1. Read [From A List Apart, Frameworks for Designers](http://alistapart.com/article/frameworksfordesigners)
2. Read [From A List Apart, Building Twitter Bootstrap](http://alistapart.com/article/building-twitter-bootstrap)
3. [Choosing Bootstrap or Foundation](https://medium.com/@davegenge/bootstrap-vs-foundation-which-front-end-framework-to-use-e85319258b88)
4. Browse through [Getting Started with Foundation](https://get.foundation/sites/docs/) for an idea of how that framework operates.  Observe the similarities and differences between that and Bootstrap.
5. Take a brief look at [TailwindCSS](https://tailwindcss.com/) for a more unique and modern approach to CSS frameworks.

## Additional resources

This section contains helpful links to other content. It isn't required, so consider it supplemental for if you need to dive deeper into something.

* [Bootstrap 4 Grid System](https://www.w3schools.com/bootstrap4/bootstrap_grid_system.asp)
* [If you're used to using Bootstrap 3, here's what changed in version 4](https://www.bootstrapdash.com/bootstrap-3-vs-4/)
* [Bootstrap Docs](http://getbootstrap.com/)
* [Foundation Docs](http://foundation.zurb.com/)
* [TailwindCSS Docs](https://tailwindcss.com/)

