---
description: >-
  Learn everything you need to know in order to start designing web interfaces
  and shaping user experiences.
---

# Design / UX

## Introduction

You can't code the front end and ignore design and user experience \(UX\). Not everyone is cut out to be an artist and you don't have to be. But you do have to actually use your design brain a little bit if you want a site your users actually care about visiting. That doesn't mean just having beautiful graphics, which is a common misconception about design.

User Experience is really about focusing on three things -- can the user get done what they are trying to do **effectively**, **efficiently**, and with **satisfaction**. Half the battle is just having the mindset of trying to optimize those three things by talking to your users. The other half is about actually building and measuring those things.

Web design is more than just building "pretty" things; it's about crafting useful and effective experiences for your users. It starts with making your site fast and reliable. Then you need to properly set up the structure and information architecture of the page so users have a logical schema for navigation. Then you will build your user interfaces for optimal user experience. Only then, finally, can you worry about aesthetics.

Given the focus web design has on crafting an effective user experience, which is the only way to have a successful website, it's probably worth spending a little time to absorb the high level stuff, huh? You don't want to go too crazy, though -- this is definitely a rabbit hole where you can spend way too much time trying to learn everything there is to know about UX or Design.

Remember that your goal here is to absorb the most important concepts and continue on your way. You can always come back when you've got enough experience to start asking the right questions.

## Learning outcomes

* What is design?
* What is user experience?
* What's the difference between UX and UI?
* What are the three things UX is meant to focus on?
* What is visual hierarchy and why is it so important for websites?
* What are the primary ways to achieve visual hierarchy?
* What is the design hierarchy pyramid?
* What are the CRAP factors of effective layout and what are they used for?

## Assignment

1. Read [Startups, This is How Design Works](http://startupsthisishowdesignworks.com/)
2. Read [UX 101 -- What is User Experience](https://web.archive.org/web/20190825035454/https://www.homestead.com/blog/06/2013/ux-101-what-user-experience-infographic)
3. Get [a more detailed look at what UX really is from Smashing Magazine](http://uxdesign.smashingmagazine.com/2010/10/05/what-is-user-experience-design-overview-tools-and-resources/).  Don't worry about absorbing all the tools and techniques... focus on the high level stuff at the top.
4. Read [a very simple overview of Visual Hierarchy from 52weeksofUX](http://52weeksofux.com/post/443828775/visual-hierarchy)
5. Read about the [C.R.A.P Design Principles](http://www.presentationzen.com/chapter6_spread.pdf), which you've been subconsciously aware of for years.

## Additional resources

For if you just can't get enough UX/Design. Don't get too sidetracked... eye on the prize! Eye on the prize!

* [Hack Design's full 52-week free design course](http://hackdesign.org)
* [52 Weeks of UX's free 52 weeks of UX articles](http://52weeksofux.com/)
* [Introduction to Visual Hierarchy from Formed Function](http://blog.formedfunction.com/post/3029763425/on-visual-hierarchy)
* [Understanding Visual Hierarchy in Web Design from TutsPlus](http://webdesign.tutsplus.com/articles/design-theory/understanding-visual-hierarchy-in-web-design/)
* [The Hierarchy of Design Elements from Jesse James Garrett](http://www.jjg.net/elements/pdf/elements_ch02.pdf)
* [Videos from an Adobe Dev Evangelist](http://designupdate.com/) that describe various aspects of design.
* [Using Photoshop to Design Interfaces](http://nathanbarry.com/how-to-use-photoshop-to-design-interfaces/)
* [A more abstract article on "Learning to See" from ia.net](http://ia.net/blog/learning-to-see/)
* [Usability 101 for Startups from Ripul Kumar](https://medium.com/design-ux/dc849621262f)
* [A large collection of free ux books](http://www.uxpin.com/knowledge.html%20)
* [This very extensive free ux course](https://www.mysliderule.com/learning-paths/user-experience-design%20)

