---
description: >-
  Learn everything you need to know in order to have a good grasp on the
  fundamentals of Computer Science.
---

# Computer Science

## Getting started

This course is not about teaching you the ins and outs of a language, although you will be doing some coding for some of the exercises in this course. Instead, what this course is about is teaching you some concepts that you will be taking with you into almost any language you choose to learn.

Computer Science itself is an extremely broad subject concerning everything from hardware to the very low level, bare metal of how software works. This course will not cover all of it; only a small chunk of the subject of writing code and understanding some of the lingo that Computer Scientists/Programmers love to throw around. Specifically, we will be covering the following subjects in considerable detail:

* Pseudo-code and what Algorithms are
* Recursion, it's benefits and it's pitfalls
* Iteration vs Recursion
* Specific, commonly mentioned algorithms
* Time and Space Complexity, and Big O.
* Commonly used data structures, and how to make them
* A more general idea of data structures

## Prerequisites

Before taking on this course, you should have some knowledge of the basics of at least one programming language. If you don't, check out this site's courses on `Javascript` and `Ruby`. You _don't_ have to know their entire course matter to do this course; but knowing about functions and objects and how to use them is _**strongly**_ encouraged. Although also not necessary, a basic understanding of mathematics \(indices and logarithms\) will also help you follow what's going on when we get to talking Time and Space Complexity!

## How this course will work

The next lesson will discuss a concept called `pseudo-code`; with an example. Most `"coding"` examples demonstrated in this course will be making use of `pseudo-code`, so you will be writing down some `pseudo-code` of your own; or following on by implementing said `pseudo-code` in a language _**of your choice**_. The project work and assignment exercises in this course _**will**_ be in the language of your choice.

## Assignment

1. Brush up on your maths, and understand what factorials, indices and logarithms are.
2. If you haven't already learned the basics of a language, do so. Consider [Ruby](https://www.learnhowtocodebook.com/deep-dives/ruby) or [JavaScript](https://www.learnhowtocodebook.com/deep-dives/javascript).

