# Table of contents

* [Welcome](README.md)

## Foundations

* [Introduction](foundations/introduction/README.md)
  * [Becoming a web developer](foundations/introduction/becoming-a-web-developer.md)
  * [Motivation and mindset](foundations/introduction/motivation-and-mindset.md)
  * [Join a supportive community](foundations/introduction/join-a-supportive-community.md)
  * [How does the web work?](foundations/introduction/how-does-the-web-work.md)
* [Requirements](foundations/requirements/README.md)
  * [Prerequisites](foundations/requirements/prerequisites.md)
  * [Text editors](foundations/requirements/text-editors.md)
  * [Command line basics](foundations/requirements/command-line-basics.md)
  * [Setting up Git](foundations/requirements/setting-up-git.md)
  * [Setting up Node](foundations/requirements/setting-up-node.md)
* [Git](foundations/git/README.md)
  * [Git basics](foundations/git/git-basics.md)
  * [Project: Practicing Git](foundations/git/project-practicing-git.md)
* [Frontend](foundations/frontend/README.md)
  * [HTML and CSS](foundations/frontend/html-and-css.md)
  * [Developer Tools](foundations/frontend/developer-tools.md)
  * [Project: Create a web page](foundations/frontend/project-create-a-web-page.md)
* [JavaScript](foundations/javascript/README.md)
  * [Strings and Conditionals](foundations/javascript/strings-and-conditionals.md)
  * [Using Developer Tools](foundations/javascript/using-developer-tools.md)
  * [Functions](foundations/javascript/functions.md)
  * [Problem solving](foundations/javascript/problem-solving.md)
  * [Project: Rock paper scissors](foundations/javascript/project-rock-paper-scissors.md)
  * [Writing clean code](foundations/javascript/writing-clean-code.md)
  * [Arrays and Loops](foundations/javascript/arrays-and-loops.md)
  * [The DOM](foundations/javascript/the-dom.md)
  * [Project: Etch-A-Sketch](foundations/javascript/project-etch-a-sketch.md)
  * [Objects and More Arrays](foundations/javascript/objects-and-more-arrays.md)
  * [Project: Calculator](foundations/javascript/project-calculator.md)
* [Backend](foundations/backend/README.md)
  * [Frameworks](foundations/backend/frameworks.md)
* [Next steps](foundations/next-steps.md)

## Deep dives

* [Computer Science](deep-dives/computer-science/README.md)
  * [Pseudocode and algorithms](deep-dives/computer-science/pseudocode-and-algorithms.md)
  * [Recursion and algorithms](deep-dives/computer-science/recursion-and-algorithms/README.md)
    * [Project: Fibs and sorting](deep-dives/computer-science/recursion-and-algorithms/project-fibs-and-sorting.md)
    * [More on algorithms](deep-dives/computer-science/recursion-and-algorithms/more-on-algorithms.md)
    * [Big O](deep-dives/computer-science/recursion-and-algorithms/big-o.md)
    * [Project: Practicing Big O](deep-dives/computer-science/recursion-and-algorithms/project-practicing-big-o.md)
  * [Data structures](deep-dives/computer-science/data-structures/README.md)
    * [Maps, Stacks and Queues](deep-dives/computer-science/data-structures/maps-stacks-and-queues.md)
    * [Project: Stacks and Queues](deep-dives/computer-science/data-structures/project-stacks-and-queues.md)
    * [Nodes, Linked Lists and Trees](deep-dives/computer-science/data-structures/nodes-linked-lists-and-trees.md)
    * [Project: Linked Lists](deep-dives/computer-science/data-structures/project-linked-lists.md)
    * [Project: Trees](deep-dives/computer-science/data-structures/project-trees.md)
    * [Next steps](deep-dives/computer-science/data-structures/next-steps.md)
* [Databases](deep-dives/databases/README.md)
  * [Databases and SQL](deep-dives/databases/databases-and-sql.md)
  * [Project: SQL Zoo](deep-dives/databases/project-sql-zoo.md)
* [Design / UX](deep-dives/design-ux/README.md)
  * [Fonts and typography](deep-dives/design-ux/fonts-and-typography.md)
  * [Grids](deep-dives/design-ux/grids.md)
  * [Project: Teardown](deep-dives/design-ux/project-teardown.md)
  * [Responsive design](deep-dives/design-ux/responsive-design-1.md)
  * [Project: Mobile friendly](deep-dives/design-ux/project-mobile-friendly.md)
  * [CSS frameworks](deep-dives/design-ux/css-frameworks.md)
  * [Project: Bootstrapping](deep-dives/design-ux/project-bootstrapping.md)
* [HTML / CSS](deep-dives/html-css/README.md)
  * [HTML Basics](deep-dives/html-css/html-basics/README.md)
    * [Linking](deep-dives/html-css/html-basics/linking.md)
    * [Images and media](deep-dives/html-css/html-basics/images-and-media.md)
    * [Project: Embedding media](deep-dives/html-css/html-basics/project-embedding-media.md)
    * [HTML5](deep-dives/html-css/html-basics/html5.md)
    * [Tables](deep-dives/html-css/html-basics/tables.md)
    * [Lists](deep-dives/html-css/html-basics/lists.md)
    * [Forms](deep-dives/html-css/html-basics/forms.md)
    * [Project: Make a form](deep-dives/html-css/html-basics/project-make-a-form.md)
  * [CSS Basics](deep-dives/html-css/css-basics/README.md)
    * [Box model](deep-dives/html-css/css-basics/box-model.md)
    * [Floats and positioning](deep-dives/html-css/css-basics/floats-and-positioning.md)
    * [Flexbox](deep-dives/html-css/css-basics/flexbox.md)
    * [Grids](deep-dives/html-css/css-basics/grids.md)
    * [Project: Breaking news](deep-dives/html-css/css-basics/project-breaking-news.md)
    * [Best practices](deep-dives/html-css/css-basics/best-practices.md)
    * [Backgrounds and gradients](deep-dives/html-css/css-basics/backgrounds-and-gradients.md)
    * [Project: One more thing](deep-dives/html-css/css-basics/project-one-more-thing.md)
    * [CSS3](deep-dives/html-css/css-basics/css3.md)
    * [Preprocessors](deep-dives/html-css/css-basics/preprocessors.md)
    * [Project: Your own framework](deep-dives/html-css/css-basics/project-your-own-framework.md)
  * [Next steps](deep-dives/html-css/next-steps.md)
* [JavaScript](deep-dives/javascript/README.md)
  * [Refresher](deep-dives/javascript/refresher.md)
  * [Organization](deep-dives/javascript/code.md)
  * [Objects and constructors](deep-dives/javascript/objects-and-constructors.md)
  * [Project: Library](deep-dives/javascript/project-library.md)
  * [Factory functions and module patterns](deep-dives/javascript/factory-functions-modules.md)
  * [Project: Tic Tac Toe](deep-dives/javascript/project-tic-tac-toe.md)
  * [Classes](deep-dives/javascript/classes.md)
  * [ES6 Modules](deep-dives/javascript/es6-modules.md)
  * [Project: Restaurant](deep-dives/javascript/project-restaurant.md)
  * [Object Oriented Programming](deep-dives/javascript/object-oriented-programming.md)
  * [Project: Todo list](deep-dives/javascript/project-todo-list.md)
  * [Linting](deep-dives/javascript/linting.md)
  * [Menus and sliders](deep-dives/javascript/menus-and-sliders.md)
  * [Forms](deep-dives/javascript/forms.md)
  * [ES6 features](deep-dives/javascript/es6-features.md)
  * [JSON](deep-dives/javascript/json.md)
  * [Callbacks and promises](deep-dives/javascript/callbacks-and-promises.md)
  * [Using APIs](deep-dives/javascript/using-apis.md)
  * [Async and Await](deep-dives/javascript/async-and-await.md)
  * [Project: Weather](deep-dives/javascript/project-weather.md)
  * [Testing](deep-dives/javascript/testing.md)
  * [Project: Testing 1-2-3](deep-dives/javascript/project-testing-1-2-3.md)
  * [Advanced Testing](deep-dives/javascript/advanced-testing.md)
  * [Project: Battleship](deep-dives/javascript/project-battleship.md)
  * [Backends](deep-dives/javascript/backends.md)
  * [Project: Where's Waldo?](deep-dives/javascript/project-wheres-waldo.md)
  * [Project: All-Star](deep-dives/javascript/project-all-star.md)
  * [Next steps](deep-dives/javascript/next-steps.md)
* [NodeJS](deep-dives/nodejs/README.md)
  * [Project: Going to school](deep-dives/nodejs/project-going-to-school.md)
  * [Project: Passing the test](deep-dives/nodejs/project-passing-the-test.md)
  * [Express](deep-dives/nodejs/express/README.md)
    * [Templates and middleware](deep-dives/nodejs/express/templates-and-middleware.md)
    * [CRUD and MVC](deep-dives/nodejs/express/crud-and-mvc.md)
    * [Project: Message board](deep-dives/nodejs/express/project-message-board.md)
    * [Routes](deep-dives/nodejs/express/routes.md)
    * [Displaying data](deep-dives/nodejs/express/displaying-data.md)
    * [Forms and deployment](deep-dives/nodejs/express/forms-and-deployment.md)
    * [Project: Inventory](deep-dives/nodejs/express/project-inventory.md)
  * [Authentication](deep-dives/nodejs/authentication.md)
  * [Security](deep-dives/nodejs/security.md)
  * [Project: Clubhouse](deep-dives/nodejs/project-clubhouse.md)
  * [APIs](deep-dives/nodejs/apis.md)
  * [Securing an API](deep-dives/nodejs/securing-an-api.md)
  * [Project: Blog](deep-dives/nodejs/project-blog.md)
  * [Testing](deep-dives/nodejs/testing.md)
  * [Testing with a database](deep-dives/nodejs/testing-with-a-database.md)
  * [Project: Social network](deep-dives/nodejs/project-social-network.md)
* [React](deep-dives/react/README.md)
  * [Props and State](deep-dives/react/props-and-state.md)
  * [Render lists and handle inputs](deep-dives/react/render-lists-and-handle-inputs.md)
  * [Project: CV](deep-dives/react/project-cv.md)
  * [Lifecycle methods](deep-dives/react/lifecycle-methods.md)
  * [Hooks](deep-dives/react/hooks.md)
  * [Project: Memory card](deep-dives/react/project-memory-card.md)
  * [Router](deep-dives/react/router.md)
  * [Project: Shopping cart](deep-dives/react/project-shopping-cart.md)
  * [Advanced concepts](deep-dives/react/advanced-concepts.md)
* [Ruby](deep-dives/ruby/README.md)
  * [Installation](deep-dives/ruby/installation.md)
  * [Data types](deep-dives/ruby/data-types.md)
  * [Variables](deep-dives/ruby/variables.md)
  * [Input and Output](deep-dives/ruby/input-and-output.md)
  * [Conditionals](deep-dives/ruby/conditionals.md)
  * [Loops](deep-dives/ruby/loops.md)
  * [Arrays](deep-dives/ruby/arrays.md)
  * [Hashes](deep-dives/ruby/hashes.md)
  * [Methods](deep-dives/ruby/methods.md)
  * [Enumerables](deep-dives/ruby/enumerables.md)
  * [More enumerables](deep-dives/ruby/more-enumerables.md)
  * [Nested collections](deep-dives/ruby/nested-collections.md)
  * [Blocks](deep-dives/ruby/blocks.md)
  * [Pattern matching](deep-dives/ruby/pattern-matching.md)
  * [Debugging](deep-dives/ruby/debugging.md)
  * [Project: Caesar cipher](deep-dives/ruby/project-caesar-cipher.md)
  * [Project: Substrings](deep-dives/ruby/project-substrings.md)
  * [Project: Stock picker](deep-dives/ruby/project-stock-picker.md)
  * [Project: Bubble sort](deep-dives/ruby/project-bubble-sort.md)
  * [Object oriented programming](deep-dives/ruby/object-oriented-programming.md)
  * [Project: Tic Tac Toe](deep-dives/ruby/project-tic-tac-toe.md)
  * [Project: Mastermind](deep-dives/ruby/project-mastermind.md)
  * [Serialization](deep-dives/ruby/serialization.md)
  * [Project: Event manager](deep-dives/ruby/project-event-manager.md)
  * [Project: Hangman](deep-dives/ruby/project-hangman.md)
  * [Computer Science](deep-dives/ruby/computer-science/README.md)
    * [Recursion](deep-dives/ruby/computer-science/recursion.md)
    * [Project: Merge Sort](deep-dives/ruby/computer-science/project-merge-sort.md)
    * [Data structures and algorithms](deep-dives/ruby/computer-science/data-structures-and-algorithms.md)
    * [Project: Linked Lists](deep-dives/ruby/computer-science/project-linked-lists.md)
    * [Project: Binary Search Trees](deep-dives/ruby/computer-science/project-binary-search-trees.md)
    * [Project: Knight Travails](deep-dives/ruby/computer-science/project-knight-travails.md)
  * [Testing](deep-dives/ruby/testing.md)
  * [RSpec](deep-dives/ruby/rspec.md)
  * [Project: Four in a row](deep-dives/ruby/project-four-in-a-row.md)
  * [Git](deep-dives/ruby/git.md)
  * [Project: Open Source](deep-dives/ruby/project-open-source.md)
  * [Project: Chess](deep-dives/ruby/project-chess.md)
  * [Next steps](deep-dives/ruby/next-steps.md)
* [Ruby on Rails](deep-dives/ruby-on-rails/README.md)
  * [Using Heroku](deep-dives/ruby-on-rails/heroku.md)
  * [Installing Rails](deep-dives/ruby-on-rails/installing-rails.md)
  * [Basics](deep-dives/ruby-on-rails/basics/README.md)
    * [Routing](deep-dives/ruby-on-rails/basics/routing.md)
    * [Controllers](deep-dives/ruby-on-rails/basics/controllers.md)
    * [Views](deep-dives/ruby-on-rails/basics/views.md)
    * [Asset pipeline](deep-dives/ruby-on-rails/basics/asset-pipeline.md)
    * [Deployment](deep-dives/ruby-on-rails/basics/deployment.md)
    * [Project: Blog](deep-dives/ruby-on-rails/basics/project-blog.md)
  * [Active Record](deep-dives/ruby-on-rails/active-record/README.md)
    * [Project: Upvote](deep-dives/ruby-on-rails/active-record/project-upvote.md)
  * [Forms](deep-dives/ruby-on-rails/forms/README.md)
    * [Cookies, sessions, and authentication](deep-dives/ruby-on-rails/forms/cookies-sessions-and-authentication.md)
    * [Project: Password](deep-dives/ruby-on-rails/forms/project-password.md)
  * [Advanced forms and Active Record](deep-dives/ruby-on-rails/advanced-forms-and-active-record/README.md)
    * [Associations](deep-dives/ruby-on-rails/advanced-forms-and-active-record/associations.md)
    * [Project: Private Events](deep-dives/ruby-on-rails/advanced-forms-and-active-record/project-private-events.md)
    * [Callbacks](deep-dives/ruby-on-rails/advanced-forms-and-active-record/callbacks.md)
    * [Menus, helpers and nested forms](deep-dives/ruby-on-rails/advanced-forms-and-active-record/menus-helpers-and-nested-forms.md)
    * [Project: Ticket agent](deep-dives/ruby-on-rails/advanced-forms-and-active-record/project-ticket-agent.md)
  * [APIs](deep-dives/ruby-on-rails/apis/README.md)
    * [External APIs](deep-dives/ruby-on-rails/apis/external-apis.md)
    * [Project: Animals](deep-dives/ruby-on-rails/apis/project-animals.md)
    * [Project: Photo widget](deep-dives/ruby-on-rails/apis/project-photo-widget.md)
  * [Mailers](deep-dives/ruby-on-rails/mailers/README.md)
    * [Project: Confirmation](deep-dives/ruby-on-rails/mailers/project-confirmation.md)
  * [Advanced topics](deep-dives/ruby-on-rails/advanced-topics/README.md)
    * [Action Cable](deep-dives/ruby-on-rails/advanced-topics/action-cable.md)
  * [Project: Social network](deep-dives/ruby-on-rails/project-social-network.md)
  * [Next steps](deep-dives/ruby-on-rails/next-steps.md)

## Getting hired

* [Preparing to find a job](getting-hired/preparing-to-find-a-job/README.md)
  * [Plan a strategy](getting-hired/preparing-to-find-a-job/plan-a-strategy.md)
  * [What companies want](getting-hired/preparing-to-find-a-job/what-companies-want.md)
  * [Get yourself together](getting-hired/preparing-to-find-a-job/get-yourself-together.md)
  * [How to prepare](getting-hired/preparing-to-find-a-job/how-to-prepare.md)
  * [Project: Make your website](getting-hired/preparing-to-find-a-job/project-build-a-personal-website.md)
* [Applying and interviewing](getting-hired/applying-and-interviewing-for-a-job/README.md)
  * [Qualifying leads](getting-hired/applying-and-interviewing-for-a-job/qualifying-leads.md)
  * [Project: Make your resume](getting-hired/applying-and-interviewing-for-a-job/project-make-a-developer-resume.md)
  * [Applying for jobs](getting-hired/applying-and-interviewing-for-a-job/applying-for-jobs.md)
  * [Preparing for an interview](getting-hired/applying-and-interviewing-for-a-job/preparing-for-an-interview.md)
  * [Handling an offer](getting-hired/applying-and-interviewing-for-a-job/handling-an-offer.md)
  * [Final words](getting-hired/applying-and-interviewing-for-a-job/final-words.md)

## Maintained by <a href="#maintainer" id="maintainer"></a>

* [wbnns](https://trek.io/)

## License

* [CC BY-NC-SA 4.0 © 2022](https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode)
