/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.lightbulb;

import eu.hansolo.lightbulb.JavaShadow;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;

public class LightBulb
extends JComponent {
    public static final String STATE_PROPERTY = "state";
    private boolean on;
    private float alpha;
    private int direction;
    private PropertyChangeSupport propertySupport;
    private final Rectangle INNER_BOUNDS = new Rectangle(0, 0, 114, 114);
    private final Point2D CENTER;
    private Color glowColor;
    private BufferedImage offImage;
    private BufferedImage onImage;
    private BufferedImage bulbImage;
    private boolean square;
    private final transient ComponentListener COMPONENT_LISTENER = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent event) {
            int SIZE = LightBulb.this.getWidth() <= LightBulb.this.getHeight() ? LightBulb.this.getWidth() : LightBulb.this.getHeight();
            Container parent = LightBulb.this.getParent();
            if (parent != null && parent.getLayout() == null) {
                if (SIZE < LightBulb.this.getMinimumSize().width || SIZE < LightBulb.this.getMinimumSize().height) {
                    LightBulb.this.setSize(LightBulb.this.getMinimumSize());
                } else if (LightBulb.this.square) {
                    LightBulb.this.setSize(SIZE, SIZE);
                } else {
                    LightBulb.this.setSize(LightBulb.this.getWidth(), LightBulb.this.getHeight());
                }
            } else if (SIZE < LightBulb.this.getMinimumSize().width || SIZE < LightBulb.this.getMinimumSize().height) {
                LightBulb.this.setPreferredSize(LightBulb.this.getMinimumSize());
            } else if (LightBulb.this.square) {
                LightBulb.this.setPreferredSize(new Dimension(SIZE, SIZE));
            } else {
                LightBulb.this.setPreferredSize(new Dimension(LightBulb.this.getWidth(), LightBulb.this.getHeight()));
            }
            LightBulb.this.calcInnerBounds();
            LightBulb.this.init(((LightBulb)LightBulb.this).getInnerBounds().width, ((LightBulb)LightBulb.this).getInnerBounds().height);
        }
    };

    public LightBulb() {
        this.propertySupport = new PropertyChangeSupport(this);
        this.CENTER = new Point2D.Double();
        this.offImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.onImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.bulbImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.alpha = 1.0f;
        this.direction = 1;
        this.glowColor = new Color(1.0f, 1.0f, 0.0f);
        this.square = true;
        this.addComponentListener(this.COMPONENT_LISTENER);
    }

    public final void init(int WIDTH, int HEIGHT) {
        if (WIDTH <= 1 || HEIGHT <= 1) {
            return;
        }
        if (this.offImage != null) {
            this.offImage.flush();
        }
        this.offImage = this.createOffImage(WIDTH, HEIGHT);
        if (this.onImage != null) {
            this.onImage.flush();
        }
        this.onImage = this.createOnImage(WIDTH, HEIGHT, this.glowColor);
        if (this.bulbImage != null) {
            this.bulbImage.flush();
        }
        this.bulbImage = this.createBulbImage(WIDTH, HEIGHT);
        this.CENTER.setLocation((double)WIDTH / 2.0, (double)HEIGHT / 2.0);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        switch (this.direction) {
            case 5: {
                G2.rotate(Math.PI, this.CENTER.getX(), this.CENTER.getY());
                break;
            }
            case 3: {
                G2.rotate(-1.5707963267948966, this.CENTER.getX(), this.CENTER.getY());
                break;
            }
            case 7: {
                G2.rotate(1.5707963267948966, this.CENTER.getX(), this.CENTER.getY());
            }
        }
        G2.translate(this.getInnerBounds().x, this.getInnerBounds().y);
        if (this.on) {
            G2.setComposite(AlphaComposite.getInstance(3, 1.0f - this.alpha));
            G2.drawImage((Image)this.offImage, 0, 0, null);
            G2.setComposite(AlphaComposite.getInstance(3, this.alpha));
            G2.drawImage((Image)this.onImage, 0, 0, null);
            G2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        } else {
            G2.drawImage((Image)this.offImage, 0, 0, null);
        }
        G2.drawImage((Image)this.bulbImage, 0, 0, null);
        G2.dispose();
    }

    public boolean isOn() {
        return this.on;
    }

    public void setOn(boolean ON) {
        boolean oldState = this.on;
        this.on = ON;
        this.propertySupport.firePropertyChange(STATE_PROPERTY, oldState, this.on);
        this.repaint(this.getInnerBounds());
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float ALPHA) {
        this.alpha = ALPHA < 0.0f ? 0.0f : (ALPHA > 1.0f ? 1.0f : ALPHA);
        this.repaint(this.getInnerBounds());
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int DIRECTION) {
        switch (DIRECTION) {
            case 5: {
                this.direction = 5;
                break;
            }
            case 3: {
                this.direction = 3;
                break;
            }
            case 7: {
                this.direction = 7;
                break;
            }
            default: {
                this.direction = 1;
            }
        }
        this.repaint(this.getInnerBounds());
    }

    public Color getGlowColor() {
        return this.glowColor;
    }

    public void setGlowColor(Color GLOW_COLOR) {
        this.glowColor = GLOW_COLOR;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener LISTENER) {
        if (this.isShowing()) {
            this.propertySupport.addPropertyChangeListener(LISTENER);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener LISTENER) {
        this.propertySupport.removePropertyChangeListener(LISTENER);
    }

    private void calcInnerBounds() {
        Insets INSETS = this.getInsets();
        this.INNER_BOUNDS.setBounds(INSETS.left, INSETS.top, this.getWidth() - INSETS.left - INSETS.right, this.getHeight() - INSETS.top - INSETS.bottom);
    }

    private Rectangle getInnerBounds() {
        return this.INNER_BOUNDS;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(99, 113);
    }

    @Override
    public void setPreferredSize(Dimension DIM) {
        int SIZE;
        int n = SIZE = DIM.width <= DIM.height ? DIM.width : DIM.height;
        if (this.square) {
            super.setPreferredSize(new Dimension(SIZE, SIZE));
        } else {
            super.setPreferredSize(DIM);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setSize(int WIDTH, int HEIGHT) {
        int SIZE;
        int n = SIZE = WIDTH <= HEIGHT ? WIDTH : HEIGHT;
        if (this.square) {
            super.setSize(SIZE, SIZE);
        } else {
            super.setSize(WIDTH, HEIGHT);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setSize(Dimension DIM) {
        int SIZE;
        int n = SIZE = DIM.width <= DIM.height ? DIM.width : DIM.height;
        if (this.square) {
            super.setSize(new Dimension(SIZE, SIZE));
        } else {
            super.setSize(DIM);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setBounds(Rectangle BOUNDS) {
        int SIZE;
        int n = SIZE = BOUNDS.width <= BOUNDS.height ? BOUNDS.width : BOUNDS.height;
        if (this.square) {
            super.setBounds(BOUNDS.x, BOUNDS.y, SIZE, SIZE);
        } else {
            super.setBounds(BOUNDS);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setBounds(int X, int Y, int WIDTH, int HEIGHT) {
        int SIZE;
        int n = SIZE = WIDTH <= HEIGHT ? WIDTH : HEIGHT;
        if (this.square) {
            super.setBounds(X, Y, SIZE, SIZE);
        } else {
            super.setBounds(X, Y, WIDTH, HEIGHT);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    private BufferedImage createImage(int WIDTH, int HEIGHT, int TRANSPARENCY) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, TRANSPARENCY);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, TRANSPARENCY);
        return IMAGE;
    }

    public BufferedImage createOffImage(int WIDTH, int HEIGHT) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, 3);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath GLAS = new GeneralPath();
        GLAS.setWindingRule(0);
        GLAS.moveTo(0.2894736842105263 * (double)IMAGE_WIDTH, 0.43859649122807015 * (double)IMAGE_HEIGHT);
        GLAS.curveTo(0.2894736842105263 * (double)IMAGE_WIDTH, 0.5614035087719298 * (double)IMAGE_HEIGHT, 0.38596491228070173 * (double)IMAGE_WIDTH, 0.6052631578947368 * (double)IMAGE_HEIGHT, 0.38596491228070173 * (double)IMAGE_WIDTH, 0.7456140350877193 * (double)IMAGE_HEIGHT);
        GLAS.curveTo(0.38596491228070173 * (double)IMAGE_WIDTH, 0.7456140350877193 * (double)IMAGE_HEIGHT, 0.5877192982456141 * (double)IMAGE_WIDTH, 0.7456140350877193 * (double)IMAGE_HEIGHT, 0.5877192982456141 * (double)IMAGE_WIDTH, 0.7456140350877193 * (double)IMAGE_HEIGHT);
        GLAS.curveTo(0.5877192982456141 * (double)IMAGE_WIDTH, 0.6052631578947368 * (double)IMAGE_HEIGHT, 0.6929824561403509 * (double)IMAGE_WIDTH, 0.5614035087719298 * (double)IMAGE_HEIGHT, 0.6929824561403509 * (double)IMAGE_WIDTH, 0.43859649122807015 * (double)IMAGE_HEIGHT);
        GLAS.curveTo(0.6929824561403509 * (double)IMAGE_WIDTH, 0.32456140350877194 * (double)IMAGE_HEIGHT, 0.6052631578947368 * (double)IMAGE_WIDTH, 0.22807017543859648 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.22807017543859648 * (double)IMAGE_HEIGHT);
        GLAS.curveTo(0.38596491228070173 * (double)IMAGE_WIDTH, 0.22807017543859648 * (double)IMAGE_HEIGHT, 0.2894736842105263 * (double)IMAGE_WIDTH, 0.32456140350877194 * (double)IMAGE_HEIGHT, 0.2894736842105263 * (double)IMAGE_WIDTH, 0.43859649122807015 * (double)IMAGE_HEIGHT);
        GLAS.closePath();
        LinearGradientPaint GLAS_PAINT = new LinearGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.2894736842105263 * (double)IMAGE_HEIGHT), new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.7017543859649122 * (double)IMAGE_HEIGHT), new float[]{0.0f, 0.99f, 1.0f}, new Color[]{new Color(0.93333334f, 0.93333334f, 0.93333334f, 1.0f), new Color(0.6f, 0.6f, 0.6f, 1.0f), new Color(0.6f, 0.6f, 0.6f, 1.0f)});
        G2.setPaint(GLAS_PAINT);
        G2.fill(GLAS);
        G2.setPaint(new Color(0.8f, 0.8f, 0.8f, 1.0f));
        G2.setStroke(new BasicStroke(0.01010101f * (float)IMAGE_WIDTH, 0, 1));
        G2.draw(GLAS);
        G2.drawImage((Image)JavaShadow.INSTANCE.createInnerShadow(GLAS, GLAS_PAINT, 0, 0.35f, new Color(0, 0, 0, 50), 10, 45), GLAS.getBounds().x, GLAS.getBounds().y, null);
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage createOnImage(int WIDTH, int HEIGHT, Color GLOW_COLOR) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, 3);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath GLOW = new GeneralPath();
        GLOW.setWindingRule(0);
        GLOW.moveTo(0.05263157894736842 * (double)IMAGE_WIDTH, 0.43859649122807015 * (double)IMAGE_HEIGHT);
        GLOW.curveTo(0.05263157894736842 * (double)IMAGE_WIDTH, 0.19298245614035087 * (double)IMAGE_HEIGHT, 0.24561403508771928 * (double)IMAGE_WIDTH, 0.0 * (double)IMAGE_HEIGHT, 0.49122807017543857 * (double)IMAGE_WIDTH, 0.0 * (double)IMAGE_HEIGHT);
        GLOW.curveTo(0.7368421052631579 * (double)IMAGE_WIDTH, 0.0 * (double)IMAGE_HEIGHT, 0.9298245614035088 * (double)IMAGE_WIDTH, 0.19298245614035087 * (double)IMAGE_HEIGHT, 0.9298245614035088 * (double)IMAGE_WIDTH, 0.43859649122807015 * (double)IMAGE_HEIGHT);
        GLOW.curveTo(0.9298245614035088 * (double)IMAGE_WIDTH, 0.6842105263157895 * (double)IMAGE_HEIGHT, 0.7368421052631579 * (double)IMAGE_WIDTH, 0.8771929824561403 * (double)IMAGE_HEIGHT, 0.49122807017543857 * (double)IMAGE_WIDTH, 0.8771929824561403 * (double)IMAGE_HEIGHT);
        GLOW.curveTo(0.24561403508771928 * (double)IMAGE_WIDTH, 0.8771929824561403 * (double)IMAGE_HEIGHT, 0.05263157894736842 * (double)IMAGE_WIDTH, 0.6842105263157895 * (double)IMAGE_HEIGHT, 0.05263157894736842 * (double)IMAGE_WIDTH, 0.43859649122807015 * (double)IMAGE_HEIGHT);
        GLOW.closePath();
        G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.4824561403508772 * (double)IMAGE_WIDTH, 0.43859649122807015 * (double)IMAGE_HEIGHT), 0.44298247f * (float)IMAGE_WIDTH, new float[]{0.0f, 1.0f}, new Color[]{new Color(this.glowColor.getRed(), this.glowColor.getGreen(), this.glowColor.getBlue(), 255), new Color(this.glowColor.getRed(), this.glowColor.getGreen(), this.glowColor.getBlue(), 0)}));
        G2.fill(GLOW);
        GeneralPath GLAS = new GeneralPath();
        GLAS.setWindingRule(0);
        GLAS.moveTo(0.2894736842105263 * (double)IMAGE_WIDTH, 0.43859649122807015 * (double)IMAGE_HEIGHT);
        GLAS.curveTo(0.2894736842105263 * (double)IMAGE_WIDTH, 0.5614035087719298 * (double)IMAGE_HEIGHT, 0.38596491228070173 * (double)IMAGE_WIDTH, 0.6052631578947368 * (double)IMAGE_HEIGHT, 0.38596491228070173 * (double)IMAGE_WIDTH, 0.7456140350877193 * (double)IMAGE_HEIGHT);
        GLAS.curveTo(0.38596491228070173 * (double)IMAGE_WIDTH, 0.7456140350877193 * (double)IMAGE_HEIGHT, 0.5877192982456141 * (double)IMAGE_WIDTH, 0.7456140350877193 * (double)IMAGE_HEIGHT, 0.5877192982456141 * (double)IMAGE_WIDTH, 0.7456140350877193 * (double)IMAGE_HEIGHT);
        GLAS.curveTo(0.5877192982456141 * (double)IMAGE_WIDTH, 0.6052631578947368 * (double)IMAGE_HEIGHT, 0.6929824561403509 * (double)IMAGE_WIDTH, 0.5614035087719298 * (double)IMAGE_HEIGHT, 0.6929824561403509 * (double)IMAGE_WIDTH, 0.43859649122807015 * (double)IMAGE_HEIGHT);
        GLAS.curveTo(0.6929824561403509 * (double)IMAGE_WIDTH, 0.32456140350877194 * (double)IMAGE_HEIGHT, 0.6052631578947368 * (double)IMAGE_WIDTH, 0.22807017543859648 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.22807017543859648 * (double)IMAGE_HEIGHT);
        GLAS.curveTo(0.38596491228070173 * (double)IMAGE_WIDTH, 0.22807017543859648 * (double)IMAGE_HEIGHT, 0.2894736842105263 * (double)IMAGE_WIDTH, 0.32456140350877194 * (double)IMAGE_HEIGHT, 0.2894736842105263 * (double)IMAGE_WIDTH, 0.43859649122807015 * (double)IMAGE_HEIGHT);
        GLAS.closePath();
        float[] HSB = Color.RGBtoHSB(GLOW_COLOR.getRed(), GLOW_COLOR.getGreen(), GLOW_COLOR.getBlue(), null);
        Color[] GLOW_COLORS = this.glowColor.getRed() == this.glowColor.getGreen() && this.glowColor.getGreen() == this.glowColor.getBlue() ? new Color[]{new Color(Color.HSBtoRGB(0.0f, 0.0f, 0.6f)), new Color(Color.HSBtoRGB(0.0f, 0.0f, 0.4f))} : new Color[]{new Color(Color.HSBtoRGB(HSB[0], 0.6f, HSB[2])), new Color(Color.HSBtoRGB(HSB[0], 0.4f, HSB[2]))};
        LinearGradientPaint GLAS_PAINT = new LinearGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.2894736842105263 * (double)IMAGE_HEIGHT), new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.7017543859649122 * (double)IMAGE_HEIGHT), new float[]{0.0f, 1.0f}, GLOW_COLORS);
        G2.setPaint(GLAS_PAINT);
        G2.fill(GLAS);
        G2.setPaint(GLOW_COLOR);
        G2.setStroke(new BasicStroke(0.01010101f * (float)IMAGE_WIDTH, 0, 1));
        G2.draw(GLAS);
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage createBulbImage(int WIDTH, int HEIGHT) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, 3);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath HIGHLIGHT = new GeneralPath();
        HIGHLIGHT.setWindingRule(0);
        HIGHLIGHT.moveTo(0.3508771929824561 * (double)IMAGE_WIDTH, 0.3333333333333333 * (double)IMAGE_HEIGHT);
        HIGHLIGHT.curveTo(0.3508771929824561 * (double)IMAGE_WIDTH, 0.2807017543859649 * (double)IMAGE_HEIGHT, 0.41228070175438597 * (double)IMAGE_WIDTH, 0.23684210526315788 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.23684210526315788 * (double)IMAGE_HEIGHT);
        HIGHLIGHT.curveTo(0.5789473684210527 * (double)IMAGE_WIDTH, 0.23684210526315788 * (double)IMAGE_HEIGHT, 0.6403508771929824 * (double)IMAGE_WIDTH, 0.2807017543859649 * (double)IMAGE_HEIGHT, 0.6403508771929824 * (double)IMAGE_WIDTH, 0.3333333333333333 * (double)IMAGE_HEIGHT);
        HIGHLIGHT.curveTo(0.6403508771929824 * (double)IMAGE_WIDTH, 0.38596491228070173 * (double)IMAGE_HEIGHT, 0.5789473684210527 * (double)IMAGE_WIDTH, 0.4298245614035088 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.4298245614035088 * (double)IMAGE_HEIGHT);
        HIGHLIGHT.curveTo(0.41228070175438597 * (double)IMAGE_WIDTH, 0.4298245614035088 * (double)IMAGE_HEIGHT, 0.3508771929824561 * (double)IMAGE_WIDTH, 0.38596491228070173 * (double)IMAGE_HEIGHT, 0.3508771929824561 * (double)IMAGE_WIDTH, 0.3333333333333333 * (double)IMAGE_HEIGHT);
        HIGHLIGHT.closePath();
        G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.24561403508771928 * (double)IMAGE_HEIGHT), new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.4298245614035088 * (double)IMAGE_HEIGHT), new float[]{0.0f, 0.99f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 1.0f), new Color(1.0f, 1.0f, 1.0f, 0.0f), new Color(1.0f, 1.0f, 1.0f, 0.0f)}));
        G2.fill(HIGHLIGHT);
        GeneralPath WINDING = new GeneralPath();
        WINDING.setWindingRule(0);
        WINDING.moveTo(0.37719298245614036 * (double)IMAGE_WIDTH, 0.7456140350877193 * (double)IMAGE_HEIGHT);
        WINDING.curveTo(0.37719298245614036 * (double)IMAGE_WIDTH, 0.7456140350877193 * (double)IMAGE_HEIGHT, 0.4298245614035088 * (double)IMAGE_WIDTH, 0.7280701754385965 * (double)IMAGE_HEIGHT, 0.49122807017543857 * (double)IMAGE_WIDTH, 0.7280701754385965 * (double)IMAGE_HEIGHT);
        WINDING.curveTo(0.5614035087719298 * (double)IMAGE_WIDTH, 0.7280701754385965 * (double)IMAGE_HEIGHT, 0.6052631578947368 * (double)IMAGE_WIDTH, 0.7368421052631579 * (double)IMAGE_HEIGHT, 0.6052631578947368 * (double)IMAGE_WIDTH, 0.7368421052631579 * (double)IMAGE_HEIGHT);
        WINDING.lineTo(0.6052631578947368 * (double)IMAGE_WIDTH, 0.7631578947368421 * (double)IMAGE_HEIGHT);
        WINDING.lineTo(0.5964912280701754 * (double)IMAGE_WIDTH, 0.7807017543859649 * (double)IMAGE_HEIGHT);
        WINDING.lineTo(0.6052631578947368 * (double)IMAGE_WIDTH, 0.7982456140350878 * (double)IMAGE_HEIGHT);
        WINDING.lineTo(0.5964912280701754 * (double)IMAGE_WIDTH, 0.8157894736842105 * (double)IMAGE_HEIGHT);
        WINDING.lineTo(0.6052631578947368 * (double)IMAGE_WIDTH, 0.8333333333333334 * (double)IMAGE_HEIGHT);
        WINDING.lineTo(0.5964912280701754 * (double)IMAGE_WIDTH, 0.8508771929824561 * (double)IMAGE_HEIGHT);
        WINDING.lineTo(0.6052631578947368 * (double)IMAGE_WIDTH, 0.868421052631579 * (double)IMAGE_HEIGHT);
        WINDING.lineTo(0.5964912280701754 * (double)IMAGE_WIDTH, 0.8859649122807017 * (double)IMAGE_HEIGHT);
        WINDING.lineTo(0.6052631578947368 * (double)IMAGE_WIDTH, 0.8947368421052632 * (double)IMAGE_HEIGHT);
        WINDING.curveTo(0.6052631578947368 * (double)IMAGE_WIDTH, 0.8947368421052632 * (double)IMAGE_HEIGHT, 0.5701754385964912 * (double)IMAGE_WIDTH, 0.956140350877193 * (double)IMAGE_HEIGHT, 0.5350877192982456 * (double)IMAGE_WIDTH, 0.9912280701754386 * (double)IMAGE_HEIGHT);
        WINDING.curveTo(0.5263157894736842 * (double)IMAGE_WIDTH, 0.9912280701754386 * (double)IMAGE_HEIGHT, 0.5175438596491229 * (double)IMAGE_WIDTH, 1.0 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 1.0 * (double)IMAGE_HEIGHT);
        WINDING.curveTo(0.4824561403508772 * (double)IMAGE_WIDTH, 1.0 * (double)IMAGE_HEIGHT, 0.47368421052631576 * (double)IMAGE_WIDTH, 1.0 * (double)IMAGE_HEIGHT, 0.4649122807017544 * (double)IMAGE_WIDTH, 0.9912280701754386 * (double)IMAGE_HEIGHT);
        WINDING.curveTo(0.42105263157894735 * (double)IMAGE_WIDTH, 0.9473684210526315 * (double)IMAGE_HEIGHT, 0.39473684210526316 * (double)IMAGE_WIDTH, 0.9035087719298246 * (double)IMAGE_HEIGHT, 0.39473684210526316 * (double)IMAGE_WIDTH, 0.9035087719298246 * (double)IMAGE_HEIGHT);
        WINDING.lineTo(0.39473684210526316 * (double)IMAGE_WIDTH, 0.8947368421052632 * (double)IMAGE_HEIGHT);
        WINDING.lineTo(0.38596491228070173 * (double)IMAGE_WIDTH, 0.8859649122807017 * (double)IMAGE_HEIGHT);
        WINDING.lineTo(0.39473684210526316 * (double)IMAGE_WIDTH, 0.868421052631579 * (double)IMAGE_HEIGHT);
        WINDING.lineTo(0.38596491228070173 * (double)IMAGE_WIDTH, 0.8508771929824561 * (double)IMAGE_HEIGHT);
        WINDING.lineTo(0.39473684210526316 * (double)IMAGE_WIDTH, 0.8333333333333334 * (double)IMAGE_HEIGHT);
        WINDING.lineTo(0.38596491228070173 * (double)IMAGE_WIDTH, 0.8157894736842105 * (double)IMAGE_HEIGHT);
        WINDING.lineTo(0.39473684210526316 * (double)IMAGE_WIDTH, 0.7982456140350878 * (double)IMAGE_HEIGHT);
        WINDING.lineTo(0.37719298245614036 * (double)IMAGE_WIDTH, 0.7894736842105263 * (double)IMAGE_HEIGHT);
        WINDING.lineTo(0.39473684210526316 * (double)IMAGE_WIDTH, 0.7719298245614035 * (double)IMAGE_HEIGHT);
        WINDING.lineTo(0.37719298245614036 * (double)IMAGE_WIDTH, 0.7631578947368421 * (double)IMAGE_HEIGHT);
        WINDING.lineTo(0.37719298245614036 * (double)IMAGE_WIDTH, 0.7456140350877193 * (double)IMAGE_HEIGHT);
        WINDING.closePath();
        G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.47368421052631576 * (double)IMAGE_WIDTH, 0.7280701754385965 * (double)IMAGE_HEIGHT), new Point2D.Double(0.4847023065774619 * (double)IMAGE_WIDTH, 0.9383079722290332 * (double)IMAGE_HEIGHT), new float[]{0.0f, 0.04f, 0.19f, 0.24f, 0.31f, 0.4f, 0.48f, 0.56f, 0.64f, 0.7f, 0.78f, 1.0f}, new Color[]{new Color(0.2f, 0.2f, 0.2f, 1.0f), new Color(0.8509804f, 0.84705883f, 0.8392157f, 1.0f), new Color(0.89411765f, 0.8980392f, 0.8784314f, 1.0f), new Color(0.5921569f, 0.6f, 0.5882353f, 1.0f), new Color(0.9843137f, 1.0f, 1.0f, 1.0f), new Color(0.5058824f, 0.52156866f, 0.5176471f, 1.0f), new Color(0.9607843f, 0.96862745f, 0.95686275f, 1.0f), new Color(0.58431375f, 0.5921569f, 0.5803922f, 1.0f), new Color(0.9490196f, 0.9490196f, 0.9411765f, 1.0f), new Color(0.50980395f, 0.5294118f, 0.5137255f, 1.0f), new Color(0.9882353f, 0.9882353f, 0.9882353f, 1.0f), new Color(0.4f, 0.4f, 0.4f, 1.0f)}));
        G2.fill(WINDING);
        GeneralPath WINDING_SHADOW = new GeneralPath();
        WINDING_SHADOW.setWindingRule(0);
        WINDING_SHADOW.moveTo(0.37719298245614036 * (double)IMAGE_WIDTH, 0.7456140350877193 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.curveTo(0.37719298245614036 * (double)IMAGE_WIDTH, 0.7456140350877193 * (double)IMAGE_HEIGHT, 0.4298245614035088 * (double)IMAGE_WIDTH, 0.7280701754385965 * (double)IMAGE_HEIGHT, 0.49122807017543857 * (double)IMAGE_WIDTH, 0.7280701754385965 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.curveTo(0.5614035087719298 * (double)IMAGE_WIDTH, 0.7280701754385965 * (double)IMAGE_HEIGHT, 0.6052631578947368 * (double)IMAGE_WIDTH, 0.7368421052631579 * (double)IMAGE_HEIGHT, 0.6052631578947368 * (double)IMAGE_WIDTH, 0.7368421052631579 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.lineTo(0.6052631578947368 * (double)IMAGE_WIDTH, 0.7631578947368421 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.lineTo(0.5964912280701754 * (double)IMAGE_WIDTH, 0.7807017543859649 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.lineTo(0.6052631578947368 * (double)IMAGE_WIDTH, 0.7982456140350878 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.lineTo(0.5964912280701754 * (double)IMAGE_WIDTH, 0.8157894736842105 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.lineTo(0.6052631578947368 * (double)IMAGE_WIDTH, 0.8333333333333334 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.lineTo(0.5964912280701754 * (double)IMAGE_WIDTH, 0.8508771929824561 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.lineTo(0.6052631578947368 * (double)IMAGE_WIDTH, 0.868421052631579 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.lineTo(0.5964912280701754 * (double)IMAGE_WIDTH, 0.8859649122807017 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.lineTo(0.6052631578947368 * (double)IMAGE_WIDTH, 0.8947368421052632 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.curveTo(0.6052631578947368 * (double)IMAGE_WIDTH, 0.8947368421052632 * (double)IMAGE_HEIGHT, 0.5701754385964912 * (double)IMAGE_WIDTH, 0.956140350877193 * (double)IMAGE_HEIGHT, 0.5350877192982456 * (double)IMAGE_WIDTH, 0.9912280701754386 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.curveTo(0.5263157894736842 * (double)IMAGE_WIDTH, 0.9912280701754386 * (double)IMAGE_HEIGHT, 0.5175438596491229 * (double)IMAGE_WIDTH, 1.0 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 1.0 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.curveTo(0.4824561403508772 * (double)IMAGE_WIDTH, 1.0 * (double)IMAGE_HEIGHT, 0.47368421052631576 * (double)IMAGE_WIDTH, 1.0 * (double)IMAGE_HEIGHT, 0.4649122807017544 * (double)IMAGE_WIDTH, 0.9912280701754386 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.curveTo(0.42105263157894735 * (double)IMAGE_WIDTH, 0.9473684210526315 * (double)IMAGE_HEIGHT, 0.39473684210526316 * (double)IMAGE_WIDTH, 0.9035087719298246 * (double)IMAGE_HEIGHT, 0.39473684210526316 * (double)IMAGE_WIDTH, 0.9035087719298246 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.lineTo(0.39473684210526316 * (double)IMAGE_WIDTH, 0.8947368421052632 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.lineTo(0.38596491228070173 * (double)IMAGE_WIDTH, 0.8859649122807017 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.lineTo(0.39473684210526316 * (double)IMAGE_WIDTH, 0.868421052631579 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.lineTo(0.38596491228070173 * (double)IMAGE_WIDTH, 0.8508771929824561 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.lineTo(0.39473684210526316 * (double)IMAGE_WIDTH, 0.8333333333333334 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.lineTo(0.38596491228070173 * (double)IMAGE_WIDTH, 0.8157894736842105 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.lineTo(0.39473684210526316 * (double)IMAGE_WIDTH, 0.7982456140350878 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.lineTo(0.37719298245614036 * (double)IMAGE_WIDTH, 0.7894736842105263 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.lineTo(0.39473684210526316 * (double)IMAGE_WIDTH, 0.7719298245614035 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.lineTo(0.37719298245614036 * (double)IMAGE_WIDTH, 0.7631578947368421 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.lineTo(0.37719298245614036 * (double)IMAGE_WIDTH, 0.7456140350877193 * (double)IMAGE_HEIGHT);
        WINDING_SHADOW.closePath();
        G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.37719298245614036 * (double)IMAGE_WIDTH, 0.7894736842105263 * (double)IMAGE_HEIGHT), new Point2D.Double(0.6052631578947368 * (double)IMAGE_WIDTH, 0.7894736842105263 * (double)IMAGE_HEIGHT), new float[]{0.0f, 0.15f, 0.85f, 1.0f}, new Color[]{new Color(0.0f, 0.0f, 0.0f, 0.4f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.4f)}));
        G2.fill(WINDING_SHADOW);
        GeneralPath CONTACT_PLATE = new GeneralPath();
        CONTACT_PLATE.setWindingRule(0);
        CONTACT_PLATE.moveTo(0.42105263157894735 * (double)IMAGE_WIDTH, 0.9473684210526315 * (double)IMAGE_HEIGHT);
        CONTACT_PLATE.curveTo(0.43859649122807015 * (double)IMAGE_WIDTH, 0.956140350877193 * (double)IMAGE_HEIGHT, 0.4473684210526316 * (double)IMAGE_WIDTH, 0.9736842105263158 * (double)IMAGE_HEIGHT, 0.4649122807017544 * (double)IMAGE_WIDTH, 0.9912280701754386 * (double)IMAGE_HEIGHT);
        CONTACT_PLATE.curveTo(0.47368421052631576 * (double)IMAGE_WIDTH, 1.0 * (double)IMAGE_HEIGHT, 0.4824561403508772 * (double)IMAGE_WIDTH, 1.0 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 1.0 * (double)IMAGE_HEIGHT);
        CONTACT_PLATE.curveTo(0.5175438596491229 * (double)IMAGE_WIDTH, 1.0 * (double)IMAGE_HEIGHT, 0.5263157894736842 * (double)IMAGE_WIDTH, 0.9912280701754386 * (double)IMAGE_HEIGHT, 0.5350877192982456 * (double)IMAGE_WIDTH, 0.9912280701754386 * (double)IMAGE_HEIGHT);
        CONTACT_PLATE.curveTo(0.543859649122807 * (double)IMAGE_WIDTH, 0.9824561403508771 * (double)IMAGE_HEIGHT, 0.5614035087719298 * (double)IMAGE_WIDTH, 0.956140350877193 * (double)IMAGE_HEIGHT, 0.5789473684210527 * (double)IMAGE_WIDTH, 0.9473684210526315 * (double)IMAGE_HEIGHT);
        CONTACT_PLATE.curveTo(0.5526315789473685 * (double)IMAGE_WIDTH, 0.9385964912280702 * (double)IMAGE_HEIGHT, 0.5263157894736842 * (double)IMAGE_WIDTH, 0.9385964912280702 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.9385964912280702 * (double)IMAGE_HEIGHT);
        CONTACT_PLATE.curveTo(0.47368421052631576 * (double)IMAGE_WIDTH, 0.9385964912280702 * (double)IMAGE_HEIGHT, 0.4473684210526316 * (double)IMAGE_WIDTH, 0.9385964912280702 * (double)IMAGE_HEIGHT, 0.42105263157894735 * (double)IMAGE_WIDTH, 0.9473684210526315 * (double)IMAGE_HEIGHT);
        CONTACT_PLATE.closePath();
        G2.setPaint(new LinearGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.9385964912280702 * (double)IMAGE_HEIGHT), new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 1.0 * (double)IMAGE_HEIGHT), new float[]{0.0f, 0.61f, 0.71f, 0.83f, 1.0f}, new Color[]{new Color(0.019607844f, 0.039215688f, 0.023529412f, 1.0f), new Color(0.02745098f, 0.023529412f, 0.007843138f, 1.0f), new Color(0.6f, 0.57254905f, 0.53333336f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f)}));
        G2.fill(CONTACT_PLATE);
        G2.dispose();
        return IMAGE;
    }

    @Override
    public String toString() {
        return "LightBulb";
    }
}

