/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.custom;

import eu.hansolo.custom.SteelCheckBox;
import eu.hansolo.tools.ConicalGradientPaint;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicCheckBoxUI;

public class SteelCheckBoxUI
extends BasicCheckBoxUI
implements PropertyChangeListener,
ComponentListener,
MouseListener {
    private final SteelCheckBox CHECKBOX;
    private boolean mouseOver = false;
    private boolean mousePressed = false;
    private static final Dimension SIZE = new Dimension(26, 13);
    private BufferedImage backgroundImage;
    private BufferedImage knobStandardImage;
    private BufferedImage knobPressedImage;
    private Point pos;
    private RoundRectangle2D foreground;
    private Point2D foregroundStart;
    private Point2D foregroundStop;
    private final float[] FOREGROUND_FRACTIONS;
    private Color[] foregroundColors;
    private LinearGradientPaint foregroundGradient;

    public SteelCheckBoxUI(SteelCheckBox steelCheckBox) {
        this.backgroundImage = this.create_BACKGROUND_Image(SteelCheckBoxUI.SIZE.width);
        this.knobStandardImage = this.create_KNOB_Image(SteelCheckBoxUI.SIZE.height, false);
        this.knobPressedImage = this.create_KNOB_Image(SteelCheckBoxUI.SIZE.height, true);
        this.pos = new Point(0, 0);
        this.FOREGROUND_FRACTIONS = new float[]{0.0f, 0.03f, 0.94f, 1.0f};
        this.foregroundColors = new Color[]{new Color(241, 242, 242, 255), new Color(224, 225, 226, 255), new Color(166, 169, 171, 255), new Color(124, 124, 124, 255)};
        this.CHECKBOX = steelCheckBox;
        this.CHECKBOX.addComponentListener(this);
        this.CHECKBOX.addMouseListener(this);
        this.CHECKBOX.addPropertyChangeListener(this);
        this.init();
    }

    private void init() {
        this.foreground = new RoundRectangle2D.Double((double)this.pos.x + (double)this.backgroundImage.getWidth() * 0.03846153989434242, (double)this.pos.y + (double)this.backgroundImage.getHeight() * 0.0714285746216774, (double)this.backgroundImage.getWidth() * 0.923076868057251, (double)this.backgroundImage.getHeight() * 0.8571428060531616, (double)this.backgroundImage.getHeight() * 0.8571428571, (double)this.backgroundImage.getHeight() * 0.8571428571);
        this.foregroundStart = new Point2D.Double(this.pos.x, this.foreground.getBounds2D().getMinY());
        this.foregroundStop = new Point2D.Double(this.pos.x, this.foreground.getBounds2D().getMaxY());
        this.foregroundGradient = new LinearGradientPaint(this.foregroundStart, this.foregroundStop, this.FOREGROUND_FRACTIONS, this.foregroundColors);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.CHECKBOX.addComponentListener(this);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.CHECKBOX.removeComponentListener(this);
    }

    @Override
    public synchronized void paint(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.pos.setLocation(0.0, (double)(this.CHECKBOX.getPreferredSize().height - SteelCheckBoxUI.SIZE.height) / 2.0);
        if (!this.CHECKBOX.isEnabled()) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
        }
        graphics2D.drawImage((Image)this.backgroundImage, this.pos.x, this.pos.y, null);
        if (this.CHECKBOX.isSelected()) {
            this.foregroundColors = this.CHECKBOX.isColored() ? (this.CHECKBOX.isRised() ? new Color[]{this.CHECKBOX.getSelectedColor().LIGHT.brighter(), this.CHECKBOX.getSelectedColor().LIGHT, this.CHECKBOX.getSelectedColor().MEDIUM, this.CHECKBOX.getSelectedColor().DARK} : new Color[]{this.CHECKBOX.getSelectedColor().DARK, this.CHECKBOX.getSelectedColor().DARK, this.CHECKBOX.getSelectedColor().LIGHT, this.CHECKBOX.getSelectedColor().MEDIUM}) : new Color[]{new Color(241, 242, 242, 255), new Color(224, 225, 226, 255), new Color(166, 169, 171, 255), new Color(124, 124, 124, 255)};
            this.foregroundGradient = new LinearGradientPaint(this.foregroundStart, this.foregroundStop, this.FOREGROUND_FRACTIONS, this.foregroundColors);
            graphics2D.setPaint(this.foregroundGradient);
            graphics2D.fill(this.foreground);
            if (this.mouseOver && this.mousePressed) {
                graphics2D.drawImage((Image)this.knobPressedImage, this.pos.x + this.backgroundImage.getWidth() / 2, this.pos.y, null);
            } else {
                graphics2D.drawImage((Image)this.knobStandardImage, this.pos.x + this.backgroundImage.getWidth() / 2, this.pos.y, null);
            }
        } else if (this.mouseOver && this.mousePressed) {
            graphics2D.drawImage((Image)this.knobPressedImage, this.pos.x, this.pos.y, null);
        } else {
            graphics2D.drawImage((Image)this.knobStandardImage, this.pos.x, this.pos.y, null);
        }
        graphics2D.setColor(this.CHECKBOX.getForeground());
        graphics2D.setFont(this.CHECKBOX.getFont());
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        TextLayout textLayout = new TextLayout(this.CHECKBOX.getText(), graphics2D.getFont(), fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        graphics2D.drawString(this.CHECKBOX.getText(), this.backgroundImage.getWidth() + 5, (this.CHECKBOX.getBounds().height - rectangle2D.getBounds().height) / 2 + rectangle2D.getBounds().height);
        graphics2D.dispose();
    }

    private BufferedImage create_KNOB_Image(int n, boolean bl) {
        Object object;
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double((double)n2 * 0.0, (double)n3 * 0.0, (double)n2 * 1.0, (double)n3 * 1.0);
        Point2D.Double double_2 = new Point2D.Double(0.0, double_.getBounds2D().getMinY());
        Point2D.Double double_3 = new Point2D.Double(0.0, double_.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.25f, 0.51f, 0.76f, 1.0f};
        Color[] colorArray = new Color[]{new Color(90, 91, 92, 255), new Color(127, 127, 128, 255), new Color(81, 82, 83, 255), new Color(104, 105, 105, 255), new Color(63, 64, 65, 255)};
        if (double_2.distance(double_3) > 0.0) {
            object = new LinearGradientPaint(double_2, double_3, fArray, colorArray);
            graphics2D.setPaint((Paint)object);
            graphics2D.fill(double_);
        }
        object = new Ellipse2D.Double((double)n2 * 0.07692307978868484, (double)n3 * 0.07692307978868484, (double)n2 * 0.8461538553237915, (double)n3 * 0.8461538553237915);
        Point2D.Double double_4 = new Point2D.Double(((RectangularShape)object).getCenterX(), ((RectangularShape)object).getCenterY());
        float[] fArray2 = new float[]{0.0f, 40.0f, 90.0f, 140.0f, 220.0f, 270.0f, 320.0f};
        Color[] colorArray2 = bl ? new Color[]{new Color(0xC2C2C2), new Color(7501432), new Color(0xC2C2C2), new Color(7501432), new Color(0xC2C2C2), new Color(7501432), new Color(0xC2C2C2)} : new Color[]{new Color(0xF2F2F2), new Color(9409430), new Color(0xF2F2F2), new Color(9409430), new Color(0xF2F2F2), new Color(9409430), new Color(0xF2F2F2)};
        ConicalGradientPaint conicalGradientPaint = new ConicalGradientPaint(true, double_4, 0.0f, fArray2, colorArray2);
        graphics2D.setPaint(conicalGradientPaint);
        graphics2D.fill((Shape)object);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_BACKGROUND_Image(int n) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, (int)(0.5384615384615384 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double((double)n2 * 0.0, (double)n3 * 0.0, (double)n2 * 1.0, (double)n3 * 1.0, n3, n3);
        Point2D.Double double_2 = new Point2D.Double(0.0, double_.getBounds2D().getMinY());
        Point2D.Double double_3 = new Point2D.Double(0.0, double_.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.51f, 1.0f};
        Color[] colorArray = new Color[]{new Color(68, 68, 68, 255), new Color(105, 105, 106, 255), new Color(216, 217, 218, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_3, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_);
        RoundRectangle2D.Double double_4 = new RoundRectangle2D.Double((double)n2 * 0.03846153989434242, (double)n3 * 0.0714285746216774, (double)n2 * 0.923076868057251, (double)n3 * 0.8571428060531616, n3, n3);
        Point2D.Double double_5 = new Point2D.Double(0.0, double_4.getBounds2D().getMinY());
        Point2D.Double double_6 = new Point2D.Double(0.0, double_4.getBounds2D().getMaxY());
        float[] fArray2 = new float[]{0.0f, 0.96f, 1.0f};
        Color[] colorArray2 = new Color[]{new Color(91, 91, 91, 255), new Color(138, 138, 138, 255), new Color(124, 124, 124, 255)};
        if (double_5.distance(double_6) > 0.0) {
            LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_5, double_6, fArray2, colorArray2);
            graphics2D.setPaint(linearGradientPaint2);
            graphics2D.fill(double_4);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public Point2D getCenteredTextPosition(Graphics2D graphics2D, Rectangle2D rectangle2D, Font font, String string, int n) {
        double d;
        double d2;
        double d3 = rectangle2D.getWidth() / 2.0;
        double d4 = rectangle2D.getHeight() / 2.0;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        Rectangle2D rectangle2D2 = textLayout.getBounds();
        switch (n) {
            case 0: {
                d2 = d3 - rectangle2D2.getWidth() / 2.0;
                d = d4 - rectangle2D2.getHeight() / 2.0 + rectangle2D2.getHeight();
                break;
            }
            case 2: {
                d2 = rectangle2D.getMinX();
                d = d4 - rectangle2D2.getHeight() / 2.0 + rectangle2D2.getHeight();
                break;
            }
            case 4: {
                d2 = rectangle2D.getMaxX() - rectangle2D2.getWidth();
                d = d4 - rectangle2D2.getHeight() / 2.0 + rectangle2D2.getHeight();
                break;
            }
            default: {
                d2 = d3 - rectangle2D2.getWidth() / 2.0;
                d = d4 - rectangle2D2.getHeight() / 2.0 + rectangle2D2.getHeight();
            }
        }
        return new Point2D.Double(d2, d);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.mousePressed = false;
        this.CHECKBOX.repaint();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mousePressed = true;
        this.CHECKBOX.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.mousePressed = false;
        this.CHECKBOX.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseOver = true;
        this.CHECKBOX.repaint();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseOver = false;
        this.CHECKBOX.repaint();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.init();
        this.pos.setLocation(0.0, (double)(componentEvent.getComponent().getHeight() - SteelCheckBoxUI.SIZE.height) / 2.0);
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.init();
        this.CHECKBOX.repaint();
    }

    public String toString() {
        return "SteelCheckBoxUI";
    }
}

