/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.Poi;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum Util {
    INSTANCE;

    private final float INT_TO_FLOAT_CONST = 0.003921569f;
    private final Pattern NUMBERS_ONLY = Pattern.compile("^[-+]?[0-9]+[.]?[0-9]*([eE][-+]?[0-9]+)?$");
    private final Matcher MATCHES_NUMBERS = this.NUMBERS_ONLY.matcher("");
    private Font digitalFont = null;
    private Font standardFont = new Font("Verdana", 1, 24);

    private Util() {
        try {
            this.digitalFont = Font.createFont(0, ((Object)((Object)this)).getClass().getResourceAsStream("lcd.ttf"));
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(this.digitalFont);
        }
        catch (FontFormatException fontFormatException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public double distanceTo(Poi poi, Poi poi2) {
        return this.distanceTo(poi.getLon(), poi.getLat(), poi2.getLon(), poi2.getLat());
    }

    public double distanceTo(double d, double d2, double d3, double d4) {
        return Math.abs(Math.acos(Math.sin(Math.toRadians(d)) * Math.sin(Math.toRadians(d3)) + Math.cos(Math.toRadians(d)) * Math.cos(Math.toRadians(d3)) * Math.cos(Math.toRadians(d2 - d4))) * 6371000.0);
    }

    public Poi shiftTo(Poi poi, double d, double d2) {
        double d3 = Math.toRadians(poi.getLon());
        double d4 = Math.toRadians(poi.getLat());
        double d5 = Math.asin(Math.sin(d4) * Math.cos(d / 6371000.0) + Math.cos(d4) * Math.sin(d / 6371000.0) * Math.cos(Math.toRadians(d2)));
        double d6 = d3 + Math.atan2(Math.sin(Math.toRadians(d2)) * Math.sin(d / 6371000.0) * Math.cos(d4), Math.cos(d / 6371000.0) - Math.sin(d4) * Math.sin(d5));
        double d7 = (d6 + Math.PI * 3) % (Math.PI * 2) - Math.PI;
        return new Poi(poi.getName(), Math.toDegrees(d7), Math.toDegrees(d5));
    }

    public Poi shiftTo(String string, double d, double d2, double d3, double d4) {
        return this.shiftTo(new Poi(string, d, d2), d3, d4);
    }

    public Point2D toXY(double d, double d2, Rectangle rectangle) {
        double d3 = d * -1.0 + 90.0;
        double d4 = d2 + 180.0;
        double d5 = Math.round(d4 * (rectangle.getWidth() / 360.0));
        double d6 = Math.round(d3 * (rectangle.getHeight() / 180.0));
        return new Point2D.Double(d5, d6);
    }

    public Point2D toXY(Poi poi, Rectangle rectangle) {
        return this.toXY(poi.getLat(), poi.getLon(), rectangle);
    }

    public Shape rotateTextAroundCenter(Graphics2D graphics2D, String string, int n, int n2, double d) {
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        TextLayout textLayout = new TextLayout(string, graphics2D.getFont(), fontRenderContext);
        this.MATCHES_NUMBERS.reset(string);
        float f = this.MATCHES_NUMBERS.matches() ? textLayout.getDescent() : 0.0f;
        Rectangle2D.Double double_ = new Rectangle2D.Double(textLayout.getBounds().getMinX(), textLayout.getBounds().getMinY(), textLayout.getBounds().getWidth(), textLayout.getBounds().getHeight() + (double)(f / 2.0f));
        GlyphVector glyphVector = graphics2D.getFont().createGlyphVector(fontRenderContext, string);
        Shape shape = glyphVector.getOutline((int)(-double_.getCenterX()), 2 * (int)double_.getCenterY());
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate((double)n, (double)n2 + ((RectangularShape)double_).getHeight());
        graphics2D.rotate(Math.toRadians(d), -double_.getCenterX() + ((RectangularShape)double_).getWidth() / 2.0, double_.getCenterY() - (((RectangularShape)double_).getHeight() + (double)f) / 2.0);
        graphics2D.fill(shape);
        graphics2D.setTransform(affineTransform);
        return shape;
    }

    public Color setAlpha(Color color, float f) {
        return this.setAlpha(color, (int)(255.0f * f));
    }

    public Color setAlpha(Color color, int n) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    public Color getColorFromFraction(Color color, Color color2, int n, int n2) {
        float f = (float)color.getRed() * 0.003921569f;
        float f2 = (float)color.getGreen() * 0.003921569f;
        float f3 = (float)color.getBlue() * 0.003921569f;
        float f4 = (float)color.getAlpha() * 0.003921569f;
        float f5 = (float)color2.getRed() * 0.003921569f;
        float f6 = (float)color2.getGreen() * 0.003921569f;
        float f7 = (float)color2.getBlue() * 0.003921569f;
        float f8 = (float)color2.getAlpha() * 0.003921569f;
        float f9 = f5 - f;
        float f10 = f6 - f2;
        float f11 = f7 - f3;
        float f12 = f8 - f4;
        float f13 = f9 / (float)n;
        float f14 = f10 / (float)n;
        float f15 = f11 / (float)n;
        float f16 = f12 / (float)n;
        return new Color(f + f13 * (float)n2, f2 + f14 * (float)n2, f3 + f15 * (float)n2, f4 + f16 * (float)n2);
    }

    public Color setBrightness(Color color, float f) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return Color.getHSBColor(fArray[0], fArray[1], f);
    }

    public Color setSaturation(Color color, float f) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return Color.getHSBColor(fArray[0], f, fArray[2]);
    }

    public Color setHue(Color color, float f) {
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        return Color.getHSBColor(f, fArray[1], fArray[2]);
    }

    public Font getDigitalFont() {
        if (this.digitalFont == null) {
            this.digitalFont = this.standardFont;
        }
        return this.digitalFont.deriveFont(24);
    }

    public Font getStandardFont() {
        return this.standardFont;
    }
}

