/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public enum Shadow {
    INSTANCE;


    public BufferedImage createImageFromShape(Shape shape, Paint paint, Color color, boolean bl, Stroke stroke, Color color2) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(shape.getBounds().width, shape.getBounds().height, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.translate(-shape.getBounds2D().getX(), -shape.getBounds2D().getY());
        if (paint != null) {
            graphics2D.setPaint(paint);
            if (bl) {
                graphics2D.fill(shape);
            } else {
                graphics2D.draw(shape);
            }
        }
        if (color != null) {
            graphics2D.setColor(color);
            if (bl) {
                graphics2D.fill(shape);
            } else {
                graphics2D.draw(shape);
            }
        }
        if (stroke != null) {
            if (color2 != null) {
                graphics2D.setColor(color2);
            }
            graphics2D.setStroke(stroke);
            if (!bl) {
                graphics2D.draw(shape);
            }
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage createDropShadow(BufferedImage bufferedImage, int n, float f, int n2, int n3, Color color) {
        float f2 = (float)((double)n * Math.cos(Math.toRadians(360 - n3)));
        float f3 = (float)((double)n * Math.sin(Math.toRadians(360 - n3)));
        BufferedImage bufferedImage2 = this.renderDropShadow(bufferedImage, n2, f, color);
        BufferedImage bufferedImage3 = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), 2);
        Graphics2D graphics2D = bufferedImage3.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.translate(f2, f3);
        graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
        graphics2D.translate(-f2, -f3);
        graphics2D.translate(n2, n2);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage3;
    }

    public BufferedImage createDropShadow(Shape shape, Paint paint, Color color, boolean bl, Stroke stroke, Color color2, int n, float f, int n2, int n3, Color color3) {
        float f2 = (float)((double)n * Math.cos(Math.toRadians(360 - n3)));
        float f3 = (float)((double)n * Math.sin(Math.toRadians(360 - n3)));
        BufferedImage bufferedImage = this.createImageFromShape(shape, paint, color, bl, stroke, color2);
        BufferedImage bufferedImage2 = this.renderDropShadow(bufferedImage, n2, f, color3);
        BufferedImage bufferedImage3 = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), 2);
        Graphics2D graphics2D = bufferedImage3.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.translate(f2, f3);
        graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
        graphics2D.translate(-f2, -f3);
        graphics2D.translate(n2, n2);
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage3;
    }

    public BufferedImage createInnerShadow(BufferedImage bufferedImage, Shape shape, int n, float f, Color color, int n2, int n3) {
        float f2 = 0.003921569f * (float)color.getRed();
        float f3 = 0.003921569f * (float)color.getGreen();
        float f4 = 0.003921569f * (float)color.getBlue();
        float f5 = n2 * 2;
        float f6 = 1.0f / (float)(2 * n2 + 2) * f;
        float f7 = (float)((double)n * Math.cos(Math.toRadians(n3)));
        float f8 = (float)((double)n * Math.sin(Math.toRadians(n3)));
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.translate(-shape.getBounds2D().getX(), -shape.getBounds2D().getY());
        graphics2D.setColor(new Color(f2, f3, f4, f6));
        graphics2D.setComposite(AlphaComposite.SrcAtop);
        graphics2D.translate(f7, -f8);
        for (float f9 = (float)n2; f9 >= 1.0f; f9 -= 1.0f) {
            graphics2D.setStroke(new BasicStroke((float)((double)f5 * Math.pow(0.85, f9))));
            graphics2D.draw(shape);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage createInnerShadow(Shape shape, Paint paint, int n, float f, Color color, int n2, int n3) {
        float f2 = 0.003921569f * (float)color.getRed();
        float f3 = 0.003921569f * (float)color.getGreen();
        float f4 = 0.003921569f * (float)color.getBlue();
        float f5 = n2 * 2;
        float f6 = 1.0f / (float)(2 * n2 + 2) * f;
        float f7 = (float)((double)n * Math.cos(Math.toRadians(n3)));
        float f8 = (float)((double)n * Math.sin(Math.toRadians(n3)));
        BufferedImage bufferedImage = this.createSoftClipImage(shape, paint, 0, 0, 0);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.translate(-shape.getBounds2D().getX(), -shape.getBounds2D().getY());
        graphics2D.setColor(new Color(f2, f3, f4, f6));
        graphics2D.setComposite(AlphaComposite.SrcAtop);
        graphics2D.translate(f7, -f8);
        for (float f9 = (float)n2; f9 >= 1.0f; f9 -= 1.0f) {
            graphics2D.setStroke(new BasicStroke((float)((double)f5 * Math.pow(0.85, f9))));
            graphics2D.draw(shape);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public BufferedImage createSoftClipImage(Shape shape, Paint paint) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(shape.getBounds().width, shape.getBounds().height, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (paint != null) {
            graphics2D.setPaint(paint);
        }
        graphics2D.translate(-shape.getBounds2D().getX(), -shape.getBounds2D().getY());
        graphics2D.fill(shape);
        return bufferedImage;
    }

    public BufferedImage createSoftClipImage(Shape shape, Paint paint, int n, int n2, int n3) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(shape.getBounds().width + 2 * n + n2, shape.getBounds().height + 2 * n + n3, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.translate((double)n / 2.0, (double)n / 2.0);
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (paint != null) {
            graphics2D.setPaint(paint);
        }
        graphics2D.translate(-shape.getBounds2D().getX(), -shape.getBounds2D().getY());
        graphics2D.fill(shape);
        return bufferedImage;
    }

    public BufferedImage renderDropShadow(BufferedImage bufferedImage, int n, float f, Color color) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = n * 2;
        int n9 = bufferedImage.getWidth();
        int n10 = bufferedImage.getHeight();
        int n11 = n9 + n8;
        int n12 = n10 + n8;
        int n13 = n;
        int n14 = n8 - n13;
        int n15 = n12 - n14;
        int n16 = color.getRGB() & 0xFFFFFF;
        int[] nArray = new int[n8];
        BufferedImage bufferedImage2 = new BufferedImage(n11, n12, 2);
        int[] nArray2 = new int[n11 * n12];
        int[] nArray3 = new int[n9 * n10];
        this.getPixels(bufferedImage, 0, 0, n9, n10, nArray3);
        int n17 = n14 * n11;
        float f2 = 1.0f / (float)n8;
        float f3 = f / (float)n8;
        int[] nArray4 = new int[256 * n8];
        int n18 = nArray4.length;
        for (int i = 0; i < n18; ++i) {
            nArray4[i] = (int)((float)i * f2);
        }
        int[] nArray5 = new int[256 * n8];
        n18 = nArray5.length;
        for (n7 = 0; n7 < n18; ++n7) {
            nArray5[n7] = (int)((float)n7 * f3);
        }
        int n19 = n13 * n11;
        for (n6 = 0; n6 < n10; ++n6) {
            n5 = 0;
            while (n5 < n8) {
                nArray[n5++] = 0;
            }
            n4 = 0;
            n5 = 0;
            n7 = n6 * n9;
            for (n3 = 0; n3 < n9; ++n3) {
                n2 = nArray4[n4];
                nArray2[n19++] = n2 << 24;
                n4 -= nArray[n5];
                nArray[n5] = n2 = nArray3[n7 + n3] >>> 24;
                n4 += n2;
                if (++n5 < n8) continue;
                n5 -= n8;
            }
            for (n3 = 0; n3 < n8; ++n3) {
                n2 = nArray4[n4];
                nArray2[n19++] = n2 << 24;
                n4 -= nArray[n5];
                if (++n5 < n8) continue;
                n5 -= n8;
            }
        }
        n6 = 0;
        n19 = 0;
        while (n6 < n11) {
            n4 = 0;
            n5 = 0;
            while (n5 < n13) {
                nArray[n5++] = 0;
            }
            n3 = 0;
            while (n3 < n14) {
                n2 = nArray2[n19] >>> 24;
                nArray[n5++] = n2;
                n4 += n2;
                ++n3;
                n19 += n11;
            }
            n19 = n6;
            n5 = 0;
            n3 = 0;
            while (n3 < n15) {
                n2 = nArray5[n4];
                nArray2[n19] = n2 << 24 | n16;
                n4 -= nArray[n5];
                nArray[n5] = n2 = nArray2[n19 + n17] >>> 24;
                n4 += n2;
                if (++n5 >= n8) {
                    n5 -= n8;
                }
                ++n3;
                n19 += n11;
            }
            n3 = n15;
            while (n3 < n12) {
                n2 = nArray5[n4];
                nArray2[n19] = n2 << 24 | n16;
                n4 -= nArray[n5];
                if (++n5 >= n8) {
                    n5 -= n8;
                }
                ++n3;
                n19 += n11;
            }
            n19 = ++n6;
        }
        this.setPixels(bufferedImage2, 0, 0, n11, n12, nArray2);
        return bufferedImage2;
    }

    public int[] getPixels(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int[] nArray) {
        if (n3 == 0 || n4 == 0) {
            return new int[0];
        }
        if (nArray == null) {
            nArray = new int[n3 * n4];
        } else if (nArray.length < n3 * n4) {
            throw new IllegalArgumentException("pixels array must have a length  >= w*h");
        }
        int n5 = bufferedImage.getType();
        if (n5 == 2 || n5 == 1) {
            WritableRaster writableRaster = bufferedImage.getRaster();
            return (int[])writableRaster.getDataElements(n, n2, n3, n4, nArray);
        }
        return bufferedImage.getRGB(n, n2, n3, n4, nArray, 0, n3);
    }

    public void setPixels(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int[] nArray) {
        if (nArray == null || n3 == 0 || n4 == 0) {
            return;
        }
        if (nArray.length < n3 * n4) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int n5 = bufferedImage.getType();
        if (n5 == 2 || n5 == 1) {
            WritableRaster writableRaster = bufferedImage.getRaster();
            writableRaster.setDataElements(n, n2, n3, n4, nArray);
        } else {
            bufferedImage.setRGB(n, n2, n3, n4, nArray, 0, n3);
        }
    }
}

