/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class Poi {
    private final String NAME;
    private double lat = 0.0;
    private double lon = 0.0;
    private String latDirection = "N";
    private String lonDirection = "W";
    private final Rectangle WORLD_MAP = new Rectangle(0, 0, 40000, 20000);
    private final Point2D LOCATION = new Point2D.Double(this.lon, this.lat);
    private Point2D LOCATION_XY = new Point2D.Double(0.0, 0.0);
    private final BufferedImage POI_IMAGE = this.create_POI_Image(5);

    public Poi(String string) {
        this(string, 0.0, 0.0);
    }

    public Poi(String string, double d, double d2) {
        this.NAME = string;
        this.lat = d;
        this.lon = d2;
        this.setLocation(d, d2);
        this.adjustDirection();
    }

    public Poi(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        this.NAME = string;
        this.lat = this.convert(n, n2, n3);
        this.lon = this.convert(n4, n5, n6);
        this.setLocation(this.lat, this.lon);
        this.adjustDirection();
    }

    public Poi(String string, int n, double d, int n2, double d2) {
        this.NAME = string;
        this.lat = this.convert(n, d);
        this.lon = this.convert(n2, d2);
        this.setLocation(this.lat, this.lon);
        this.adjustDirection();
    }

    public Poi(String string, String string2, int n, double d, String string3, int n2, double d2) {
        this.NAME = string;
        this.lat = this.convert(n, d);
        this.lon = this.convert(n2, d2);
        if (string2.equalsIgnoreCase("S")) {
            this.lat *= -1.0;
        }
        if (string3.equalsIgnoreCase("W")) {
            this.lon *= -1.0;
        }
        this.setLocation(this.lat, this.lon);
        this.adjustDirection();
    }

    public Poi(String string, String string2, int n, int n2, int n3, String string3, int n4, int n5, int n6) {
        this.NAME = string;
        this.lat = this.convert(n, n2, n3);
        this.lon = this.convert(n4, n5, n6);
        if (string2.equalsIgnoreCase("S")) {
            this.lat *= -1.0;
        }
        if (string3.equalsIgnoreCase("W")) {
            this.lon *= -1.0;
        }
        this.setLocation(this.lat, this.lon);
        this.adjustDirection();
    }

    public String getName() {
        return this.NAME;
    }

    public BufferedImage getPoiImage() {
        return this.POI_IMAGE;
    }

    public double getLon() {
        return this.lon;
    }

    public void setLon(double d) {
        this.lon = d;
        this.LOCATION.setLocation(this.lat, this.lon);
        this.adjustDirection();
    }

    public void setLon(int n, int n2, int n3) {
        this.lon = this.convert(n, n2, n3);
        this.LOCATION.setLocation(this.lat, this.lon);
        this.adjustDirection();
    }

    public void setLon(int n, double d) {
        this.lon = this.convert(n, d);
        this.LOCATION.setLocation(this.lat, this.lon);
        this.adjustDirection();
    }

    public double getLat() {
        return this.lat;
    }

    public void setLat(double d) {
        this.lat = d;
        this.LOCATION.setLocation(this.lat, this.lon);
        this.adjustDirection();
    }

    public void setLat(int n, int n2, int n3) {
        this.lat = this.convert(n, n2, n3);
        this.LOCATION.setLocation(this.lat, this.lon);
        this.adjustDirection();
    }

    public void setLat(int n, double d) {
        this.lat = this.convert(n, d);
        this.LOCATION.setLocation(this.lat, this.lon);
        this.adjustDirection();
    }

    public String getLonDirection() {
        return this.lonDirection;
    }

    public String getLatDirection() {
        return this.latDirection;
    }

    public Point2D getLocation() {
        return this.LOCATION;
    }

    public void setLocation(Point2D point2D) {
        this.lon = point2D.getX();
        this.lat = point2D.getY();
        this.LOCATION.setLocation(point2D);
        this.LOCATION_XY.setLocation(this.toXY(this.lat, this.lon));
        this.adjustDirection();
    }

    public final void setLocation(double d, double d2) {
        this.lon = d2;
        this.lat = d;
        this.LOCATION.setLocation(d2, d);
        this.LOCATION_XY.setLocation(this.toXY(d, d2));
        this.adjustDirection();
    }

    public Point2D getLocationXY() {
        return this.LOCATION_XY;
    }

    public double distanceTo(Poi poi) {
        return this.distanceTo(poi.getLat(), poi.getLon());
    }

    public double distanceTo(double d, double d2) {
        return Math.abs(Math.acos(Math.sin(Math.toRadians(d)) * Math.sin(Math.toRadians(this.lat)) + Math.cos(Math.toRadians(d)) * Math.cos(Math.toRadians(this.lat)) * Math.cos(Math.toRadians(d2 - this.lon))) * 6371000.0);
    }

    public Point2D shiftTo(double d, double d2) {
        double d3 = Math.toRadians(this.lon);
        double d4 = Math.toRadians(this.lat);
        double d5 = Math.asin(Math.sin(d4) * Math.cos(d / 6371000.0) + Math.cos(d4) * Math.sin(d / 6371000.0) * Math.cos(Math.toRadians(d2)));
        double d6 = d3 + Math.atan2(Math.sin(Math.toRadians(d2)) * Math.sin(d / 6371000.0) * Math.cos(d4), Math.cos(d / 6371000.0) - Math.sin(d4) * Math.sin(d5));
        double d7 = (d6 + Math.PI * 3) % (Math.PI * 2) - Math.PI;
        this.setLocation(Math.toDegrees(d5), Math.toDegrees(d7));
        return this.getLocation();
    }

    private void adjustDirection() {
        this.latDirection = this.lat > 0.0 ? "N" : "S";
        this.lonDirection = this.lon > 0.0 ? "E" : "W";
    }

    private double convert(int n, int n2, int n3) {
        return n + n2 / 60 + n3 / 3600;
    }

    private double convert(int n, double d) {
        return (double)n + d / 60.0;
    }

    public final Point2D toXY(double d, double d2) {
        double d3 = d * -1.0 + 90.0;
        double d4 = d2 + 180.0;
        double d5 = Math.round(d4 * (this.WORLD_MAP.getWidth() / 360.0));
        double d6 = Math.round(d3 * (this.WORLD_MAP.getHeight() / 180.0));
        return new Point2D.Double(d5, d6);
    }

    private BufferedImage create_POI_Image(int n) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        Ellipse2D.Double double_ = new Ellipse2D.Double(0.0, 0.0, n, n);
        Point2D.Double double_2 = new Point2D.Double(double_.getCenterX(), double_.getCenterY());
        float[] fArray = new float[]{0.0f, 1.0f};
        Color[] colorArray = new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.9f), new Color(1.0f, 1.0f, 1.0f, 0.0f)};
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_2, (int)((double)n / 2.0), fArray, colorArray);
        graphics2D.setPaint(radialGradientPaint);
        graphics2D.fill(double_);
        graphics2D.dispose();
        return bufferedImage;
    }

    public String toString() {
        return this.getLat() + "," + this.getLon();
    }
}

