/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.Util;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.ease.Spline;
import org.pushingpixels.trident.ease.TimelineEase;

public class Radial4Lcd
extends AbstractRadial {
    private boolean valueCoupled = true;
    private String lcdUnitString;
    private boolean lcdUnitStringVisible = false;
    private double lcdValue = 0.0;
    private static final String LCD_VALUE_PROPERTY = "lcdValue";
    private final double FREE_AREA_ANGLE = Math.toRadians(60.0);
    private double angleStep;
    private double TICKMARK_OFFSET = 0.0;
    private final double ROTATION_OFFSET = Math.PI + this.FREE_AREA_ANGLE / 2.0;
    private int tickLabelPeriod = 10;
    private BufferedImage backgroundImage;
    private BufferedImage postsImage;
    private BufferedImage lcdImage;
    private BufferedImage trackImage;
    private BufferedImage tickmarksImage;
    private BufferedImage pointerImage;
    private BufferedImage pointerShadowImage;
    private BufferedImage foregroundImage;
    private BufferedImage thresholdImage;
    private BufferedImage minMeasuredImage;
    private BufferedImage maxMeasuredImage;
    private boolean digitalFont = false;
    private Font lcdValueFont;
    private Font lcdUnitFont;
    private final Font LCD_STANDARD_FONT = new Font("Verdana", 1, 24);
    private final Font LCD_DIGITAL_FONT = Util.INSTANCE.getDigitalFont().deriveFont(24);
    private LcdColor lcdColor = LcdColor.WHITE_LCD;
    private int lcdDecimals = 0;
    private Timeline lcdTimeline = new Timeline((Object)this);

    public Radial4Lcd() {
        this.calcAngleStep();
        this.lcdUnitString = this.getUnitString();
        this.addComponentListener(this);
        this.setSize(this.getPreferredSize());
        this.init(this.getWidth(), this.getWidth());
    }

    @Override
    public final void init(int n, int n2) {
        if (this.isDigitalFont()) {
            this.lcdValueFont = this.LCD_DIGITAL_FONT.deriveFont(0.7f * (float)n * 0.15f);
            this.lcdUnitFont = this.LCD_STANDARD_FONT.deriveFont(0.25f * (float)n * 0.15f);
        } else {
            this.lcdValueFont = this.LCD_STANDARD_FONT.deriveFont(0.625f * (float)n * 0.15f);
            this.lcdUnitFont = this.LCD_STANDARD_FONT.deriveFont(0.25f * (float)n * 0.15f);
        }
        this.backgroundImage = this.create_BACKGROUND_Image(n, this.getTitle(), this.getUnitString());
        this.postsImage = this.create_POSTS_Image(n);
        this.lcdImage = this.create_LCD_Image((int)((double)n * 0.4), (int)((double)n * 0.15));
        this.trackImage = this.getTrackSection() > this.getTrackStart() && this.getTrackSection() < this.getTrackStart() + this.getTrackRange() ? this.create_TRACK_Image(true, n, this.getMinValue(), this.getMaxValue(), this.angleStep, this.getTrackStart(), this.getTrackSection(), this.getTrackRange(), this.getTrackStartColor(), this.getTrackSectionColor(), this.getTrackStopColor(), this.ROTATION_OFFSET) : this.create_TRACK_Image(false, n, this.getMinValue(), this.getMaxValue(), this.angleStep, this.getTrackStart(), this.getTrackSection(), this.getTrackRange(), this.getTrackStartColor(), this.getTrackSectionColor(), this.getTrackStopColor(), this.ROTATION_OFFSET);
        this.tickmarksImage = this.create_TICKMARKS_Image(n, this.FREE_AREA_ANGLE, this.TICKMARK_OFFSET, this.getMinValue(), this.getMaxValue(), this.angleStep, this.tickLabelPeriod);
        this.thresholdImage = this.create_THRESHOLD_Image(n);
        this.minMeasuredImage = this.create_MEASURED_VALUE_Image(n, new Color(0, 23, 252, 255));
        this.maxMeasuredImage = this.create_MEASURED_VALUE_Image(n, new Color(252, 29, 0, 255));
        this.pointerImage = this.create_POINTER_Image(n);
        this.pointerShadowImage = this.create_POINTER_SHADOW_Image(n);
        this.foregroundImage = this.create_FOREGROUND_Image(n);
        this.setCurrentLedImage(this.getLedImageOff());
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        double d;
        Rectangle2D rectangle2D;
        TextLayout textLayout;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Point2D.Double double_ = new Point2D.Double((double)this.pointerImage.getWidth() / 2.0, (double)this.pointerImage.getWidth() / 2.0);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.drawImage((Image)this.backgroundImage, 0, 0, null);
        graphics2D.drawImage((Image)this.postsImage, 0, 0, null);
        if (this.isTrackVisible()) {
            graphics2D.drawImage((Image)this.trackImage, 0, 0, null);
        }
        graphics2D.drawImage((Image)this.tickmarksImage, 0, 0, null);
        if (this.isThresholdVisible()) {
            graphics2D.rotate(this.ROTATION_OFFSET + (this.getThreshold() - this.getMinValue()) * this.angleStep, ((Point2D)double_).getX(), ((Point2D)double_).getY());
            graphics2D.drawImage((Image)this.thresholdImage, (int)((double)this.backgroundImage.getWidth() * 0.480369999), (int)((double)this.backgroundImage.getHeight() * 0.13), null);
            graphics2D.setTransform(affineTransform);
        }
        if (this.isMinMeasuredValueVisible()) {
            graphics2D.rotate(this.ROTATION_OFFSET + (this.getMinMeasuredValue() - this.getMinValue()) * this.angleStep, ((Point2D)double_).getX(), ((Point2D)double_).getY());
            graphics2D.drawImage((Image)this.minMeasuredImage, (int)((double)this.backgroundImage.getWidth() * 0.4865), (int)((double)this.backgroundImage.getHeight() * 0.105), null);
            graphics2D.setTransform(affineTransform);
        }
        if (this.isMaxMeasuredValueVisible()) {
            graphics2D.rotate(this.ROTATION_OFFSET + (this.getMaxMeasuredValue() - this.getMinValue()) * this.angleStep, ((Point2D)double_).getX(), ((Point2D)double_).getY());
            graphics2D.drawImage((Image)this.maxMeasuredImage, (int)((double)this.backgroundImage.getWidth() * 0.4865), (int)((double)this.backgroundImage.getHeight() * 0.105), null);
            graphics2D.setTransform(affineTransform);
        }
        if (this.isLedVisible()) {
            graphics2D.drawImage((Image)this.getCurrentLedImage(), (int)((double)this.backgroundImage.getWidth() * this.getLedPositionX()), (int)((double)this.backgroundImage.getHeight() * this.getLedPositionY()), null);
        }
        graphics2D.drawImage((Image)this.lcdImage, (int)((double)(this.backgroundImage.getWidth() - this.lcdImage.getWidth()) / 2.0), (int)((double)this.backgroundImage.getHeight() * 0.55), null);
        graphics2D.setColor(this.lcdColor.TEXT_COLOR);
        graphics2D.setFont(this.lcdUnitFont);
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        if (this.lcdUnitStringVisible) {
            textLayout = new TextLayout(this.getUnitString(), graphics2D.getFont(), fontRenderContext);
            rectangle2D = textLayout.getBounds();
            graphics2D.drawString(this.getUnitString(), (int)((double)(this.backgroundImage.getWidth() - this.lcdImage.getWidth()) / 2.0 + ((double)this.lcdImage.getWidth() - rectangle2D.getWidth()) - (double)this.lcdImage.getWidth() * 0.03), (int)((double)this.backgroundImage.getHeight() * 0.55 + (double)((float)this.lcdImage.getHeight() * 0.76f)));
            d = rectangle2D.getWidth();
        } else {
            d = 0.0;
        }
        graphics2D.setFont(this.lcdValueFont);
        textLayout = new TextLayout(this.formatLcdValue(this.getValue()), graphics2D.getFont(), fontRenderContext);
        rectangle2D = textLayout.getBounds();
        graphics2D.drawString(this.formatLcdValue(this.lcdValue), (int)((double)(this.backgroundImage.getWidth() - this.lcdImage.getWidth()) / 2.0 + ((double)this.lcdImage.getWidth() - d - rectangle2D.getWidth()) - (double)this.lcdImage.getWidth() * 0.09), (int)((double)this.backgroundImage.getHeight() * 0.55 + (double)((float)this.lcdImage.getHeight() * 0.76f)));
        double d2 = this.ROTATION_OFFSET + (this.getValue() - this.getMinValue()) * this.angleStep;
        graphics2D.rotate(d2, ((Point2D)double_).getX(), ((Point2D)double_).getY() + 2.0);
        graphics2D.drawImage((Image)this.pointerShadowImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.rotate(d2, ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.drawImage((Image)this.pointerImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.drawImage((Image)this.foregroundImage, 0, 0, null);
    }

    public boolean isValueCoupled() {
        return this.valueCoupled;
    }

    public void setValueCoupled(boolean bl) {
        this.valueCoupled = bl;
        this.lcdUnitStringVisible = !bl;
        this.repaint();
    }

    public int getTickLabelPeriod() {
        return this.tickLabelPeriod;
    }

    public void setTickLabelPeriod(int n) {
        this.tickLabelPeriod = n;
        this.tickmarksImage = this.create_TICKMARKS_Image(this.getWidth(), this.FREE_AREA_ANGLE, this.TICKMARK_OFFSET, this.getMinValue(), this.getMaxValue(), this.angleStep, this.tickLabelPeriod);
        this.repaint();
    }

    @Override
    public void setValue(double d) {
        d = d > this.getMaxValue() ? this.getMaxValue() : d;
        d = d < this.getMinValue() ? this.getMinValue() : d;
        double d2 = this.getValue();
        super.setValue(d);
        this.firePropertyChange("value", d2, d);
        if (this.valueCoupled) {
            this.lcdValue = d;
            this.firePropertyChange(LCD_VALUE_PROPERTY, d2, d);
        }
        this.repaint();
    }

    public double getLcdValue() {
        return this.lcdValue;
    }

    public void setLcdValue(double d) {
        this.lcdValue = d;
        this.repaint();
    }

    public void setLcdValueAnimated(double d) {
        if (this.lcdTimeline.getState() == Timeline.TimelineState.PLAYING_FORWARD || this.lcdTimeline.getState() == Timeline.TimelineState.PLAYING_REVERSE) {
            this.lcdTimeline.abort();
        }
        this.lcdTimeline.addPropertyToInterpolate(LCD_VALUE_PROPERTY, (Object)this.lcdValue, (Object)d);
        this.lcdTimeline.setEase((TimelineEase)new Spline(0.5f));
        this.lcdTimeline.play();
    }

    public String getLcdUnitString() {
        return this.lcdUnitString;
    }

    public void setLcdUnitString(String string) {
        this.lcdUnitString = string;
        this.init(this.getWidth(), this.getWidth());
        this.repaint();
    }

    public boolean isLcdUnitStringVisible() {
        return this.lcdUnitStringVisible;
    }

    public void setLcdUnitStringVisible(boolean bl) {
        this.lcdUnitStringVisible = bl;
        this.init(this.getWidth(), this.getWidth());
        this.repaint();
    }

    public boolean isDigitalFont() {
        return this.digitalFont;
    }

    public void setDigitalFont(boolean bl) {
        this.digitalFont = bl;
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    public int getLcdDecimals() {
        return this.lcdDecimals;
    }

    public void setLcdDecimals(int n) {
        this.lcdDecimals = n;
        this.repaint();
    }

    public LcdColor getLcdColor() {
        return this.lcdColor;
    }

    public void setLcdColor(LcdColor lcdColor) {
        this.lcdColor = lcdColor;
        this.init(this.getWidth(), this.getWidth());
        this.repaint();
    }

    public String formatLcdValue(double d) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("0");
        if (this.lcdDecimals > 0) {
            stringBuilder.append(".");
        }
        for (int i = 0; i < this.lcdDecimals; ++i) {
            stringBuilder.append("0");
        }
        DecimalFormat decimalFormat = new DecimalFormat(stringBuilder.toString(), new DecimalFormatSymbols(Locale.US));
        return decimalFormat.format(d);
    }

    @Override
    protected final void calcAngleStep() {
        this.angleStep = (Math.PI * 2 - this.FREE_AREA_ANGLE) / (this.getMaxValue() - this.getMinValue());
    }

    private BufferedImage create_LCD_Image(int n, int n2) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        Point2D.Double double_2 = new Point2D.Double(0.0, n4);
        float[] fArray = new float[]{0.0f, 0.08f, 0.92f, 1.0f};
        Color[] colorArray = new Color[]{new Color(0.3f, 0.3f, 0.3f, 1.0f), new Color(0.4f, 0.4f, 0.4f, 1.0f), new Color(0.4f, 0.4f, 0.4f, 1.0f), new Color(0.9f, 0.9f, 0.9f, 1.0f)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        double d = (float)n3 * 0.078125f;
        RoundRectangle2D.Double double_3 = new RoundRectangle2D.Double(0.0, 0.0, n3, n4, d, d);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_3);
        Point2D.Double double_4 = new Point2D.Double(0.0, 1.0);
        Point2D.Double double_5 = new Point2D.Double(0.0, n4 - 1);
        float[] fArray2 = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] colorArray2 = new Color[]{this.lcdColor.GRADIENT_START_COLOR, this.lcdColor.GRADIENT_FRACTION1_COLOR, this.lcdColor.GRADIENT_FRACTION2_COLOR, this.lcdColor.GRADIENT_FRACTION3_COLOR, this.lcdColor.GRADIENT_STOP_COLOR};
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_4, double_5, fArray2, colorArray2);
        double d2 = d - (((RectangularShape)double_3).getWidth() - (double)n3 - 2.0) / 2.0;
        RoundRectangle2D.Double double_6 = new RoundRectangle2D.Double(1.0, 1.0, n3 - 2, n4 - 2, d2, d2);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fill(double_6);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_POINTER_Image(int n) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
        generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.45794392523364486, (double)n2 * 0.5093457943925234, (double)n3 * 0.4158878504672897, (double)n2 * 0.5093457943925234, (double)n3 * 0.40186915887850466);
        generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.38317757009345793, (double)n2 * 0.5, (double)n3 * 0.1308411214953271, (double)n2 * 0.5, (double)n3 * 0.1308411214953271);
        generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.1308411214953271, (double)n2 * 0.49065420560747663, (double)n3 * 0.38317757009345793, (double)n2 * 0.49065420560747663, (double)n3 * 0.397196261682243);
        generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.4158878504672897, (double)n2 * 0.48598130841121495, (double)n3 * 0.45794392523364486, (double)n2 * 0.48130841121495327, (double)n3 * 0.4719626168224299);
        generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.48130841121495327, (double)n2 * 0.4672897196261682, (double)n3 * 0.49065420560747663, (double)n2 * 0.4672897196261682, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.5186915887850467, (double)n2 * 0.48130841121495327, (double)n3 * 0.5327102803738317, (double)n2 * 0.5, (double)n3 * 0.5327102803738317);
        generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5327102803738317, (double)n2 * 0.5327102803738317, (double)n3 * 0.5186915887850467, (double)n2 * 0.5327102803738317, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.49065420560747663, (double)n2 * 0.5280373831775701, (double)n3 * 0.48130841121495327, (double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
        generalPath.closePath();
        Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
        Color[] colorArray = new Color[]{this.getPointerColor().DARK, this.getPointerColor().LIGHT, this.getPointerColor().LIGHT, this.getPointerColor().DARK};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        Color color = this.getPointerColor().LIGHT;
        graphics2D.setColor(color);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics2D.draw(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_POINTER_SHADOW_Image(int n) {
        if (n <= 0) {
            return null;
        }
        Color color = new Color(0.0f, 0.0f, 0.0f, 0.65f);
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
        generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.45794392523364486, (double)n2 * 0.5093457943925234, (double)n3 * 0.4158878504672897, (double)n2 * 0.5093457943925234, (double)n3 * 0.40186915887850466);
        generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.38317757009345793, (double)n2 * 0.5, (double)n3 * 0.1308411214953271, (double)n2 * 0.5, (double)n3 * 0.1308411214953271);
        generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.1308411214953271, (double)n2 * 0.49065420560747663, (double)n3 * 0.38317757009345793, (double)n2 * 0.49065420560747663, (double)n3 * 0.397196261682243);
        generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.4158878504672897, (double)n2 * 0.48598130841121495, (double)n3 * 0.45794392523364486, (double)n2 * 0.48130841121495327, (double)n3 * 0.4719626168224299);
        generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.48130841121495327, (double)n2 * 0.4672897196261682, (double)n3 * 0.49065420560747663, (double)n2 * 0.4672897196261682, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.5186915887850467, (double)n2 * 0.48130841121495327, (double)n3 * 0.5327102803738317, (double)n2 * 0.5, (double)n3 * 0.5327102803738317);
        generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5327102803738317, (double)n2 * 0.5327102803738317, (double)n3 * 0.5186915887850467, (double)n2 * 0.5327102803738317, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.49065420560747663, (double)n2 * 0.5280373831775701, (double)n3 * 0.48130841121495327, (double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
        generalPath.closePath();
        graphics2D.setColor(color);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public String toString() {
        return "Radial4Lcd";
    }
}

