/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.DisplaySingle;
import eu.hansolo.steelseries.gauges.Radial2;
import eu.hansolo.steelseries.tools.BackgroundColor;
import eu.hansolo.steelseries.tools.FrameDesign;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.LedColor;
import eu.hansolo.steelseries.tools.PointerColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jdesktop.layout.GroupLayout;

public class Radial2Lcd
extends JComponent
implements ComponentListener {
    private boolean valueCoupled = true;
    private final PropertyChangeListener VALUE_LISTENER = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("value")) {
                Radial2Lcd.this.lcd.setValue(Double.parseDouble(propertyChangeEvent.getNewValue().toString()));
            }
        }
    };
    private Radial2 gauge;
    private DisplaySingle lcd;

    public Radial2Lcd() {
        this.initComponents();
        this.lcd.setUnitStringVisible(false);
        if (this.getParent() != null) {
            this.gauge.init(this.getParent().getWidth(), this.getParent().getWidth());
            this.lcd.setSize((int)((double)this.gauge.getWidth() * 0.55), (int)((double)this.gauge.getWidth() * 0.15));
            this.lcd.setLocation((int)((double)(this.gauge.getWidth() - this.lcd.getWidth()) / 2.0), (int)((double)this.gauge.getWidth() * 0.6));
        }
        this.addComponentListener(this);
        this.gauge.addPropertyChangeListener(this.VALUE_LISTENER);
        this.repaint();
    }

    public boolean isValueCoupled() {
        return this.valueCoupled;
    }

    public void setValueCoupled(boolean bl) {
        this.valueCoupled = bl;
        if (bl) {
            this.addComponentListener(this);
            this.gauge.addPropertyChangeListener(this.VALUE_LISTENER);
            this.lcd.setUnitStringVisible(false);
        } else {
            this.gauge.removePropertyChangeListener(this.VALUE_LISTENER);
            this.lcd.setUnitStringVisible(true);
        }
        this.repaint();
    }

    public double getMinValue() {
        return this.gauge.getMinValue();
    }

    public void setMinValue(double d) {
        this.gauge.setMinValue(d);
    }

    public double getMaxValue() {
        return this.gauge.getMaxValue();
    }

    public void setMaxValue(double d) {
        this.gauge.setMaxValue(d);
    }

    public int getValueTickPeriod() {
        return this.gauge.getTickLabelPeriod();
    }

    public void setValueTickPeriod(int n) {
        this.gauge.setTickLabelPeriod(n);
    }

    public double getValue() {
        return this.gauge.getValue();
    }

    public void setValue(double d) {
        this.gauge.setValue(d);
    }

    public void setValueAnimated(double d) {
        this.gauge.setValueAnimated(d);
    }

    public double getLcdValue() {
        return this.lcd.getValue();
    }

    public void setLcdValue(double d) {
        this.lcd.setValue(d);
    }

    public void setLcdValueAnimated(double d) {
        this.lcd.setValueAnimated(d);
    }

    public LcdColor getLcdColor() {
        return this.lcd.getLcdColor();
    }

    public void setLcdColor(LcdColor lcdColor) {
        this.lcd.setLcdColor(lcdColor);
    }

    public String getTitle() {
        return this.gauge.getTitle();
    }

    public void setTitle(String string) {
        this.gauge.setTitle(string);
    }

    public String getUnitString() {
        return this.gauge.getUnitString();
    }

    public void setUnitString(String string) {
        this.gauge.setUnitString(string);
        if (this.valueCoupled) {
            this.setLcdUnitString(string);
        }
    }

    public String getLcdUnitString() {
        return this.lcd.getUnitString();
    }

    public void setLcdUnitString(String string) {
        this.lcd.setUnitString(string);
    }

    public boolean isLcdUnitStringVisible() {
        return this.lcd.isUnitStringVisible();
    }

    public void setLcdUnitStringVisible(boolean bl) {
        this.lcd.setUnitStringVisible(bl);
    }

    public boolean isDigitalFont() {
        return this.lcd.isDigitalFont();
    }

    public void setDigitalFont(boolean bl) {
        this.lcd.setDigitalFont(bl);
    }

    public int getLcdDecimals() {
        return this.lcd.getLcdDecimals();
    }

    public void setLcdDecimals(int n) {
        this.lcd.setLcdDecimals(n);
    }

    public double getThreshold() {
        return this.gauge.getThreshold();
    }

    public void setThreshold(double d) {
        this.gauge.setThreshold(d);
    }

    public boolean isThresholdVisible() {
        return this.gauge.isThresholdVisible();
    }

    public void setThresholdVisible(boolean bl) {
        this.gauge.setThresholdVisible(bl);
    }

    public double getMinMeasuredValue() {
        return this.gauge.getMinMeasuredValue();
    }

    public boolean isMinMeasuredValueVisible() {
        return this.gauge.isMinMeasuredValueVisible();
    }

    public void setMinMeasuredValueVisible(boolean bl) {
        this.gauge.setMinMeasuredValueVisible(bl);
    }

    public void resetMinMeasuredValue() {
        this.gauge.resetMinMeasuredValue();
    }

    public double getMaxMeasuredValue() {
        return this.gauge.getMaxMeasuredValue();
    }

    public boolean isMaxMeasuredValueVisible() {
        return this.gauge.isMaxMeasuredValueVisible();
    }

    public void setMaxMeasuredValueVisible(boolean bl) {
        this.gauge.setMaxMeasuredValueVisible(bl);
    }

    public void resetMaxMeasuredValue() {
        this.gauge.resetMaxMeasuredValue();
    }

    public boolean isTrackVisible() {
        return this.gauge.isTrackVisible();
    }

    public void setTrackVisible(boolean bl) {
        this.gauge.setTrackVisible(bl);
    }

    public double getTrackStart() {
        return this.gauge.getTrackStart();
    }

    public void setTrackStart(double d) {
        this.gauge.setTrackStart(d);
    }

    public double getTrackSection() {
        return this.gauge.getTrackSection();
    }

    public void setTrackSection(double d) {
        this.gauge.setTrackSection(d);
    }

    public double getTrackRange() {
        return this.gauge.getTrackRange();
    }

    public void setTrackRange(double d) {
        this.gauge.setTrackRange(d);
    }

    public Color getTrackStartColor() {
        return this.gauge.getTrackStartColor();
    }

    public void setTrackStartColor(Color color) {
        this.gauge.setTrackStartColor(color);
    }

    public Color getTrackSectionColor() {
        return this.gauge.getTrackSectionColor();
    }

    public void setTrackSectionColor(Color color) {
        this.gauge.setTrackSectionColor(color);
    }

    public Color getTrackStopColor() {
        return this.gauge.getTrackStopColor();
    }

    public void setTrackStopColor(Color color) {
        this.gauge.setTrackStopColor(color);
    }

    public BackgroundColor getBackgroundColor() {
        return this.gauge.getBackgroundColor();
    }

    public void setBackgroundColor(BackgroundColor backgroundColor) {
        this.gauge.setBackgroundColor(backgroundColor);
    }

    public FrameDesign getFrameDesign() {
        return this.gauge.getFrameDesign();
    }

    public void setFrameDesign(FrameDesign frameDesign) {
        this.gauge.setFrameDesign(frameDesign);
    }

    public PointerColor getPointerColor() {
        return this.gauge.getPointerColor();
    }

    public void setPointerColor(PointerColor pointerColor) {
        this.gauge.setPointerColor(pointerColor);
    }

    public boolean isLedEnabled() {
        return this.gauge.isLedVisible();
    }

    public void setLedEnabled(boolean bl) {
        this.gauge.setLedVisible(bl);
    }

    public boolean isLedBlinking() {
        return this.gauge.isLedBlinking();
    }

    public void setLedBlinking(boolean bl) {
        this.gauge.setLedBlinking(bl);
    }

    public LedColor getLedColor() {
        return this.gauge.getLedColor();
    }

    public void setLedColor(LedColor ledColor) {
        this.gauge.setLedColor(ledColor);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.gauge.setPreferredSize(new Dimension(this.getWidth(), this.getWidth()));
        this.gauge.setSize(this.getWidth(), this.getWidth());
        this.gauge.init(this.getWidth(), this.getWidth());
        this.lcd.setPreferredSize(new Dimension((int)((double)this.gauge.getWidth() * 0.55), (int)((double)this.gauge.getWidth() * 0.15)));
        this.lcd.setSize((int)((double)this.gauge.getWidth() * 0.55), (int)((double)this.gauge.getWidth() * 0.15));
        this.lcd.setLocation((int)((double)(this.gauge.getWidth() - this.lcd.getWidth()) / 2.0), (int)((double)this.gauge.getWidth() * 0.6));
        this.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public String toString() {
        return "Radial2Lcd";
    }

    private void initComponents() {
        this.gauge = new Radial2();
        this.lcd = new DisplaySingle();
        this.gauge.setName("gauge");
        this.lcd.setName("lcd");
        GroupLayout groupLayout = new GroupLayout((Container)this.lcd);
        this.lcd.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 95, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 33, Short.MAX_VALUE));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.gauge);
        this.gauge.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap(52, Short.MAX_VALUE).add((Component)this.lcd, -2, 95, -2).add(53, 53, 53)));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(116, 116, 116).add((Component)this.lcd, -2, 33, -2).addContainerGap(51, Short.MAX_VALUE)));
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.gauge, -2, -1, -2));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((Component)this.gauge, -2, -1, -2));
    }
}

