/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.ConicalGradientPaint;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class Radial1Vertical
extends AbstractRadial
implements ActionListener {
    private final double FREE_AREA_ANGLE = Math.toRadians(0.0);
    private double angleStep;
    private static final double TICKMARK_OFFSET = 2.356194490192345;
    private final double ROTATION_OFFSET = 5.497787143782138 + this.FREE_AREA_ANGLE / 2.0;
    private int tickLabelPeriod = 20;
    private BufferedImage backgroundImage;
    private BufferedImage postsImage;
    private BufferedImage trackImage;
    private BufferedImage tickmarksImage;
    private BufferedImage pointerImage;
    private BufferedImage pointerShadowImage;
    private BufferedImage foregroundImage;
    private BufferedImage thresholdImage;
    private BufferedImage minMeasuredImage;
    private BufferedImage maxMeasuredImage;
    private boolean vertical = true;

    public Radial1Vertical() {
        this.setLedPositionX(0.65);
        this.calcAngleStep();
        this.addComponentListener(this);
        this.setPreferredSize(new Dimension(150, 150));
        this.setSize(this.getPreferredSize());
        this.init(this.getWidth(), this.getWidth());
    }

    @Override
    public final void init(int n, int n2) {
        this.backgroundImage = this.create_BACKGROUND_Image(n);
        this.setLedPositionY(0.5);
        this.postsImage = this.create_POSTS_Image(n);
        this.trackImage = this.getTrackSection() > this.getTrackStart() && this.getTrackSection() < this.getTrackStart() + this.getTrackRange() ? this.create_TRACK_Image(true, n, this.getMinValue(), this.getMaxValue(), this.angleStep, this.getTrackStart(), this.getTrackSection(), this.getTrackRange(), this.getTrackStartColor(), this.getTrackSectionColor(), this.getTrackStopColor(), this.ROTATION_OFFSET) : this.create_TRACK_Image(false, n, this.getMinValue(), this.getMaxValue(), this.angleStep, this.getTrackStart(), this.getTrackSection(), this.getTrackRange(), this.getTrackStartColor(), this.getTrackSectionColor(), this.getTrackStopColor(), this.ROTATION_OFFSET);
        this.tickmarksImage = this.create_TICKMARKS_Image(n, this.FREE_AREA_ANGLE, 2.356194490192345, this.getMinValue(), this.getMaxValue(), this.angleStep, this.tickLabelPeriod);
        this.thresholdImage = this.create_THRESHOLD_Image(n);
        this.minMeasuredImage = this.create_MEASURED_VALUE_Image(n, new Color(0, 23, 252, 255));
        this.maxMeasuredImage = this.create_MEASURED_VALUE_Image(n, new Color(252, 29, 0, 255));
        this.pointerImage = this.create_POINTER_Image(n);
        this.pointerShadowImage = this.create_POINTER_SHADOW_Image(n);
        this.foregroundImage = this.create_FOREGROUND_Image(n, false);
        this.setCurrentLedImage(this.getLedImageOff());
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Rectangle2D rectangle2D;
        Cloneable cloneable;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Point2D.Double double_ = new Point2D.Double((double)this.pointerImage.getWidth() / 2.0, (double)this.pointerImage.getWidth() / 2.0);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.drawImage((Image)this.backgroundImage, 0, 0, null);
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        if (!this.getTitle().isEmpty()) {
            graphics2D.setColor(this.getBackgroundColor().LABEL_COLOR);
            graphics2D.setFont(new Font("Verdana", 0, (int)(0.04672897196261682 * (double)this.backgroundImage.getWidth())));
            cloneable = new TextLayout(this.getTitle(), graphics2D.getFont(), fontRenderContext);
            rectangle2D = ((TextLayout)cloneable).getBounds();
            graphics2D.drawString(this.getTitle(), (float)(((double)this.backgroundImage.getWidth() - rectangle2D.getWidth()) / 2.0), 0.4f * (float)this.backgroundImage.getHeight() + ((TextLayout)cloneable).getAscent() - ((TextLayout)cloneable).getDescent());
        }
        if (!this.getUnitString().isEmpty()) {
            graphics2D.setColor(this.getBackgroundColor().LABEL_COLOR);
            graphics2D.setFont(new Font("Verdana", 0, (int)(0.04672897196261682 * (double)this.backgroundImage.getWidth())));
            cloneable = new TextLayout(this.getUnitString(), graphics2D.getFont(), fontRenderContext);
            rectangle2D = ((TextLayout)cloneable).getBounds();
            graphics2D.drawString(this.getUnitString(), (float)(((double)this.backgroundImage.getWidth() - rectangle2D.getWidth()) / 2.0), 0.48f * (float)this.backgroundImage.getHeight() + ((TextLayout)cloneable).getAscent() - ((TextLayout)cloneable).getDescent());
        }
        if (!this.vertical) {
            graphics2D.rotate(-1.5707963267948966, ((Point2D)double_).getX(), ((Point2D)double_).getY());
        }
        cloneable = graphics2D.getTransform();
        if (this.isTrackVisible()) {
            graphics2D.drawImage((Image)this.trackImage, 0, 0, null);
        }
        graphics2D.drawImage((Image)this.tickmarksImage, 0, 0, null);
        if (this.isThresholdVisible()) {
            graphics2D.rotate(this.ROTATION_OFFSET + (this.getThreshold() - this.getMinValue()) * this.angleStep, ((Point2D)double_).getX(), (double)this.backgroundImage.getHeight() * 0.7336448598);
            graphics2D.drawImage((Image)this.thresholdImage, 0, 0, null);
            graphics2D.setTransform((AffineTransform)cloneable);
        }
        if (this.isMinMeasuredValueVisible()) {
            graphics2D.rotate(this.ROTATION_OFFSET + (this.getMinMeasuredValue() - this.getMinValue()) * this.angleStep, ((Point2D)double_).getX(), (double)this.backgroundImage.getHeight() * 0.7336448598);
            graphics2D.drawImage((Image)this.minMeasuredImage, 0, 0, null);
            graphics2D.setTransform((AffineTransform)cloneable);
        }
        if (this.isMaxMeasuredValueVisible()) {
            graphics2D.rotate(this.ROTATION_OFFSET + (this.getMaxMeasuredValue() - this.getMinValue()) * this.angleStep, ((Point2D)double_).getX(), (double)this.backgroundImage.getHeight() * 0.7336448598);
            graphics2D.drawImage((Image)this.maxMeasuredImage, 0, 0, null);
            graphics2D.setTransform((AffineTransform)cloneable);
        }
        if (this.isLedVisible()) {
            graphics2D.drawImage((Image)this.getCurrentLedImage(), (int)((double)this.backgroundImage.getWidth() * this.getLedPositionX()), (int)((double)this.backgroundImage.getHeight() * this.getLedPositionY()), null);
        }
        double d = this.ROTATION_OFFSET + (this.getValue() - this.getMinValue()) * this.angleStep;
        graphics2D.rotate(d, ((Point2D)double_).getX(), (double)this.backgroundImage.getHeight() * 0.7336448598 + 2.0);
        graphics2D.drawImage((Image)this.pointerShadowImage, 0, 0, null);
        graphics2D.setTransform((AffineTransform)cloneable);
        graphics2D.rotate(d, ((Point2D)double_).getX(), (double)this.backgroundImage.getHeight() * 0.7336448598);
        graphics2D.drawImage((Image)this.pointerImage, 0, 0, null);
        graphics2D.setTransform((AffineTransform)cloneable);
        graphics2D.drawImage((Image)this.postsImage, 0, 0, null);
        if (!this.vertical) {
            graphics2D.setTransform(affineTransform);
        }
        graphics2D.drawImage((Image)this.foregroundImage, 0, 0, null);
    }

    public int getTickLabelPeriod() {
        return this.tickLabelPeriod;
    }

    public void setTickLabelPeriod(int n) {
        this.tickLabelPeriod = n;
        this.tickmarksImage = this.create_TICKMARKS_Image(this.getWidth(), this.FREE_AREA_ANGLE, 2.356194490192345, this.getMinValue(), this.getMaxValue(), this.angleStep, this.tickLabelPeriod);
        this.repaint();
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean bl) {
        this.vertical = bl;
        this.init(this.getWidth(), this.getWidth());
        this.repaint();
    }

    @Override
    protected final void calcAngleStep() {
        this.angleStep = (1.5707963267948966 - this.FREE_AREA_ANGLE) / (this.getMaxValue() - this.getMinValue());
    }

    @Override
    protected BufferedImage create_POSTS_Image(int n) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double((double)n2 * 0.4579439163208008, (double)n3 * 0.6915887594223022, (double)n2 * 0.08411216735839844, (double)n3 * 0.08411216735839844);
        Point2D.Double double_2 = new Point2D.Double(0.0, double_.getBounds2D().getMinY());
        Point2D.Double double_3 = new Point2D.Double(0.0, double_.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.46f, 1.0f};
        Color[] colorArray = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_3, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_);
        Ellipse2D.Double double_4 = new Ellipse2D.Double((double)n2 * 0.4672897160053253, (double)n3 * 0.7009345889091492, (double)n2 * 0.06542053818702698, (double)n3 * 0.06542056798934937);
        Point2D.Double double_5 = new Point2D.Double(0.0, double_4.getBounds2D().getMinY());
        Point2D.Double double_6 = new Point2D.Double(0.0, double_4.getBounds2D().getMaxY());
        float[] fArray2 = new float[]{0.0f, 1.0f};
        Color[] colorArray2 = new Color[]{new Color(217, 217, 217, 255), new Color(191, 191, 191, 255)};
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_5, double_6, fArray2, colorArray2);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fill(double_4);
        Ellipse2D.Double double_7 = new Ellipse2D.Double((double)n2 * 0.4672897160053253, (double)n3 * 0.7009345889091492, (double)n2 * 0.06542053818702698, (double)n3 * 0.06542056798934937);
        Point2D.Double double_8 = new Point2D.Double(0.4953271028037383 * (double)n2, 0.7242990654205608 * (double)n3);
        float[] fArray3 = new float[]{0.0f, 0.75f, 0.76f, 1.0f};
        Color[] colorArray3 = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 1), new Color(0, 0, 0, 51)};
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_8, (float)(0.03271028037383177 * (double)n2), fArray3, colorArray3);
        graphics2D.setPaint(radialGradientPaint);
        graphics2D.fill(double_7);
        Ellipse2D.Double double_9 = new Ellipse2D.Double((double)n2 * 0.7803738117218018, (double)n3 * 0.44859811663627625, (double)n2 * (double)0.0373832f, (double)n3 * (double)0.0373832f);
        Point2D.Double double_10 = new Point2D.Double(0.0, double_9.getBounds2D().getMinY());
        Point2D.Double double_11 = new Point2D.Double(0.0, double_9.getBounds2D().getMaxY());
        float[] fArray4 = new float[]{0.0f, 0.46f, 1.0f};
        Color[] colorArray4 = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
        LinearGradientPaint linearGradientPaint3 = new LinearGradientPaint(double_10, double_11, fArray4, colorArray4);
        graphics2D.setPaint(linearGradientPaint3);
        graphics2D.fill(double_9);
        Ellipse2D.Double double_12 = new Ellipse2D.Double((double)n2 * 0.7850467562675476, (double)n3 * 0.4532710313796997, (double)n2 * 0.02803736925125122, (double)n3 * 0.02803736925125122);
        Point2D.Double double_13 = new Point2D.Double(0.0, double_12.getBounds2D().getMinY());
        Point2D.Double double_14 = new Point2D.Double(0.0, double_12.getBounds2D().getMaxY());
        float[] fArray5 = new float[]{0.0f, 1.0f};
        Color[] colorArray5 = new Color[]{new Color(217, 217, 217, 255), new Color(191, 191, 191, 255)};
        LinearGradientPaint linearGradientPaint4 = new LinearGradientPaint(double_13, double_14, fArray5, colorArray5);
        graphics2D.setPaint(linearGradientPaint4);
        graphics2D.fill(double_12);
        Ellipse2D.Double double_15 = new Ellipse2D.Double((double)n2 * 0.7850467562675476, (double)n3 * 0.4532710313796997, (double)n2 * 0.02803736925125122, (double)n3 * 0.02803736925125122);
        Point2D.Double double_16 = new Point2D.Double(0.794392523364486 * (double)n2, 0.46261682242990654 * (double)n3);
        float[] fArray6 = new float[]{0.0f, 0.75f, 0.76f, 1.0f};
        Color[] colorArray6 = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 1), new Color(0, 0, 0, 51)};
        RadialGradientPaint radialGradientPaint2 = new RadialGradientPaint(double_16, (float)(0.014018691588785047 * (double)n2), fArray6, colorArray6);
        graphics2D.setPaint(radialGradientPaint2);
        graphics2D.fill(double_15);
        Ellipse2D.Double double_17 = new Ellipse2D.Double((double)n2 * 0.1822429895401001, (double)n3 * 0.44859811663627625, (double)n2 * 0.03738318383693695, (double)n3 * (double)0.0373832f);
        Point2D.Double double_18 = new Point2D.Double(0.0, double_17.getBounds2D().getMinY());
        Point2D.Double double_19 = new Point2D.Double(0.0, double_17.getBounds2D().getMaxY());
        float[] fArray7 = new float[]{0.0f, 0.46f, 1.0f};
        Color[] colorArray7 = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
        LinearGradientPaint linearGradientPaint5 = new LinearGradientPaint(double_18, double_19, fArray7, colorArray7);
        graphics2D.setPaint(linearGradientPaint5);
        graphics2D.fill(double_17);
        Ellipse2D.Double double_20 = new Ellipse2D.Double((double)n2 * 0.18691588938236237, (double)n3 * 0.4532710313796997, (double)n2 * 0.028037384152412415, (double)n3 * 0.02803736925125122);
        Point2D.Double double_21 = new Point2D.Double(0.0, double_20.getBounds2D().getMinY());
        Point2D.Double double_22 = new Point2D.Double(0.0, double_20.getBounds2D().getMaxY());
        float[] fArray8 = new float[]{0.0f, 1.0f};
        Color[] colorArray8 = new Color[]{new Color(217, 217, 217, 255), new Color(191, 191, 191, 255)};
        LinearGradientPaint linearGradientPaint6 = new LinearGradientPaint(double_21, double_22, fArray8, colorArray8);
        graphics2D.setPaint(linearGradientPaint6);
        graphics2D.fill(double_20);
        Ellipse2D.Double double_23 = new Ellipse2D.Double((double)n2 * 0.18691588938236237, (double)n3 * 0.4532710313796997, (double)n2 * 0.028037384152412415, (double)n3 * 0.02803736925125122);
        Point2D.Double double_24 = new Point2D.Double(0.20093457943925233 * (double)n2, 0.46261682242990654 * (double)n3);
        float[] fArray9 = new float[]{0.0f, 0.75f, 0.76f, 1.0f};
        Color[] colorArray9 = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 1), new Color(0, 0, 0, 51)};
        RadialGradientPaint radialGradientPaint3 = new RadialGradientPaint(double_24, (float)(0.014018691588785047 * (double)n2), fArray9, colorArray9);
        graphics2D.setPaint(radialGradientPaint3);
        graphics2D.fill(double_23);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    protected BufferedImage create_TICKMARKS_Image(int n, double d, double d2, double d3, double d4, double d5, int n2) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Font font = new Font("Verdana", 0, (int)(0.04 * (double)n));
        BasicStroke basicStroke = new BasicStroke(1.0f, 1, 2);
        BasicStroke basicStroke2 = new BasicStroke(0.5f, 1, 2);
        BasicStroke basicStroke3 = new BasicStroke(0.3f, 1, 2);
        BasicStroke basicStroke4 = new BasicStroke(0.1f, 1, 2);
        int n5 = (int)(0.01 * (double)n);
        int n6 = (int)(0.0133333333 * (double)n);
        int n7 = (int)(0.02 * (double)n);
        int n8 = (int)(0.03 * (double)n);
        int n9 = (int)(0.04 * (double)n);
        int n10 = this.isVertical() ? (int)(-0.04f * (float)n) : (int)(-0.06f * (float)n);
        float f = (float)n3 * 0.44f;
        Point2D.Double double_ = new Point2D.Double((float)n3 / 2.0f, (double)n4 * 0.73);
        Point2D.Double double_2 = null;
        int n11 = 0;
        int n12 = 0;
        graphics2D.setFont(font);
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = -d2 - d / 2.0;
        double d9 = d4 - d3;
        float f2 = (float)((int)Math.toDegrees(d9 * d5 + d)) / 360.0f;
        int n13 = (int)(20.0f * f2);
        int n14 = (int)(300.0f * f2);
        int n15 = (int)(800.0f * f2);
        double d10 = d8;
        for (double d11 = d3; d11 <= d4; d11 += 1.0) {
            Line2D.Double double_3;
            graphics2D.setStroke(basicStroke2);
            d6 = Math.sin(d10);
            d7 = Math.cos(d10);
            double_2 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n10) * d6, ((Point2D)double_).getY() + (double)(f - (float)n10) * d7);
            Point2D.Double double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n6) * d6, ((Point2D)double_).getY() + (double)(f - (float)n6) * d7);
            Point2D.Double double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)f * d6, ((Point2D)double_).getY() + (double)f * d7);
            graphics2D.setColor(this.getBackgroundColor().LABEL_COLOR);
            if (d9 <= (double)n13 && Double.compare(d10, d8) != 0) {
                graphics2D.setStroke(basicStroke4);
                for (double d12 = d10 + d5; d12 > d10; d12 -= d5 / 10.0) {
                    double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n5) * Math.sin(d12), ((Point2D)double_).getY() + (double)(f - (float)n5) * Math.cos(d12));
                    double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)f * Math.sin(d12), ((Point2D)double_).getY() + (double)f * Math.cos(d12));
                    double_3 = new Line2D.Double(((Point2D)double_4).getX(), ((Point2D)double_4).getY(), ((Point2D)double_5).getX(), ((Point2D)double_5).getY());
                    graphics2D.draw(double_3);
                }
            }
            if (n11 % 5 != 0 && n11 % 10 != 0 && n11 % 100 != 0 && d9 < (double)n14) {
                graphics2D.setStroke(basicStroke3);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n6) * d6, ((Point2D)double_).getY() + (double)(f - (float)n6) * d7);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)f * d6, ((Point2D)double_).getY() + (double)f * d7);
                double_3 = new Line2D.Double(((Point2D)double_4).getX(), ((Point2D)double_4).getY(), ((Point2D)double_5).getX(), ((Point2D)double_5).getY());
                graphics2D.draw(double_3);
            }
            if (n11 % 5 == 0 && n11 % 10 != 0 && n11 % 100 != 0 && d9 < (double)n15) {
                graphics2D.setStroke(basicStroke2);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n7) * d6, ((Point2D)double_).getY() + (double)(f - (float)n7) * d7);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)f * d6, ((Point2D)double_).getY() + (double)f * d7);
                double_3 = new Line2D.Double(((Point2D)double_4).getX(), ((Point2D)double_4).getY(), ((Point2D)double_5).getX(), ((Point2D)double_5).getY());
                graphics2D.draw(double_3);
            }
            if (n11 % 10 == 0 && n11 % 100 != 0 || n11 == 0 && d9 < (double)n15) {
                graphics2D.setStroke(basicStroke);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n8) * d6, ((Point2D)double_).getY() + (double)(f - (float)n8) * d7);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)f * d6, ((Point2D)double_).getY() + (double)f * d7);
                double_3 = new Line2D.Double(((Point2D)double_4).getX(), ((Point2D)double_4).getY(), ((Point2D)double_5).getX(), ((Point2D)double_5).getY());
                graphics2D.draw(double_3);
            }
            if (n11 == 100) {
                graphics2D.setStroke(basicStroke);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n9) * d6, ((Point2D)double_).getY() + (double)(f - (float)n9) * d7);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)f * d6, ((Point2D)double_).getY() + (double)f * d7);
                double_3 = new Line2D.Double(((Point2D)double_4).getX(), ((Point2D)double_4).getY(), ((Point2D)double_5).getX(), ((Point2D)double_5).getY());
                graphics2D.draw(double_3);
                n11 = 0;
                ++n12;
            }
            if (d11 % (double)n2 == 0.0) {
                graphics2D.setColor(this.getBackgroundColor().LABEL_COLOR);
                if (this.isVertical()) {
                    graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, String.valueOf((int)d11), (int)((Point2D)double_2).getX(), (int)((Point2D)double_2).getY(), Math.toDegrees(Math.PI - d10)));
                } else {
                    graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, String.valueOf((int)d11), (int)((Point2D)double_2).getX(), (int)((Point2D)double_2).getY(), Math.toDegrees(Math.PI - d10 + 1.5707963267948966)));
                }
            }
            ++n11;
            d10 -= d5;
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    protected BufferedImage create_THRESHOLD_Image(int n) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.5, (double)n3 * 0.3333333333333333);
        generalPath.lineTo((double)n2 * 0.4866666666666667, (double)n3 * 0.37333333333333335);
        generalPath.lineTo((double)n2 * 0.52, (double)n3 * 0.37333333333333335);
        generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.3333333333333333);
        generalPath.closePath();
        Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
        Color[] colorArray = new Color[]{new Color(82, 0, 0, 255), new Color(252, 29, 0, 255), new Color(252, 29, 0, 255), new Color(82, 0, 0, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        graphics2D.setColor(Color.WHITE);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics2D.draw(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    protected BufferedImage create_MEASURED_VALUE_Image(int n, Color color) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.5, (double)n3 * 0.3037383177570093);
        generalPath.lineTo((double)n2 * 0.514018691588785, (double)n3 * 0.2803738317757009);
        generalPath.lineTo((double)n2 * 0.48598130841121495, (double)n3 * 0.2803738317757009);
        generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.3037383177570093);
        generalPath.closePath();
        graphics2D.setColor(color);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    protected BufferedImage create_TRACK_Image(boolean bl, int n, double d, double d2, double d3, double d4, double d5, double d6, Color color, Color color2, Color color3, double d7) {
        Color[] colorArray;
        float[] fArray;
        float f;
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        Point2D.Double double_ = new Point2D.Double((float)n2 / 2.0f, (double)n3 * 0.73);
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.21333333333333335, (double)n3 * 0.44);
        generalPath.curveTo((double)n2 * 0.37333333333333335, (double)n3 * 0.2866666666666667, (double)n2 * 0.6266666666666667, (double)n3 * 0.2866666666666667, (double)n2 * 0.7866666666666666, (double)n3 * 0.44);
        generalPath.curveTo((double)n2 * 0.7866666666666666, (double)n3 * 0.44, (double)n2 * 0.8066666666666666, (double)n3 * 0.4266666666666667, (double)n2 * 0.8066666666666666, (double)n3 * 0.4266666666666667);
        generalPath.curveTo((double)n2 * 0.6333333333333333, (double)n3 * 0.26, (double)n2 * 0.36666666666666664, (double)n3 * 0.26, (double)n2 * 0.19333333333333333, (double)n3 * 0.4266666666666667);
        generalPath.curveTo((double)n2 * 0.19333333333333333, (double)n3 * 0.4266666666666667, (double)n2 * 0.21333333333333335, (double)n3 * 0.44, (double)n2 * 0.21333333333333335, (double)n3 * 0.44);
        generalPath.closePath();
        float f2 = (float)Math.toDegrees((d4 - d) * d3);
        float f3 = 0.0027777778f * (float)Math.toDegrees((d4 + d6 - d) * d3) - 0.0027777778f * f2;
        Color color4 = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        if (bl) {
            f = (float)((d5 - d4) / d6) * f3;
            fArray = new float[]{0.0f, 1.0E-6f, f, f3, f3 + 0.001f, 1.0f};
            colorArray = new Color[]{color4, color, color2, color3, color4, color4};
        } else {
            fArray = new float[]{0.0f, 1.0E-6f, f3, f3 + 0.001f, 1.0f};
            colorArray = new Color[]{color4, color, color3, color4, color4};
        }
        f = -0.0027777778f * (360.0f - (float)Math.toDegrees(d7)) + 0.0027777778f * f2;
        ConicalGradientPaint conicalGradientPaint = new ConicalGradientPaint(false, double_, f, fArray, colorArray);
        graphics2D.setPaint(conicalGradientPaint);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_POINTER_Image(int n) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.705607476635514);
        generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.6915887850467289, (double)n2 * 0.5093457943925234, (double)n3 * 0.6261682242990654, (double)n2 * 0.5093457943925234, (double)n3 * 0.6121495327102804);
        generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.5981308411214953, (double)n2 * 0.5, (double)n3 * 0.29906542056074764, (double)n2 * 0.5, (double)n3 * 0.29906542056074764);
        generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.29906542056074764, (double)n2 * 0.49065420560747663, (double)n3 * 0.5981308411214953, (double)n2 * 0.49065420560747663, (double)n3 * 0.6121495327102804);
        generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.6308411214953271, (double)n2 * 0.48598130841121495, (double)n3 * 0.6915887850467289, (double)n2 * 0.48130841121495327, (double)n3 * 0.705607476635514);
        generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.7149532710280374, (double)n2 * 0.4672897196261682, (double)n3 * 0.7242990654205608, (double)n2 * 0.4672897196261682, (double)n3 * 0.7336448598130841);
        generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.7523364485981309, (double)n2 * 0.48130841121495327, (double)n3 * 0.7663551401869159, (double)n2 * 0.5, (double)n3 * 0.7663551401869159);
        generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.7663551401869159, (double)n2 * 0.5327102803738317, (double)n3 * 0.7523364485981309, (double)n2 * 0.5327102803738317, (double)n3 * 0.7336448598130841);
        generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.7242990654205608, (double)n2 * 0.5280373831775701, (double)n3 * 0.7149532710280374, (double)n2 * 0.5186915887850467, (double)n3 * 0.705607476635514);
        generalPath.closePath();
        Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
        Color[] colorArray = new Color[]{this.getPointerColor().DARK, this.getPointerColor().LIGHT, this.getPointerColor().LIGHT, this.getPointerColor().DARK};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        Color color = this.getPointerColor().LIGHT;
        graphics2D.setColor(color);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics2D.draw(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_POINTER_SHADOW_Image(int n) {
        if (n <= 0) {
            return null;
        }
        Color color = new Color(0.0f, 0.0f, 0.0f, 0.65f);
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.705607476635514);
        generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.6915887850467289, (double)n2 * 0.5093457943925234, (double)n3 * 0.6261682242990654, (double)n2 * 0.5093457943925234, (double)n3 * 0.6121495327102804);
        generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.5981308411214953, (double)n2 * 0.5, (double)n3 * 0.29906542056074764, (double)n2 * 0.5, (double)n3 * 0.29906542056074764);
        generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.29906542056074764, (double)n2 * 0.49065420560747663, (double)n3 * 0.5981308411214953, (double)n2 * 0.49065420560747663, (double)n3 * 0.6121495327102804);
        generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.6308411214953271, (double)n2 * 0.48598130841121495, (double)n3 * 0.6915887850467289, (double)n2 * 0.48130841121495327, (double)n3 * 0.705607476635514);
        generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.7149532710280374, (double)n2 * 0.4672897196261682, (double)n3 * 0.7242990654205608, (double)n2 * 0.4672897196261682, (double)n3 * 0.7336448598130841);
        generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.7523364485981309, (double)n2 * 0.48130841121495327, (double)n3 * 0.7663551401869159, (double)n2 * 0.5, (double)n3 * 0.7663551401869159);
        generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.7663551401869159, (double)n2 * 0.5327102803738317, (double)n3 * 0.7523364485981309, (double)n2 * 0.5327102803738317, (double)n3 * 0.7336448598130841);
        generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.7242990654205608, (double)n2 * 0.5280373831775701, (double)n3 * 0.7149532710280374, (double)n2 * 0.5186915887850467, (double)n3 * 0.705607476635514);
        generalPath.closePath();
        graphics2D.setColor(color);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public String toString() {
        return "Radial1Vertical";
    }
}

