/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractRadial;
import eu.hansolo.steelseries.tools.ConicalGradientPaint;
import eu.hansolo.steelseries.tools.Shadow;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class Radial1Square
extends AbstractRadial {
    private final double FREE_AREA_ANGLE = Math.toRadians(0.0);
    private double angleStep;
    private final double ROTATION_OFFSET = 4.71238898038469 + this.FREE_AREA_ANGLE / 2.0;
    private int tickLabelPeriod = 20;
    private BufferedImage backgroundImage;
    private BufferedImage trackImage;
    private BufferedImage tickmarksImage;
    private BufferedImage pointerImage;
    private BufferedImage pointerShadowImage;
    private BufferedImage foregroundImage;
    private BufferedImage thresholdImage;
    private BufferedImage minMeasuredImage;
    private BufferedImage maxMeasuredImage;

    public Radial1Square() {
        this.calcAngleStep();
        this.addComponentListener(this);
        this.setSize(this.getPreferredSize());
        this.init(this.getWidth(), this.getWidth());
    }

    @Override
    public final void init(int n, int n2) {
        this.backgroundImage = this.create_BACKGROUND_Image(n);
        this.trackImage = this.getTrackSection() > this.getTrackStart() && this.getTrackSection() < this.getTrackStart() + this.getTrackRange() ? this.create_TRACK_Image(true, (int)(1.66 * (double)n), this.getMinValue(), this.getMaxValue(), this.angleStep, this.getTrackStart(), this.getTrackSection(), this.getTrackRange(), this.getTrackStartColor(), this.getTrackSectionColor(), this.getTrackStopColor(), this.ROTATION_OFFSET) : this.create_TRACK_Image(false, (int)(1.66 * (double)n), this.getMinValue(), this.getMaxValue(), this.angleStep, this.getTrackStart(), this.getTrackSection(), this.getTrackRange(), this.getTrackStartColor(), this.getTrackSectionColor(), this.getTrackStopColor(), this.ROTATION_OFFSET);
        this.tickmarksImage = this.create_TICKMARKS_Image(n);
        this.thresholdImage = this.create_THRESHOLD_Image(n);
        this.minMeasuredImage = this.create_MEASURED_VALUE_Image(n, new Color(0, 23, 252, 255));
        this.maxMeasuredImage = this.create_MEASURED_VALUE_Image(n, new Color(252, 29, 0, 255));
        this.pointerImage = this.create_POINTER_Image(n);
        this.pointerShadowImage = this.create_POINTER_SHADOW_Image(n);
        this.foregroundImage = this.create_FOREGROUND_Image(n);
        this.setCurrentLedImage(this.getLedImageOff());
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Rectangle2D rectangle2D;
        TextLayout textLayout;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Point2D.Double double_ = new Point2D.Double((double)this.pointerImage.getWidth() * 0.8271028037, (double)this.pointerImage.getWidth() * 0.8271028037);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.drawImage((Image)this.backgroundImage, 0, 0, null);
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        if (!this.getTitle().isEmpty()) {
            graphics2D.setColor(this.getBackgroundColor().LABEL_COLOR);
            graphics2D.setFont(new Font("Verdana", 0, (int)(0.04672897196261682 * (double)this.backgroundImage.getWidth())));
            textLayout = new TextLayout(this.getTitle(), graphics2D.getFont(), fontRenderContext);
            rectangle2D = textLayout.getBounds();
            graphics2D.drawString(this.getTitle(), (float)(((double)this.backgroundImage.getWidth() - rectangle2D.getWidth()) / 1.8), 0.6f * (float)this.backgroundImage.getHeight() + textLayout.getAscent() - textLayout.getDescent());
        }
        if (!this.getUnitString().isEmpty()) {
            graphics2D.setColor(this.getBackgroundColor().LABEL_COLOR);
            graphics2D.setFont(new Font("Verdana", 0, (int)(0.04672897196261682 * (double)this.backgroundImage.getWidth())));
            textLayout = new TextLayout(this.getUnitString(), graphics2D.getFont(), fontRenderContext);
            rectangle2D = textLayout.getBounds();
            graphics2D.drawString(this.getUnitString(), (float)(((double)this.backgroundImage.getWidth() - rectangle2D.getWidth()) / 1.8), 0.68f * (float)this.backgroundImage.getHeight() + textLayout.getAscent() - textLayout.getDescent());
        }
        if (this.isTrackVisible()) {
            graphics2D.drawImage((Image)this.trackImage, 0, 0, null);
        }
        graphics2D.drawImage((Image)this.tickmarksImage, 0, 0, null);
        if (this.isThresholdVisible()) {
            graphics2D.rotate(this.ROTATION_OFFSET + (this.getThreshold() - this.getMinValue()) * this.angleStep, ((Point2D)double_).getX(), ((Point2D)double_).getY());
            graphics2D.drawImage((Image)this.thresholdImage, (int)((double)this.backgroundImage.getWidth() * 0.811), (int)((double)this.backgroundImage.getHeight() * 0.22), null);
            graphics2D.setTransform(affineTransform);
        }
        if (this.isMinMeasuredValueVisible()) {
            graphics2D.rotate(this.ROTATION_OFFSET + (this.getMinMeasuredValue() - this.getMinValue()) * this.angleStep, ((Point2D)double_).getX(), ((Point2D)double_).getY());
            graphics2D.drawImage((Image)this.minMeasuredImage, (int)((double)this.backgroundImage.getWidth() * 0.811), (int)((double)this.backgroundImage.getHeight() * 0.19), null);
            graphics2D.setTransform(affineTransform);
        }
        if (this.isMaxMeasuredValueVisible()) {
            graphics2D.rotate(this.ROTATION_OFFSET + (this.getMaxMeasuredValue() - this.getMinValue()) * this.angleStep, ((Point2D)double_).getX(), ((Point2D)double_).getY());
            graphics2D.drawImage((Image)this.maxMeasuredImage, (int)((double)this.backgroundImage.getWidth() * 0.811), (int)((double)this.backgroundImage.getHeight() * 0.19), null);
            graphics2D.setTransform(affineTransform);
        }
        if (this.isLedVisible()) {
            graphics2D.drawImage((Image)this.getCurrentLedImage(), (int)((double)this.backgroundImage.getWidth() * this.getLedPositionX()), (int)((double)this.backgroundImage.getHeight() * this.getLedPositionY()), null);
        }
        double d = (this.getValue() - this.getMinValue()) * this.angleStep;
        graphics2D.rotate(d, ((Point2D)double_).getX(), ((Point2D)double_).getY() + 2.0);
        graphics2D.drawImage((Image)this.pointerShadowImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.rotate(d, ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.drawImage((Image)this.pointerImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.drawImage((Image)this.foregroundImage, 0, 0, null);
    }

    public int getTickLabelPeriod() {
        return this.tickLabelPeriod;
    }

    public void setTickLabelPeriod(int n) {
        this.tickLabelPeriod = n;
        this.tickmarksImage = this.create_TICKMARKS_Image(this.getWidth());
        this.repaint();
    }

    @Override
    protected final void calcAngleStep() {
        this.angleStep = 1.5707963267948966 / (this.getMaxValue() - this.getMinValue());
    }

    @Override
    protected BufferedImage create_BACKGROUND_Image(int n) {
        Paint paint;
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 1.0, (double)n3 * 1.0);
        generalPath.curveTo((double)n2 * 1.0, (double)n3 * 1.0, (double)n2 * 1.0, (double)n3 * 0.06542056074766354, (double)n2 * 1.0, (double)n3 * 0.06542056074766354);
        generalPath.curveTo((double)n2 * 0.40654205607476634, (double)n3 * 0.06542056074766354, (double)n2 * 0.07476635514018691, (double)n3 * 0.35514018691588783, (double)n2 * 0.07476635514018691, (double)n3 * 1.0);
        generalPath.curveTo((double)n2 * 0.07476635514018691, (double)n3 * 1.0, (double)n2 * 1.0, (double)n3 * 1.0, (double)n2 * 1.0, (double)n3 * 1.0);
        generalPath.closePath();
        Color color = new Color(0x848484);
        graphics2D.setColor(color);
        graphics2D.fill(generalPath);
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.setWindingRule(0);
        generalPath2.moveTo((double)n2 * 0.9953271028037384, (double)n3 * 0.9953271028037384);
        generalPath2.curveTo((double)n2 * 0.9953271028037384, (double)n3 * 0.9953271028037384, (double)n2 * 0.9953271028037384, (double)n3 * 0.07009345794392523, (double)n2 * 0.9953271028037384, (double)n3 * 0.07009345794392523);
        generalPath2.curveTo((double)n2 * 0.38317757009345793, (double)n3 * 0.07009345794392523, (double)n2 * 0.08411214953271028, (double)n3 * 0.37850467289719625, (double)n2 * 0.0794392523364486, (double)n3 * 0.9906542056074766);
        generalPath2.curveTo((double)n2 * 0.0794392523364486, (double)n3 * 0.9953271028037384, (double)n2 * 0.0794392523364486, (double)n3 * 0.9906542056074766, (double)n2 * 0.0794392523364486, (double)n3 * 0.9953271028037384);
        generalPath2.curveTo((double)n2 * 0.0794392523364486, (double)n3 * 0.9953271028037384, (double)n2 * 0.9953271028037384, (double)n3 * 0.9953271028037384, (double)n2 * 0.9953271028037384, (double)n3 * 0.9953271028037384);
        generalPath2.closePath();
        Point2D.Double double_ = new Point2D.Double(0.0, generalPath2.getBounds2D().getMinY());
        Point2D.Double double_2 = new Point2D.Double(0.0, generalPath2.getBounds2D().getMaxY());
        Point2D.Double double_3 = new Point2D.Double(generalPath2.getBounds2D().getCenterX(), generalPath2.getBounds2D().getCenterY());
        float f = (float)Math.toDegrees(Math.atan((float)n3 / 8.0f / ((float)n2 / 2.0f)));
        switch (this.getFrameDesign()) {
            case BLACK_METAL: {
                float[] fArray = new float[]{0.0f, 90.0f - 2.0f * f, 90.0f, 90.0f + 3.0f * f, 180.0f, 270.0f - 3.0f * f, 270.0f, 270.0f + 2.0f * f, 1.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(0, 0, 0, 255), new Color(153, 153, 153, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(153, 153, 153, 255), new Color(0, 0, 0, 255), new Color(254, 254, 254, 255)};
                paint = new ConicalGradientPaint(true, double_3, 0.0f, fArray, colorArray);
                break;
            }
            case METAL: {
                float[] fArray = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                paint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
                break;
            }
            case SHINY_METAL: {
                float[] fArray = new float[]{0.0f, 90.0f - 2.0f * f, 90.0f, 90.0f + 3.0f * f, 180.0f, 270.0f - 3.0f * f, 270.0f, 270.0f + 2.0f * f, 1.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(179, 179, 179, 255), new Color(238, 238, 238, 255), new Color(179, 179, 179, 255), new Color(179, 179, 179, 255), new Color(179, 179, 179, 255), new Color(238, 238, 238, 255), new Color(179, 179, 179, 255), new Color(254, 254, 254, 255)};
                paint = new ConicalGradientPaint(true, double_3, 0.0f, fArray, colorArray);
                break;
            }
            default: {
                float[] fArray = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                paint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
            }
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(generalPath2);
        GeneralPath generalPath3 = new GeneralPath();
        generalPath3.setWindingRule(0);
        generalPath3.moveTo((double)n2 * 0.9252336448598131, (double)n3 * 0.9205607476635514);
        generalPath3.curveTo((double)n2 * 0.9252336448598131, (double)n3 * 0.9205607476635514, (double)n2 * 0.9252336448598131, (double)n3 * 0.14953271028037382, (double)n2 * 0.9252336448598131, (double)n3 * 0.14953271028037382);
        generalPath3.curveTo((double)n2 * 0.48598130841121495, (double)n3 * 0.14485981308411214, (double)n2 * 0.1542056074766355, (double)n3 * 0.397196261682243, (double)n2 * 0.1542056074766355, (double)n3 * 0.9205607476635514);
        generalPath3.curveTo((double)n2 * 0.1542056074766355, (double)n3 * 0.9205607476635514, (double)n2 * 0.9252336448598131, (double)n3 * 0.9205607476635514, (double)n2 * 0.9252336448598131, (double)n3 * 0.9205607476635514);
        generalPath3.closePath();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(generalPath3);
        GeneralPath generalPath4 = new GeneralPath();
        generalPath4.setWindingRule(0);
        generalPath4.moveTo((double)n2 * 0.9205607476635514, (double)n3 * 0.9158878504672897);
        generalPath4.curveTo((double)n2 * 0.9205607476635514, (double)n3 * 0.9158878504672897, (double)n2 * 0.9205607476635514, (double)n3 * 0.1542056074766355, (double)n2 * 0.9205607476635514, (double)n3 * 0.1542056074766355);
        generalPath4.curveTo((double)n2 * 0.5093457943925234, (double)n3 * 0.14953271028037382, (double)n2 * 0.1588785046728972, (double)n3 * 0.3878504672897196, (double)n2 * 0.1588785046728972, (double)n3 * 0.9158878504672897);
        generalPath4.curveTo((double)n2 * 0.1588785046728972, (double)n3 * 0.9158878504672897, (double)n2 * 0.9205607476635514, (double)n3 * 0.9158878504672897, (double)n2 * 0.9205607476635514, (double)n3 * 0.9158878504672897);
        generalPath4.closePath();
        Point2D.Double double_4 = new Point2D.Double(0.0, generalPath4.getBounds2D().getMinY());
        Point2D.Double double_5 = new Point2D.Double(0.0, generalPath4.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.39f, 1.0f};
        Color[] colorArray = new Color[]{this.getBackgroundColor().GRADIENT_START_COLOR, this.getBackgroundColor().GRADIENT_FRACTION_COLOR, this.getBackgroundColor().GRADIENT_STOP_COLOR};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_4, double_5, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath4);
        BufferedImage bufferedImage2 = Shadow.INSTANCE.createInnerShadow(generalPath4, linearGradientPaint, 0, 0.65f, Color.BLACK, 20, 315);
        graphics2D.drawImage((Image)bufferedImage2, generalPath4.getBounds().x, generalPath4.getBounds().y, null);
        Ellipse2D.Double double_6 = new Ellipse2D.Double((double)n2 * 0.2210280418395996, (double)n3 * 0.836448609828949, (double)n2 * 0.03738316893577576, (double)n3 * 0.03738313913345337);
        Point2D.Double double_7 = new Point2D.Double(0.0, double_6.getBounds2D().getMinY());
        Point2D.Double double_8 = new Point2D.Double(0.0, double_6.getBounds2D().getMaxY());
        float[] fArray2 = new float[]{0.0f, 0.46f, 1.0f};
        Color[] colorArray2 = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_7, double_8, fArray2, colorArray2);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fill(double_6);
        Ellipse2D.Double double_9 = new Ellipse2D.Double((double)n2 * 0.2257009267807007, (double)n3 * 0.84112149477005, (double)n2 * 0.02803739905357361, (double)n3 * 0.02803736925125122);
        Point2D.Double double_10 = new Point2D.Double(0.0, double_9.getBounds2D().getMinY());
        Point2D.Double double_11 = new Point2D.Double(0.0, double_9.getBounds2D().getMaxY());
        float[] fArray3 = new float[]{0.0f, 1.0f};
        Color[] colorArray3 = new Color[]{new Color(217, 217, 217, 255), new Color(191, 191, 191, 255)};
        LinearGradientPaint linearGradientPaint3 = new LinearGradientPaint(double_10, double_11, fArray3, colorArray3);
        graphics2D.setPaint(linearGradientPaint3);
        graphics2D.fill(double_9);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_TICKMARKS_Image(int n) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        Font font = new Font("Verdana", 0, (int)(0.04 * (double)n));
        BasicStroke basicStroke = new BasicStroke(1.0f, 1, 2);
        BasicStroke basicStroke2 = new BasicStroke(0.5f, 1, 2);
        BasicStroke basicStroke3 = new BasicStroke(0.3f, 1, 2);
        BasicStroke basicStroke4 = new BasicStroke(0.1f, 1, 2);
        int n4 = (int)(0.09 * (double)n);
        int n5 = (int)(0.01 * (double)n);
        int n6 = (int)(0.0133333333 * (double)n);
        int n7 = (int)(0.02 * (double)n);
        int n8 = (int)(0.03 * (double)n);
        int n9 = (int)(0.04 * (double)n);
        float f = (float)n2 * 0.62f;
        Point2D.Double double_ = new Point2D.Double((double)n2 * 0.8271028037, (double)n3 * 0.8271028037);
        Point2D.Double double_2 = null;
        int n10 = 0;
        int n11 = 0;
        graphics2D.setFont(font);
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 1.5707963267948966 / (this.getMaxValue() - this.getMinValue());
        double d4 = this.getMaxValue() - this.getMinValue();
        float f2 = (float)((int)Math.toDegrees(d4 * d3 + this.FREE_AREA_ANGLE)) / 360.0f;
        int n12 = (int)(40.0f * f2);
        int n13 = (int)(300.0f * f2);
        int n14 = (int)(800.0f * f2);
        double d5 = 4.71238898038469;
        for (double d6 = this.getMinValue(); d6 <= this.getMaxValue(); d6 += 1.0) {
            Line2D.Double double_3;
            graphics2D.setStroke(basicStroke2);
            d = Math.sin(d5);
            d2 = Math.cos(d5);
            double_2 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n4) * d, ((Point2D)double_).getY() + (double)(f - (float)n4) * d2);
            Point2D.Double double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n6) * d, ((Point2D)double_).getY() + (double)(f - (float)n6) * d2);
            Point2D.Double double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)f * d, ((Point2D)double_).getY() + (double)f * d2);
            graphics2D.setColor(this.getBackgroundColor().LABEL_COLOR);
            if (d4 <= (double)n12 && Double.compare(d5, 4.71238898038469) != 0) {
                graphics2D.setStroke(basicStroke4);
                for (double d7 = d5 + d3; d7 > d5; d7 -= d3 / 10.0) {
                    double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n5) * Math.sin(d7), ((Point2D)double_).getY() + (double)(f - (float)n5) * Math.cos(d7));
                    double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)f * Math.sin(d7), ((Point2D)double_).getY() + (double)f * Math.cos(d7));
                    double_3 = new Line2D.Double(((Point2D)double_4).getX(), ((Point2D)double_4).getY(), ((Point2D)double_5).getX(), ((Point2D)double_5).getY());
                    graphics2D.draw(double_3);
                }
            }
            if (n10 % 5 != 0 && n10 % 10 != 0 && n10 % 100 != 0 && d4 < (double)n13) {
                graphics2D.setStroke(basicStroke3);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n6) * d, ((Point2D)double_).getY() + (double)(f - (float)n6) * d2);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)f * d, ((Point2D)double_).getY() + (double)f * d2);
                double_3 = new Line2D.Double(((Point2D)double_4).getX(), ((Point2D)double_4).getY(), ((Point2D)double_5).getX(), ((Point2D)double_5).getY());
                graphics2D.draw(double_3);
            }
            if (n10 % 5 == 0 && n10 % 10 != 0 && n10 % 100 != 0 && d4 < (double)n14) {
                graphics2D.setStroke(basicStroke2);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n7) * d, ((Point2D)double_).getY() + (double)(f - (float)n7) * d2);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)f * d, ((Point2D)double_).getY() + (double)f * d2);
                double_3 = new Line2D.Double(((Point2D)double_4).getX(), ((Point2D)double_4).getY(), ((Point2D)double_5).getX(), ((Point2D)double_5).getY());
                graphics2D.draw(double_3);
            }
            if (n10 % 10 == 0 && n10 % 100 != 0 || n10 == 0 && d4 < (double)n14) {
                graphics2D.setStroke(basicStroke);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n8) * d, ((Point2D)double_).getY() + (double)(f - (float)n8) * d2);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)f * d, ((Point2D)double_).getY() + (double)f * d2);
                double_3 = new Line2D.Double(((Point2D)double_4).getX(), ((Point2D)double_4).getY(), ((Point2D)double_5).getX(), ((Point2D)double_5).getY());
                graphics2D.draw(double_3);
            }
            if (n10 == 100) {
                graphics2D.setStroke(basicStroke);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n9) * d, ((Point2D)double_).getY() + (double)(f - (float)n9) * d2);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)f * d, ((Point2D)double_).getY() + (double)f * d2);
                double_3 = new Line2D.Double(((Point2D)double_4).getX(), ((Point2D)double_4).getY(), ((Point2D)double_5).getX(), ((Point2D)double_5).getY());
                graphics2D.draw(double_3);
                n10 = 0;
                ++n11;
            }
            if (d6 % (double)this.getTickLabelPeriod() == 0.0) {
                graphics2D.setColor(this.getBackgroundColor().LABEL_COLOR);
                graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, String.valueOf((int)d6), (int)((Point2D)double_2).getX(), (int)((Point2D)double_2).getY(), Math.toDegrees(Math.PI - d5)));
            }
            ++n10;
            d5 -= d3;
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_POINTER_Image(int n) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.7990654205607477, (double)n3 * 0.8130841121495327);
        generalPath.curveTo((double)n2 * 0.7850467289719626, (double)n3 * 0.8130841121495327, (double)n2 * 0.7429906542056075, (double)n3 * 0.8130841121495327, (double)n2 * 0.7289719626168224, (double)n3 * 0.8130841121495327);
        generalPath.curveTo((double)n2 * 0.7102803738317757, (double)n3 * 0.822429906542056, (double)n2 * 0.2102803738317757, (double)n3 * 0.8271028037383178, (double)n2 * 0.2102803738317757, (double)n3 * 0.8271028037383178);
        generalPath.curveTo((double)n2 * 0.2102803738317757, (double)n3 * 0.8271028037383178, (double)n2 * 0.7149532710280374, (double)n3 * 0.8364485981308412, (double)n2 * 0.7242990654205608, (double)n3 * 0.8411214953271028);
        generalPath.curveTo((double)n2 * 0.7429906542056075, (double)n3 * 0.8411214953271028, (double)n2 * 0.7850467289719626, (double)n3 * 0.8411214953271028, (double)n2 * 0.7990654205607477, (double)n3 * 0.8457943925233645);
        generalPath.curveTo((double)n2 * 0.8084112149532711, (double)n3 * 0.8551401869158879, (double)n2 * 0.8177570093457944, (double)n3 * 0.8598130841121495, (double)n2 * 0.8271028037383178, (double)n3 * 0.8598130841121495);
        generalPath.curveTo((double)n2 * 0.8457943925233645, (double)n3 * 0.8598130841121495, (double)n2 * 0.8598130841121495, (double)n3 * 0.8457943925233645, (double)n2 * 0.8598130841121495, (double)n3 * 0.8271028037383178);
        generalPath.curveTo((double)n2 * 0.8598130841121495, (double)n3 * 0.8084112149532711, (double)n2 * 0.8457943925233645, (double)n3 * 0.794392523364486, (double)n2 * 0.8271028037383178, (double)n3 * 0.794392523364486);
        generalPath.curveTo((double)n2 * 0.8177570093457944, (double)n3 * 0.794392523364486, (double)n2 * 0.8084112149532711, (double)n3 * 0.7990654205607477, (double)n2 * 0.7990654205607477, (double)n3 * 0.8130841121495327);
        generalPath.closePath();
        Point2D.Double double_ = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
        Point2D.Double double_2 = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
        float[] fArray = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
        Color[] colorArray = new Color[]{this.getPointerColor().DARK, this.getPointerColor().LIGHT, this.getPointerColor().LIGHT, this.getPointerColor().DARK};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        Color color = this.getPointerColor().LIGHT;
        graphics2D.setColor(color);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics2D.draw(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_POINTER_SHADOW_Image(int n) {
        if (n <= 0) {
            return null;
        }
        Color color = new Color(0.0f, 0.0f, 0.0f, 0.65f);
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.7990654205607477, (double)n3 * 0.8130841121495327);
        generalPath.curveTo((double)n2 * 0.7850467289719626, (double)n3 * 0.8130841121495327, (double)n2 * 0.7429906542056075, (double)n3 * 0.8130841121495327, (double)n2 * 0.7289719626168224, (double)n3 * 0.8130841121495327);
        generalPath.curveTo((double)n2 * 0.7102803738317757, (double)n3 * 0.822429906542056, (double)n2 * 0.2102803738317757, (double)n3 * 0.8271028037383178, (double)n2 * 0.2102803738317757, (double)n3 * 0.8271028037383178);
        generalPath.curveTo((double)n2 * 0.2102803738317757, (double)n3 * 0.8271028037383178, (double)n2 * 0.7149532710280374, (double)n3 * 0.8364485981308412, (double)n2 * 0.7242990654205608, (double)n3 * 0.8411214953271028);
        generalPath.curveTo((double)n2 * 0.7429906542056075, (double)n3 * 0.8411214953271028, (double)n2 * 0.7850467289719626, (double)n3 * 0.8411214953271028, (double)n2 * 0.7990654205607477, (double)n3 * 0.8457943925233645);
        generalPath.curveTo((double)n2 * 0.8084112149532711, (double)n3 * 0.8551401869158879, (double)n2 * 0.8177570093457944, (double)n3 * 0.8598130841121495, (double)n2 * 0.8271028037383178, (double)n3 * 0.8598130841121495);
        generalPath.curveTo((double)n2 * 0.8457943925233645, (double)n3 * 0.8598130841121495, (double)n2 * 0.8598130841121495, (double)n3 * 0.8457943925233645, (double)n2 * 0.8598130841121495, (double)n3 * 0.8271028037383178);
        generalPath.curveTo((double)n2 * 0.8598130841121495, (double)n3 * 0.8084112149532711, (double)n2 * 0.8457943925233645, (double)n3 * 0.794392523364486, (double)n2 * 0.8271028037383178, (double)n3 * 0.794392523364486);
        generalPath.curveTo((double)n2 * 0.8177570093457944, (double)n3 * 0.794392523364486, (double)n2 * 0.8084112149532711, (double)n3 * 0.7990654205607477, (double)n2 * 0.7990654205607477, (double)n3 * 0.8130841121495327);
        generalPath.closePath();
        graphics2D.setColor(color);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    protected BufferedImage create_FOREGROUND_Image(int n) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double((double)n2 * 0.7850467562675476, (double)n3 * 0.7850467562675476, (double)n2 * 0.08411210775375366, (double)n3 * 0.08411210775375366);
        Point2D.Double double_2 = new Point2D.Double(0.0, double_.getBounds2D().getMinY());
        Point2D.Double double_3 = new Point2D.Double(0.0, double_.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.46f, 1.0f};
        Color[] colorArray = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_3, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_);
        Ellipse2D.Double double_4 = new Ellipse2D.Double((double)n2 * 0.7943925261497498, (double)n3 * 0.7943925261497498, (double)n2 * 0.06542056798934937, (double)n3 * 0.06542056798934937);
        Point2D.Double double_5 = new Point2D.Double(0.0, double_4.getBounds2D().getMinY());
        Point2D.Double double_6 = new Point2D.Double(0.0, double_4.getBounds2D().getMaxY());
        float[] fArray2 = new float[]{0.0f, 1.0f};
        Color[] colorArray2 = new Color[]{new Color(217, 217, 217, 255), new Color(191, 191, 191, 255)};
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_5, double_6, fArray2, colorArray2);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fill(double_4);
        Ellipse2D.Double double_7 = new Ellipse2D.Double((double)n2 * 0.7943925261497498, (double)n3 * 0.7943925261497498, (double)n2 * 0.06542056798934937, (double)n3 * 0.06542056798934937);
        Point2D.Double double_8 = new Point2D.Double(0.822429906542056 * (double)n2, 0.8177570093457944 * (double)n3);
        float[] fArray3 = new float[]{0.0f, 0.75f, 0.76f, 1.0f};
        Color[] colorArray3 = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 1), new Color(0, 0, 0, 51)};
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_8, (float)(0.03271028037383177 * (double)n2), fArray3, colorArray3);
        graphics2D.setPaint(radialGradientPaint);
        graphics2D.fill(double_7);
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.9205607476635514, (double)n3 * 0.46261682242990654);
        generalPath.curveTo((double)n2 * 0.9205607476635514, (double)n3 * 0.4252336448598131, (double)n2 * 0.9205607476635514, (double)n3 * 0.1542056074766355, (double)n2 * 0.9205607476635514, (double)n3 * 0.1542056074766355);
        generalPath.curveTo((double)n2 * 0.8177570093457944, (double)n3 * 0.1542056074766355, (double)n2 * 0.6261682242990654, (double)n3 * 0.16355140186915887, (double)n2 * 0.45794392523364486, (double)n3 * 0.2803738317757009);
        generalPath.curveTo((double)n2 * 0.3364485981308411, (double)n3 * 0.3691588785046729, (double)n2 * 0.32710280373831774, (double)n3 * 0.397196261682243, (double)n2 * 0.29906542056074764, (double)n3 * 0.4392523364485981);
        generalPath.curveTo((double)n2 * 0.26635514018691586, (double)n3 * 0.4719626168224299, (double)n2 * 0.22897196261682243, (double)n3 * 0.5373831775700935, (double)n2 * 0.2102803738317757, (double)n3 * 0.6121495327102804);
        generalPath.curveTo((double)n2 * 0.5420560747663551, (double)n3 * 0.4392523364485981, (double)n2 * 0.7990654205607477, (double)n3 * 0.4532710280373832, (double)n2 * 0.9205607476635514, (double)n3 * 0.46261682242990654);
        generalPath.closePath();
        Point2D.Double double_9 = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        Point2D.Double double_10 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
        float[] fArray4 = new float[]{0.0f, 1.0f};
        Color[] colorArray4 = new Color[]{new Color(255, 255, 255, 63), new Color(255, 255, 255, 12)};
        LinearGradientPaint linearGradientPaint3 = new LinearGradientPaint(double_9, double_10, fArray4, colorArray4);
        graphics2D.setPaint(linearGradientPaint3);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public String toString() {
        return "Radial1Square";
    }
}

