/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractRadial;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class Radial1
extends AbstractRadial {
    private final double FREE_AREA_ANGLE = Math.toRadians(0.0);
    private double angleStep;
    private static final double TICKMARK_OFFSET = 1.5707963267948966;
    private final double ROTATION_OFFSET = 4.71238898038469 + this.FREE_AREA_ANGLE / 2.0;
    private int tickLabelPeriod = 20;
    private BufferedImage backgroundImage;
    private BufferedImage postsImage;
    private BufferedImage trackImage;
    private BufferedImage tickmarksImage;
    private BufferedImage pointerImage;
    private BufferedImage pointerShadowImage;
    private BufferedImage foregroundImage;
    private BufferedImage thresholdImage;
    private BufferedImage minMeasuredImage;
    private BufferedImage maxMeasuredImage;

    public Radial1() {
        this.calcAngleStep();
        this.addComponentListener(this);
        this.setSize(this.getPreferredSize());
        this.init(this.getWidth(), this.getWidth());
    }

    @Override
    public final void init(int n, int n2) {
        this.backgroundImage = this.create_BACKGROUND_Image(n, this.getTitle(), this.getUnitString());
        this.postsImage = this.create_POSTS_Image(n);
        this.trackImage = this.getTrackSection() > this.getTrackStart() && this.getTrackSection() < this.getTrackStart() + this.getTrackRange() ? this.create_TRACK_Image(true, n, this.getMinValue(), this.getMaxValue(), this.angleStep, this.getTrackStart(), this.getTrackSection(), this.getTrackRange(), this.getTrackStartColor(), this.getTrackSectionColor(), this.getTrackStopColor(), this.ROTATION_OFFSET) : this.create_TRACK_Image(false, n, this.getMinValue(), this.getMaxValue(), this.angleStep, this.getTrackStart(), this.getTrackSection(), this.getTrackRange(), this.getTrackStartColor(), this.getTrackSectionColor(), this.getTrackStopColor(), this.ROTATION_OFFSET);
        this.tickmarksImage = this.create_TICKMARKS_Image(n, this.FREE_AREA_ANGLE, 1.5707963267948966, this.getMinValue(), this.getMaxValue(), this.angleStep, this.tickLabelPeriod);
        this.thresholdImage = this.create_THRESHOLD_Image(n);
        this.minMeasuredImage = this.create_MEASURED_VALUE_Image(n, new Color(0, 23, 252, 255));
        this.maxMeasuredImage = this.create_MEASURED_VALUE_Image(n, new Color(252, 29, 0, 255));
        this.pointerImage = this.create_POINTER_Image(n);
        this.pointerShadowImage = this.create_POINTER_SHADOW_Image(n);
        this.foregroundImage = this.create_FOREGROUND_Image(n);
        this.setCurrentLedImage(this.getLedImageOff());
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Point2D.Double double_ = new Point2D.Double((double)this.pointerImage.getWidth() / 2.0, (double)this.pointerImage.getWidth() / 2.0);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.drawImage((Image)this.backgroundImage, 0, 0, null);
        graphics2D.drawImage((Image)this.postsImage, 0, 0, null);
        if (this.isTrackVisible()) {
            graphics2D.drawImage((Image)this.trackImage, 0, 0, null);
        }
        graphics2D.drawImage((Image)this.tickmarksImage, 0, 0, null);
        if (this.isThresholdVisible()) {
            graphics2D.rotate(this.ROTATION_OFFSET + (this.getThreshold() - this.getMinValue()) * this.angleStep, ((Point2D)double_).getX(), ((Point2D)double_).getY());
            graphics2D.drawImage((Image)this.thresholdImage, (int)((double)this.backgroundImage.getWidth() * 0.480369999), (int)((double)this.backgroundImage.getHeight() * 0.13), null);
            graphics2D.setTransform(affineTransform);
        }
        if (this.isMinMeasuredValueVisible()) {
            graphics2D.rotate(this.ROTATION_OFFSET + (this.getMinMeasuredValue() - this.getMinValue()) * this.angleStep, ((Point2D)double_).getX(), ((Point2D)double_).getY());
            graphics2D.drawImage((Image)this.minMeasuredImage, (int)((double)this.backgroundImage.getWidth() * 0.4865), (int)((double)this.backgroundImage.getHeight() * 0.105), null);
            graphics2D.setTransform(affineTransform);
        }
        if (this.isMaxMeasuredValueVisible()) {
            graphics2D.rotate(this.ROTATION_OFFSET + (this.getMaxMeasuredValue() - this.getMinValue()) * this.angleStep, ((Point2D)double_).getX(), ((Point2D)double_).getY());
            graphics2D.drawImage((Image)this.maxMeasuredImage, (int)((double)this.backgroundImage.getWidth() * 0.4865), (int)((double)this.backgroundImage.getHeight() * 0.105), null);
            graphics2D.setTransform(affineTransform);
        }
        if (this.isLedVisible()) {
            graphics2D.drawImage((Image)this.getCurrentLedImage(), (int)((double)this.backgroundImage.getWidth() * this.getLedPositionX()), (int)((double)this.backgroundImage.getHeight() * this.getLedPositionY()), null);
        }
        double d = this.ROTATION_OFFSET + (this.getValue() - this.getMinValue()) * this.angleStep;
        graphics2D.rotate(d + Math.cos(Math.toRadians(d - this.ROTATION_OFFSET - 91.5)), ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.drawImage((Image)this.pointerShadowImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.rotate(d, ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.drawImage((Image)this.pointerImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.drawImage((Image)this.foregroundImage, 0, 0, null);
    }

    public int getTickLabelPeriod() {
        return this.tickLabelPeriod;
    }

    public void setTickLabelPeriod(int n) {
        this.tickLabelPeriod = n;
        this.tickmarksImage = this.create_TICKMARKS_Image(this.getWidth(), this.FREE_AREA_ANGLE, 1.5707963267948966, this.getMinValue(), this.getMaxValue(), this.angleStep, this.tickLabelPeriod);
        this.repaint();
    }

    @Override
    protected final void calcAngleStep() {
        this.angleStep = (1.5707963267948966 - this.FREE_AREA_ANGLE) / (this.getMaxValue() - this.getMinValue());
    }

    @Override
    protected BufferedImage create_POSTS_Image(int n) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        Ellipse2D.Double double_ = new Ellipse2D.Double((double)n2 * 0.5233644843101501, (double)n3 * 0.13084112107753754, (double)n2 * (double)0.0373832f, (double)n3 * 0.03738318383693695);
        Point2D.Double double_2 = new Point2D.Double(0.0, double_.getBounds2D().getMinY());
        Point2D.Double double_3 = new Point2D.Double(0.0, double_.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.46f, 1.0f};
        Color[] colorArray = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_3, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_);
        Ellipse2D.Double double_4 = new Ellipse2D.Double((double)n2 * 0.5280373692512512, (double)n3 * 0.1355140209197998, (double)n2 * 0.02803736925125122, (double)n3 * 0.028037384152412415);
        Point2D.Double double_5 = new Point2D.Double(0.0, double_4.getBounds2D().getMinY());
        Point2D.Double double_6 = new Point2D.Double(0.0, double_4.getBounds2D().getMaxY());
        float[] fArray2 = new float[]{0.0f, 1.0f};
        Color[] colorArray2 = new Color[]{new Color(217, 217, 217, 255), new Color(191, 191, 191, 255)};
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_5, double_6, fArray2, colorArray2);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fill(double_4);
        Ellipse2D.Double double_7 = new Ellipse2D.Double((double)n2 * 0.5280373692512512, (double)n3 * 0.1355140209197998, (double)n2 * 0.02803736925125122, (double)n3 * 0.028037384152412415);
        Point2D.Double double_8 = new Point2D.Double(0.5420560747663551 * (double)n2, 0.14485981308411214 * (double)n3);
        float[] fArray3 = new float[]{0.0f, 0.75f, 0.76f, 1.0f};
        Color[] colorArray3 = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 1), new Color(0, 0, 0, 51)};
        RadialGradientPaint radialGradientPaint = new RadialGradientPaint(double_8, (float)(0.014018691588785047 * (double)n2), fArray3, colorArray3);
        graphics2D.setPaint(radialGradientPaint);
        graphics2D.fill(double_7);
        Ellipse2D.Double double_9 = new Ellipse2D.Double((double)n2 * 0.13084112107753754, (double)n3 * 0.514018714427948, (double)n2 * 0.03738318383693695, (double)n3 * 0.03738313913345337);
        Point2D.Double double_10 = new Point2D.Double(0.0, double_9.getBounds2D().getMinY());
        Point2D.Double double_11 = new Point2D.Double(0.0, double_9.getBounds2D().getMaxY());
        float[] fArray4 = new float[]{0.0f, 0.46f, 1.0f};
        Color[] colorArray4 = new Color[]{new Color(180, 180, 180, 255), new Color(63, 63, 63, 255), new Color(40, 40, 40, 255)};
        LinearGradientPaint linearGradientPaint3 = new LinearGradientPaint(double_10, double_11, fArray4, colorArray4);
        graphics2D.setPaint(linearGradientPaint3);
        graphics2D.fill(double_9);
        Ellipse2D.Double double_12 = new Ellipse2D.Double((double)n2 * 0.1355140209197998, (double)n3 * 0.5186915993690491, (double)n2 * 0.028037384152412415, (double)n3 * 0.02803736925125122);
        Point2D.Double double_13 = new Point2D.Double(0.0, double_12.getBounds2D().getMinY());
        Point2D.Double double_14 = new Point2D.Double(0.0, double_12.getBounds2D().getMaxY());
        float[] fArray5 = new float[]{0.0f, 1.0f};
        Color[] colorArray5 = new Color[]{new Color(217, 217, 217, 255), new Color(191, 191, 191, 255)};
        LinearGradientPaint linearGradientPaint4 = new LinearGradientPaint(double_13, double_14, fArray5, colorArray5);
        graphics2D.setPaint(linearGradientPaint4);
        graphics2D.fill(double_12);
        Ellipse2D.Double double_15 = new Ellipse2D.Double((double)n2 * 0.1355140209197998, (double)n3 * 0.5186915993690491, (double)n2 * 0.028037384152412415, (double)n3 * 0.02803736925125122);
        Point2D.Double double_16 = new Point2D.Double(0.14953271028037382 * (double)n2, 0.5280373831775701 * (double)n3);
        float[] fArray6 = new float[]{0.0f, 0.75f, 0.76f, 1.0f};
        Color[] colorArray6 = new Color[]{new Color(0, 0, 0, 0), new Color(0, 0, 0, 0), new Color(0, 0, 0, 1), new Color(0, 0, 0, 51)};
        RadialGradientPaint radialGradientPaint2 = new RadialGradientPaint(double_16, (float)(0.014018691588785047 * (double)n2), fArray6, colorArray6);
        graphics2D.setPaint(radialGradientPaint2);
        graphics2D.fill(double_15);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_POINTER_Image(int n) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
        generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.45794392523364486, (double)n2 * 0.5093457943925234, (double)n3 * 0.4158878504672897, (double)n2 * 0.5093457943925234, (double)n3 * 0.40186915887850466);
        generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.38317757009345793, (double)n2 * 0.5, (double)n3 * 0.1308411214953271, (double)n2 * 0.5, (double)n3 * 0.1308411214953271);
        generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.1308411214953271, (double)n2 * 0.49065420560747663, (double)n3 * 0.38317757009345793, (double)n2 * 0.49065420560747663, (double)n3 * 0.397196261682243);
        generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.4158878504672897, (double)n2 * 0.48598130841121495, (double)n3 * 0.45794392523364486, (double)n2 * 0.48130841121495327, (double)n3 * 0.4719626168224299);
        generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.48130841121495327, (double)n2 * 0.4672897196261682, (double)n3 * 0.49065420560747663, (double)n2 * 0.4672897196261682, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.5186915887850467, (double)n2 * 0.48130841121495327, (double)n3 * 0.5327102803738317, (double)n2 * 0.5, (double)n3 * 0.5327102803738317);
        generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5327102803738317, (double)n2 * 0.5327102803738317, (double)n3 * 0.5186915887850467, (double)n2 * 0.5327102803738317, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.49065420560747663, (double)n2 * 0.5280373831775701, (double)n3 * 0.48130841121495327, (double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
        generalPath.closePath();
        Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
        Color[] colorArray = new Color[]{this.getPointerColor().DARK, this.getPointerColor().LIGHT, this.getPointerColor().LIGHT, this.getPointerColor().DARK};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        Color color = this.getPointerColor().LIGHT;
        graphics2D.setColor(color);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics2D.draw(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_POINTER_SHADOW_Image(int n) {
        if (n <= 0) {
            return null;
        }
        Color color = new Color(0.0f, 0.0f, 0.0f, 0.65f);
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
        generalPath.curveTo((double)n2 * 0.514018691588785, (double)n3 * 0.45794392523364486, (double)n2 * 0.5093457943925234, (double)n3 * 0.4158878504672897, (double)n2 * 0.5093457943925234, (double)n3 * 0.40186915887850466);
        generalPath.curveTo((double)n2 * 0.5046728971962616, (double)n3 * 0.38317757009345793, (double)n2 * 0.5, (double)n3 * 0.1308411214953271, (double)n2 * 0.5, (double)n3 * 0.1308411214953271);
        generalPath.curveTo((double)n2 * 0.5, (double)n3 * 0.1308411214953271, (double)n2 * 0.49065420560747663, (double)n3 * 0.38317757009345793, (double)n2 * 0.49065420560747663, (double)n3 * 0.397196261682243);
        generalPath.curveTo((double)n2 * 0.49065420560747663, (double)n3 * 0.4158878504672897, (double)n2 * 0.48598130841121495, (double)n3 * 0.45794392523364486, (double)n2 * 0.48130841121495327, (double)n3 * 0.4719626168224299);
        generalPath.curveTo((double)n2 * 0.4719626168224299, (double)n3 * 0.48130841121495327, (double)n2 * 0.4672897196261682, (double)n3 * 0.49065420560747663, (double)n2 * 0.4672897196261682, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.4672897196261682, (double)n3 * 0.5186915887850467, (double)n2 * 0.48130841121495327, (double)n3 * 0.5327102803738317, (double)n2 * 0.5, (double)n3 * 0.5327102803738317);
        generalPath.curveTo((double)n2 * 0.5186915887850467, (double)n3 * 0.5327102803738317, (double)n2 * 0.5327102803738317, (double)n3 * 0.5186915887850467, (double)n2 * 0.5327102803738317, (double)n3 * 0.5);
        generalPath.curveTo((double)n2 * 0.5327102803738317, (double)n3 * 0.49065420560747663, (double)n2 * 0.5280373831775701, (double)n3 * 0.48130841121495327, (double)n2 * 0.5186915887850467, (double)n3 * 0.4719626168224299);
        generalPath.closePath();
        graphics2D.setColor(color);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public String toString() {
        return "Radial1";
    }
}

