/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractLinear;
import eu.hansolo.steelseries.tools.ColorDef;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class Linear
extends AbstractLinear {
    private int tickLabelPeriod = 10;
    private ColorDef valueColor = ColorDef.RED;
    private boolean titleVisible = true;
    private boolean unitStringVisible = true;
    private boolean tickmarksVisible = true;
    private BufferedImage backgroundImage;
    private BufferedImage trackImage;
    private BufferedImage titleImage;
    private BufferedImage tickmarksImage;
    private BufferedImage thresholdImage;
    private BufferedImage minMeasuredImage;
    private BufferedImage maxMeasuredImage;
    private BufferedImage foregroundImage;

    public Linear() {
        this.addComponentListener(this);
        this.setValue(0.0);
        this.setSize(this.getPreferredSize());
        this.init((int)this.getPreferredSize().getWidth(), (int)this.getPreferredSize().getHeight());
    }

    @Override
    public final void init(int n, int n2) {
        this.backgroundImage = this.create_BACKGROUND_Image(n, n2);
        this.trackImage = this.getTrackSection() > this.getTrackStart() && this.getTrackSection() < this.getTrackStart() + this.getTrackRange() ? this.create_TRACK_Image(true, n, n2, this.getMinValue(), this.getMaxValue(), this.getTrackStart(), this.getTrackSection(), this.getTrackRange(), this.getTrackStartColor(), this.getTrackSectionColor(), this.getTrackStopColor()) : this.create_TRACK_Image(false, n, n2, this.getMinValue(), this.getMaxValue(), this.getTrackStart(), this.getTrackSection(), this.getTrackRange(), this.getTrackStartColor(), this.getTrackSectionColor(), this.getTrackStopColor());
        this.titleImage = this.create_TITLE_Image(n, n2, this.unitStringVisible);
        this.tickmarksImage = this.create_TICKMARKS_Image(n, n2, this.getMinValue(), this.getMaxValue(), this.tickLabelPeriod);
        this.thresholdImage = this.create_THRESHOLD_Image(n, n2);
        this.minMeasuredImage = this.create_MEASURED_VALUE_Image(n, n2, new Color(0, 23, 252, 255));
        this.maxMeasuredImage = this.create_MEASURED_VALUE_Image(n, n2, new Color(252, 29, 0, 255));
        this.foregroundImage = this.create_FOREGROUND_Image(n, n2);
        this.setCurrentLedImage(this.getLedImageOff());
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        double d;
        AffineTransform affineTransform;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.drawImage((Image)this.backgroundImage, 0, 0, null);
        if (this.isTrackVisible()) {
            graphics2D.drawImage((Image)this.trackImage, 0, 0, null);
        }
        if (this.isTitleVisible()) {
            graphics2D.drawImage((Image)this.titleImage, 0, 0, null);
        }
        if (this.isTickmarksVisible()) {
            graphics2D.drawImage((Image)this.tickmarksImage, 0, 0, null);
        }
        if (this.isThresholdVisible()) {
            affineTransform = graphics2D.getTransform();
            if (this.getWidth() < this.getHeight()) {
                d = (double)this.getHeight() * 0.8567961165048543 - (double)this.getHeight() * 0.7281553398 * (this.getThreshold() / (this.getMaxValue() - this.getMinValue()));
                graphics2D.translate((double)this.getWidth() * 0.4357142857142857 - (double)this.thresholdImage.getWidth() - 2.0, d - (double)this.thresholdImage.getHeight() / 2.0);
            } else {
                d = ((double)this.getWidth() * 0.8567961165048543 - (double)this.getWidth() * 0.12864077669902912) * this.getThreshold() / (this.getMaxValue() - this.getMinValue());
                graphics2D.translate((double)this.getWidth() * 0.14285714285714285 - (double)this.thresholdImage.getWidth() / 2.0 + d, (double)this.getHeight() * 0.5714285714 + 2.0);
            }
            graphics2D.drawImage((Image)this.thresholdImage, 0, 0, null);
            graphics2D.setTransform(affineTransform);
        }
        if (this.isMinMeasuredValueVisible()) {
            affineTransform = graphics2D.getTransform();
            if (this.getWidth() < this.getHeight()) {
                d = (double)this.getHeight() * 0.8567961165048543 - (double)this.getHeight() * 0.7281553398 * (this.getMinMeasuredValue() / (this.getMaxValue() - this.getMinValue()));
                graphics2D.translate((double)this.getWidth() * 0.37 - (double)this.minMeasuredImage.getWidth() - 2.0, d - (double)this.minMeasuredImage.getHeight() / 2.0);
            } else {
                d = ((double)this.getWidth() * 0.8567961165048543 - (double)this.getWidth() * 0.12864077669902912) * this.getMinMeasuredValue() / (this.getMaxValue() - this.getMinValue());
                graphics2D.translate((double)this.getWidth() * 0.14285714285714285 - (double)this.minMeasuredImage.getWidth() / 2.0 + d, (double)this.getHeight() * 0.63 + 2.0);
            }
            graphics2D.drawImage((Image)this.minMeasuredImage, 0, 0, null);
            graphics2D.setTransform(affineTransform);
        }
        if (this.isMaxMeasuredValueVisible()) {
            affineTransform = graphics2D.getTransform();
            if (this.getWidth() < this.getHeight()) {
                d = (double)this.getHeight() * 0.8567961165048543 - (double)this.getHeight() * 0.7281553398 * (this.getMaxMeasuredValue() / (this.getMaxValue() - this.getMinValue()));
                graphics2D.translate((double)this.getWidth() * 0.37 - (double)this.maxMeasuredImage.getWidth() - 2.0, d - (double)this.maxMeasuredImage.getHeight() / 2.0);
            } else {
                d = ((double)this.getWidth() * 0.8567961165048543 - (double)this.getWidth() * 0.12864077669902912) * this.getMaxMeasuredValue() / (this.getMaxValue() - this.getMinValue());
                graphics2D.translate((double)this.getWidth() * 0.14285714285714285 - (double)this.maxMeasuredImage.getWidth() / 2.0 + d, (double)this.getHeight() * 0.63 + 2.0);
            }
            graphics2D.drawImage((Image)this.maxMeasuredImage, 0, 0, null);
            graphics2D.setTransform(affineTransform);
        }
        if (this.isLedVisible()) {
            graphics2D.drawImage((Image)this.getCurrentLedImage(), (int)this.getLedPositionX(), (int)this.getLedPositionY(), null);
        }
        this.drawValue(graphics2D, this.getWidth(), this.getHeight());
        graphics2D.drawImage((Image)this.foregroundImage, 0, 0, null);
    }

    public int getTickLabelPeriod() {
        return this.tickLabelPeriod;
    }

    public void setTickLabelPeriod(int n) {
        this.tickLabelPeriod = n;
        this.tickmarksImage = this.create_TICKMARKS_Image(this.getWidth(), this.getHeight(), this.getMinValue(), this.getMaxValue(), this.tickLabelPeriod);
        this.repaint();
    }

    public boolean isTitleVisible() {
        return this.titleVisible;
    }

    public void setTitleVisible(boolean bl) {
        this.titleVisible = bl;
        this.repaint();
    }

    public boolean isTickmarksVisible() {
        return this.tickmarksVisible;
    }

    public boolean isUnitStringVisible() {
        return this.unitStringVisible;
    }

    public void setUnitStringVisible(boolean bl) {
        this.unitStringVisible = bl;
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    public void setTickmarksVisible(boolean bl) {
        this.tickmarksVisible = bl;
        this.repaint();
    }

    public ColorDef getValueColor() {
        return this.valueColor;
    }

    public void setValueColor(ColorDef colorDef) {
        this.valueColor = colorDef;
        this.repaint();
    }

    private void drawValue(Graphics2D graphics2D, int n, int n2) {
        Point2D.Double double_;
        Point2D.Double double_2;
        Rectangle2D.Double double_3;
        Point2D.Double double_4;
        Point2D.Double double_5;
        Rectangle2D.Double double_6;
        Point2D.Double double_7;
        Point2D.Double double_8;
        Rectangle2D.Double double_9;
        Rectangle2D.Double double_10;
        Point2D.Double double_11;
        Point2D.Double double_12;
        Rectangle2D.Double double_13;
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        boolean bl;
        boolean bl2 = bl = n < n2;
        if (bl) {
            d5 = (double)n2 * 0.12864077669902912;
            d4 = (double)n2 * 0.8567961165048543;
            d3 = d4 - d5;
            d2 = d3 * this.getValue() / (this.getMaxValue() - this.getMinValue());
            d = d5 + d3 - d2;
        } else {
            d5 = (double)n * 0.8567961165048543;
            d4 = (double)n * 0.12864077669902912;
            d3 = d5 - d4;
            d2 = d3 * this.getValue() / (this.getMaxValue() - this.getMinValue());
            d = d5;
        }
        if (bl) {
            double_13 = new Rectangle2D.Double((double)n * 0.4357142857142857, d5, (double)n * 0.14285714285714285, d3);
            double_12 = new Point2D.Double(0.0, ((Rectangle2D)double_13).getBounds2D().getMinY());
            double_11 = new Point2D.Double(0.0, ((Rectangle2D)double_13).getBounds2D().getMaxY());
        } else {
            double_13 = new Rectangle2D.Double((double)n * 0.14285714285714285, (double)n2 * 0.4357142857142857, d3, (double)n2 * 0.14285714285714285);
            double_12 = new Point2D.Double(d5, 0.0);
            double_11 = new Point2D.Double(d4, 0.0);
        }
        float[] fArray = new float[]{0.0f, 0.48f, 0.49f, 1.0f};
        Color[] colorArray = new Color[]{UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.047058824f), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.14509805f), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.14901961f), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.047058824f)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_12, double_11, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_13);
        if (bl) {
            double_10 = new Rectangle2D.Double((double)n * 0.4357142857142857, d5, (double)n * 0.007142857142857143, d3);
            double_9 = new Rectangle2D.Double((double)n * 0.5714285714285714, d5, (double)n * 0.007142857142857143, d3);
            double_8 = new Point2D.Double(0.0, ((Rectangle2D)double_10).getBounds2D().getMinY());
            double_7 = new Point2D.Double(0.0, ((Rectangle2D)double_10).getBounds2D().getMaxY());
        } else {
            double_10 = new Rectangle2D.Double((double)n * 0.14285714285714285, (double)n2 * 0.4357142857, d3, (double)n2 * 0.007142857142857143);
            double_9 = new Rectangle2D.Double((double)n * 0.14285714285714285, (double)n2 * 0.5714285714, d3, (double)n2 * 0.007142857142857143);
            double_8 = new Point2D.Double(((Rectangle2D)double_10).getBounds2D().getMaxX(), 0.0);
            double_7 = new Point2D.Double(((Rectangle2D)double_10).getBounds2D().getMinX(), 0.0);
        }
        float[] fArray2 = new float[]{0.0f, 0.48f, 0.49f, 1.0f};
        Color[] colorArray2 = new Color[]{UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.29803923f), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.6862745f), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.69803923f), UTIL.setAlpha(this.getBackgroundColor().LABEL_COLOR, 0.4f)};
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_8, double_7, fArray2, colorArray2);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fill(double_10);
        graphics2D.fill(double_9);
        if (bl) {
            double_6 = new Rectangle2D.Double((double)n * 0.45, d, (double)n * 0.1142857143, d2);
            double_5 = new Point2D.Double(((Rectangle2D)double_6).getBounds2D().getMinX(), 0.0);
            double_4 = new Point2D.Double(((Rectangle2D)double_6).getBounds2D().getMaxX(), 0.0);
        } else {
            double_6 = new Rectangle2D.Double((double)n * 0.14285714285714285, (double)n2 * 0.45, d2, (double)n2 * 0.1142857143);
            double_5 = new Point2D.Double(0.0, ((Rectangle2D)double_6).getBounds2D().getMinY());
            double_4 = new Point2D.Double(0.0, ((Rectangle2D)double_6).getBounds2D().getMaxY());
        }
        float[] fArray3 = new float[]{0.0f, 0.99f, 1.0f};
        Color[] colorArray3 = new Color[]{this.valueColor.MEDIUM, this.valueColor.LIGHT, this.valueColor.LIGHT};
        LinearGradientPaint linearGradientPaint3 = new LinearGradientPaint(double_5, double_4, fArray3, colorArray3);
        graphics2D.setPaint(linearGradientPaint3);
        graphics2D.fill(double_6);
        if (bl) {
            double_3 = new Rectangle2D.Double((double)n * 0.45, d, (double)n * 0.05, d2);
            double_2 = new Point2D.Double(((Rectangle2D)double_3).getBounds2D().getMinX(), 0.0);
            double_ = new Point2D.Double(((Rectangle2D)double_3).getBounds2D().getMaxX(), 0.0);
        } else {
            double_3 = new Rectangle2D.Double((double)n * 0.14285714285714285, (double)n2 * 0.45, d2, (double)n2 * 0.05);
            double_2 = new Point2D.Double(0.0, ((Rectangle2D)double_3).getBounds2D().getMinY());
            double_ = new Point2D.Double(0.0, ((Rectangle2D)double_3).getBounds2D().getMaxY());
        }
        float[] fArray4 = new float[]{0.0f, 1.0f};
        Color[] colorArray4 = new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.7f), new Color(1.0f, 1.0f, 1.0f, 0.05f)};
        LinearGradientPaint linearGradientPaint4 = new LinearGradientPaint(double_2, double_, fArray4, colorArray4);
        graphics2D.setPaint(linearGradientPaint4);
        graphics2D.fill(double_3);
    }

    @Override
    public String toString() {
        return "Linear";
    }
}

