/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractRadial;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;

public final class Level
extends AbstractRadial {
    private double visibleValue = 90.0;
    private int stepValue = 0;
    private boolean textOrientationFixed = false;
    private boolean decimalVisible = true;
    private final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.0");
    private double angleStep;
    private BufferedImage backgroundImage;
    private BufferedImage tickmarksImage;
    private BufferedImage pointerImage;
    private BufferedImage stepPointerImage;
    private BufferedImage foregroundImage;

    public Level() {
        this.setMinValue(0.0);
        this.setMaxValue(360.0);
        this.calcAngleStep();
        this.addComponentListener(this);
        this.setSize(this.getPreferredSize());
        this.init(this.getWidth(), this.getWidth());
    }

    @Override
    public void init(int n, int n2) {
        this.backgroundImage = this.create_BACKGROUND_Image(n);
        this.tickmarksImage = this.create_TICKMARKS_Image(n, 0.0, 0.0, 0.0, 0.0, 0.0, 0);
        this.pointerImage = this.create_POINTER_Image(n);
        this.stepPointerImage = this.create_STEPPOINTER_Image(n);
        this.foregroundImage = this.create_FOREGROUND_Image(n, false);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Point2D.Double double_ = new Point2D.Double((double)this.pointerImage.getWidth() / 2.0, (double)this.pointerImage.getWidth() / 2.0);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.drawImage((Image)this.backgroundImage, 0, 0, null);
        graphics2D.drawImage((Image)this.tickmarksImage, 0, 0, null);
        if (this.textOrientationFixed) {
            graphics2D.setColor(super.getBackgroundColor().LABEL_COLOR);
            if (this.decimalVisible) {
                graphics2D.setFont(new Font("Verdana", 0, (int)(0.15 * (double)this.getWidth())));
            } else {
                graphics2D.setFont(new Font("Verdana", 0, (int)(0.2 * (double)this.getWidth())));
            }
            FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
            TextLayout textLayout = new TextLayout(this.DECIMAL_FORMAT.format(this.visibleValue) + "\u00b0", graphics2D.getFont(), fontRenderContext);
            object = textLayout.getBounds();
            graphics2D.drawString(this.DECIMAL_FORMAT.format(this.visibleValue) + "\u00b0", (float)((int)(((double)this.getWidth() - ((RectangularShape)object).getWidth()) / 2.0)), (float)((int)(((double)this.getWidth() - ((RectangularShape)object).getHeight()) / 2.0)) + textLayout.getAscent() - textLayout.getDescent());
        }
        double d = this.getValue() * this.angleStep;
        graphics2D.rotate(d, ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.drawImage((Image)this.pointerImage, 0, 0, null);
        if (!this.textOrientationFixed) {
            graphics2D.setColor(super.getBackgroundColor().LABEL_COLOR);
            if (this.decimalVisible) {
                graphics2D.setFont(new Font("Verdana", 0, (int)(0.15 * (double)this.getWidth())));
            } else {
                graphics2D.setFont(new Font("Verdana", 0, (int)(0.2 * (double)this.getWidth())));
            }
            object = new FontRenderContext(null, true, true);
            TextLayout textLayout = new TextLayout(this.DECIMAL_FORMAT.format(this.visibleValue) + "\u00b0", graphics2D.getFont(), (FontRenderContext)object);
            Rectangle2D rectangle2D = textLayout.getBounds();
            graphics2D.drawString(this.DECIMAL_FORMAT.format(this.visibleValue) + "\u00b0", (float)((int)(((double)this.getWidth() - rectangle2D.getWidth()) / 2.0)), (float)((int)(((double)this.getWidth() - rectangle2D.getHeight()) / 2.0)) + textLayout.getAscent() - textLayout.getDescent());
        }
        graphics2D.rotate(Math.toRadians(this.stepValue), ((Point2D)double_).getX(), ((Point2D)double_).getY());
        graphics2D.drawImage((Image)this.stepPointerImage, 0, 0, null);
        graphics2D.setTransform(affineTransform);
        graphics2D.drawImage((Image)this.foregroundImage, 0, 0, null);
    }

    @Override
    public void setValue(double d) {
        double d2 = this.getValue();
        super.setValue(d);
        this.stepValue = 2 * ((int)(Math.abs(d) * 10.0) % 10);
        if (this.stepValue > 10) {
            this.stepValue -= 20;
        }
        if (d > 0.0 && d <= 90.0) {
            this.visibleValue = 90.0 - d;
        }
        if (d > 90.0 && d <= 180.0) {
            this.visibleValue = d - 90.0;
        }
        if (d > 180.0 && d <= 270.0) {
            this.visibleValue = 270.0 - d;
        }
        if (d > 270.0 && d <= 360.0) {
            this.visibleValue = d - 270.0;
        }
        if (d < 0.0 && d >= -90.0) {
            this.visibleValue = 90.0 - Math.abs(d);
        }
        if (d < -90.0 && d >= -180.0) {
            this.visibleValue = Math.abs(d) - 90.0;
        }
        if (d < -180.0 && d >= -270.0) {
            this.visibleValue = 270.0 - Math.abs(d);
        }
        if (d < -270.0 && d >= -360.0) {
            this.visibleValue = Math.abs(d) - 270.0;
        }
        this.firePropertyChange("value", d2, d);
        this.repaint();
    }

    public boolean isTextOrientationFixed() {
        return this.textOrientationFixed;
    }

    public void setTextOrientationFixed(boolean bl) {
        this.textOrientationFixed = bl;
        this.repaint();
    }

    public boolean isDecimalVisible() {
        return this.decimalVisible;
    }

    public void setDecimalVisible(boolean bl) {
        if (bl) {
            this.DECIMAL_FORMAT.applyPattern("0.0");
        } else {
            this.DECIMAL_FORMAT.applyPattern("0");
        }
        this.decimalVisible = bl;
        this.repaint();
    }

    @Override
    protected void calcAngleStep() {
        this.angleStep = Math.PI * 2 / (this.getMaxValue() - this.getMinValue());
    }

    @Override
    protected BufferedImage create_TICKMARKS_Image(int n, double d, double d2, double d3, double d4, double d5, int n2) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Font font = new Font("Verdana", 0, (int)(0.04 * (double)n));
        Font font2 = new Font("Verdana", 0, (int)(0.03 * (double)n));
        BasicStroke basicStroke = new BasicStroke(1.0f, 1, 2);
        BasicStroke basicStroke2 = new BasicStroke(0.5f, 1, 2);
        BasicStroke basicStroke3 = new BasicStroke(0.1f, 1, 2);
        int n5 = (int)(0.08 * (double)n);
        int n6 = (int)(0.0133333333 * (double)n);
        int n7 = (int)(0.02 * (double)n);
        int n8 = (int)(0.04 * (double)n);
        float f = (float)n3 * 0.38f;
        Point2D.Double double_ = new Point2D.Double((float)n3 / 2.0f, (float)n4 / 2.0f);
        Point2D.Double double_2 = null;
        int n9 = 0;
        int n10 = 0;
        float f2 = 90.0f;
        boolean bl = false;
        float f3 = 1.0f;
        graphics2D.setFont(font);
        boolean bl2 = false;
        double d6 = 0.0;
        double d7 = 0.0;
        for (double d8 = Math.PI * 2; d8 >= Math.PI / 180; d8 -= Math.PI / 180) {
            Line2D.Double double_3;
            graphics2D.setStroke(basicStroke2);
            d6 = Math.sin(d8);
            d7 = Math.cos(d8);
            double_2 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n5) * d6, ((Point2D)double_).getY() + (double)(f - (float)n5) * d7);
            Point2D.Double double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n6) * d6, ((Point2D)double_).getY() + (double)(f - (float)n6) * d7);
            Point2D.Double double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)f * d6, ((Point2D)double_).getY() + (double)f * d7);
            graphics2D.setColor(super.getBackgroundColor().LABEL_COLOR);
            if (n9 % 5 == 0) {
                graphics2D.setColor(super.getBackgroundColor().LABEL_COLOR);
                graphics2D.setStroke(basicStroke2);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n7) * d6, ((Point2D)double_).getY() + (double)(f - (float)n7) * d7);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)f * d6, ((Point2D)double_).getY() + (double)f * d7);
                double_3 = new Line2D.Double(((Point2D)double_4).getX(), ((Point2D)double_4).getY(), ((Point2D)double_5).getX(), ((Point2D)double_5).getY());
                graphics2D.draw(double_3);
            }
            if (n9 == 45 || n9 == 0) {
                graphics2D.setColor(super.getBackgroundColor().LABEL_COLOR);
                graphics2D.setStroke(basicStroke);
                double_4 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n8) * d6, ((Point2D)double_).getY() + (double)(f - (float)n8) * d7);
                double_5 = new Point2D.Double(((Point2D)double_).getX() + (double)f * d6, ((Point2D)double_).getY() + (double)f * d7);
                double_2 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)n5) * d6, ((Point2D)double_).getY() + (double)(f - (float)n5) * d7);
                graphics2D.setFont(font);
                graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, String.valueOf((int)f2) + "\u00b0", (int)((Point2D)double_2).getX(), (int)((Point2D)double_2).getY(), Math.toDegrees(Math.PI - d8)));
                if (bl2) {
                    double_2 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)(n5 * 2)) * d6, ((Point2D)double_).getY() + (double)(f - (float)(n5 * 2)) * d7);
                    graphics2D.setFont(font2);
                    graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, "100%", (int)((Point2D)double_2).getX(), (int)((Point2D)double_2).getY(), Math.toDegrees(Math.PI - d8)));
                } else if (f2 == 0.0f) {
                    double_2 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)(n5 * 2)) * d6, ((Point2D)double_).getY() + (double)(f - (float)(n5 * 2)) * d7);
                    graphics2D.setFont(font2);
                    graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, "0%", (int)((Point2D)double_2).getX(), (int)((Point2D)double_2).getY(), Math.toDegrees(Math.PI - d8)));
                } else {
                    double_2 = new Point2D.Double(((Point2D)double_).getX() + (double)(f - (float)(n5 * 2)) * d6, ((Point2D)double_).getY() + (double)(f - (float)(n5 * 2)) * d7);
                    graphics2D.setFont(font2);
                    graphics2D.fill(UTIL.rotateTextAroundCenter(graphics2D, "\u221e", (int)((Point2D)double_2).getX(), (int)((Point2D)double_2).getY(), Math.toDegrees(Math.PI - d8)));
                }
                bl2 ^= true;
                n9 = 0;
                ++n10;
                double_3 = new Line2D.Double(((Point2D)double_4).getX(), ((Point2D)double_4).getY(), ((Point2D)double_5).getX(), ((Point2D)double_5).getY());
                graphics2D.draw(double_3);
            }
            graphics2D.setStroke(basicStroke3);
            double_3 = new Line2D.Double(((Point2D)double_4).getX(), ((Point2D)double_4).getY(), ((Point2D)double_5).getX(), ((Point2D)double_5).getY());
            graphics2D.draw(double_3);
            ++n9;
            if (f2 == 0.0f) {
                bl = true;
            }
            if (f2 == 90.0f) {
                bl = false;
            }
            if (bl) {
                f2 += f3;
                continue;
            }
            f2 -= f3;
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_POINTER_Image(int n) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, (int)(1.0 * (double)n), 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.5233644859813084, (double)n3 * 0.35046728971962615);
        generalPath.lineTo((double)n2 * 0.5, (double)n3 * 0.1308411214953271);
        generalPath.lineTo((double)n2 * 0.4766355140186916, (double)n3 * 0.35046728971962615);
        generalPath.curveTo((double)n2 * 0.4766355140186916, (double)n3 * 0.35046728971962615, (double)n2 * 0.49065420560747663, (double)n3 * 0.34579439252336447, (double)n2 * 0.5, (double)n3 * 0.34579439252336447);
        generalPath.curveTo((double)n2 * 0.5093457943925234, (double)n3 * 0.34579439252336447, (double)n2 * 0.5233644859813084, (double)n3 * 0.35046728971962615, (double)n2 * 0.5233644859813084, (double)n3 * 0.35046728971962615);
        generalPath.closePath();
        Point2D.Double double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        Point2D.Double double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
        Color[] colorArray = new Color[]{new Color(82, 0, 0, 180), new Color(252, 29, 0, 180), new Color(252, 29, 0, 180), new Color(82, 0, 0, 180)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        Color color = new Color(16522496);
        graphics2D.setColor(color);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics2D.draw(generalPath);
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.setWindingRule(0);
        generalPath2.moveTo((double)n2 * 0.20093457943925233, (double)n3 * 0.43457943925233644);
        generalPath2.lineTo((double)n2 * 0.16355140186915887, (double)n3 * 0.43457943925233644);
        generalPath2.lineTo((double)n2 * 0.16355140186915887, (double)n3 * 0.5607476635514018);
        generalPath2.lineTo((double)n2 * 0.20093457943925233, (double)n3 * 0.5607476635514018);
        graphics2D.setColor(super.getBackgroundColor().LABEL_COLOR);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics2D.draw(generalPath2);
        GeneralPath generalPath3 = new GeneralPath();
        generalPath3.setWindingRule(0);
        generalPath3.moveTo((double)n2 * 0.16355140186915887, (double)n3 * 0.4719626168224299);
        generalPath3.lineTo((double)n2 * 0.205607476635514, (double)n3 * 0.5);
        generalPath3.lineTo((double)n2 * 0.16355140186915887, (double)n3 * 0.5233644859813084);
        generalPath3.lineTo((double)n2 * 0.16355140186915887, (double)n3 * 0.4719626168224299);
        generalPath3.closePath();
        graphics2D.setColor(super.getBackgroundColor().LABEL_COLOR);
        graphics2D.fill(generalPath3);
        GeneralPath generalPath4 = new GeneralPath();
        generalPath4.setWindingRule(0);
        generalPath4.moveTo((double)n2 * 0.7990654205607477, (double)n3 * 0.43457943925233644);
        generalPath4.lineTo((double)n2 * 0.8364485981308412, (double)n3 * 0.43457943925233644);
        generalPath4.lineTo((double)n2 * 0.8364485981308412, (double)n3 * 0.5607476635514018);
        generalPath4.lineTo((double)n2 * 0.7990654205607477, (double)n3 * 0.5607476635514018);
        graphics2D.setColor(super.getBackgroundColor().LABEL_COLOR);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics2D.draw(generalPath4);
        GeneralPath generalPath5 = new GeneralPath();
        generalPath5.setWindingRule(0);
        generalPath5.moveTo((double)n2 * 0.8364485981308412, (double)n3 * 0.4719626168224299);
        generalPath5.lineTo((double)n2 * 0.794392523364486, (double)n3 * 0.5);
        generalPath5.lineTo((double)n2 * 0.8364485981308412, (double)n3 * 0.5233644859813084);
        generalPath5.lineTo((double)n2 * 0.8364485981308412, (double)n3 * 0.4719626168224299);
        generalPath5.closePath();
        graphics2D.setColor(super.getBackgroundColor().LABEL_COLOR);
        graphics2D.fill(generalPath5);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_STEPPOINTER_Image(int n) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        generalPath.moveTo((double)n2 * 0.2850467289719626, (double)n3 * 0.514018691588785);
        generalPath.lineTo((double)n2 * 0.2102803738317757, (double)n3 * 0.5);
        generalPath.lineTo((double)n2 * 0.2850467289719626, (double)n3 * 0.48130841121495327);
        generalPath.curveTo((double)n2 * 0.2850467289719626, (double)n3 * 0.48130841121495327, (double)n2 * 0.2803738317757009, (double)n3 * 0.49065420560747663, (double)n2 * 0.2803738317757009, (double)n3 * 0.4953271028037383);
        generalPath.curveTo((double)n2 * 0.2803738317757009, (double)n3 * 0.5046728971962616, (double)n2 * 0.2850467289719626, (double)n3 * 0.514018691588785, (double)n2 * 0.2850467289719626, (double)n3 * 0.514018691588785);
        generalPath.closePath();
        Point2D.Double double_ = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
        Point2D.Double double_2 = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
        float[] fArray = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
        Color[] colorArray = new Color[]{new Color(82, 0, 0, 180), new Color(252, 29, 0, 180), new Color(252, 29, 0, 180), new Color(82, 0, 0, 180)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        Color color = new Color(new Color(16522496).getRed(), new Color(16522496).getGreen(), new Color(16522496).getBlue(), 128);
        graphics2D.setColor(color);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics2D.draw(generalPath);
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.setWindingRule(0);
        generalPath2.moveTo((double)n2 * 0.7149532710280374, (double)n3 * 0.514018691588785);
        generalPath2.lineTo((double)n2 * 0.7897196261682243, (double)n3 * 0.5);
        generalPath2.lineTo((double)n2 * 0.7149532710280374, (double)n3 * 0.48130841121495327);
        generalPath2.curveTo((double)n2 * 0.7149532710280374, (double)n3 * 0.48130841121495327, (double)n2 * 0.719626168224299, (double)n3 * 0.49065420560747663, (double)n2 * 0.719626168224299, (double)n3 * 0.4953271028037383);
        generalPath2.curveTo((double)n2 * 0.719626168224299, (double)n3 * 0.5046728971962616, (double)n2 * 0.7149532710280374, (double)n3 * 0.514018691588785, (double)n2 * 0.7149532710280374, (double)n3 * 0.514018691588785);
        generalPath2.closePath();
        Point2D.Double double_3 = new Point2D.Double(generalPath2.getBounds2D().getMaxX(), 0.0);
        Point2D.Double double_4 = new Point2D.Double(generalPath2.getBounds2D().getMinX(), 0.0);
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_3, double_4, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fill(generalPath2);
        Color color2 = new Color(new Color(16522496).getRed(), new Color(16522496).getGreen(), new Color(16522496).getBlue(), 128);
        graphics2D.setColor(color2);
        graphics2D.setStroke(new BasicStroke(1.0f, 0, 0));
        graphics2D.draw(generalPath2);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public String toString() {
        return "Level";
    }
}

