/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.tools.BackgroundColor;
import eu.hansolo.steelseries.tools.ConicalGradientPaint;
import eu.hansolo.steelseries.tools.FrameDesign;
import eu.hansolo.steelseries.tools.Shadow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class FrameRectangular
extends JComponent
implements ComponentListener {
    private BackgroundColor backgroundColor = BackgroundColor.DARK_GRAY;
    private FrameDesign frameDesign = FrameDesign.METAL;
    private BufferedImage backgroundImage;
    private BufferedImage foregroundImage;

    public FrameRectangular() {
        this.addComponentListener(this);
        this.setPreferredSize(new Dimension(140, 140));
        this.setSize(this.getPreferredSize());
        this.init(this.getWidth(), this.getHeight());
    }

    public final void init(int n, int n2) {
        this.backgroundImage = this.create_BACKGROUND_Image(n, n2);
        this.foregroundImage = this.create_FOREGROUND_Image(n, n2);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.drawImage((Image)this.backgroundImage, 0, 0, null);
        this.paintChildren(graphics);
        graphics2D.drawImage((Image)this.foregroundImage, 0, 0, null);
    }

    public BackgroundColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(BackgroundColor backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    public FrameDesign getFrameDesign() {
        return this.frameDesign;
    }

    public void setFrameDesign(FrameDesign frameDesign) {
        this.frameDesign = frameDesign;
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    protected BufferedImage create_BACKGROUND_Image(int n, int n2) {
        Paint paint;
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, n3, n4, 7.0, 7.0);
        Color color = new Color(0x848484);
        graphics2D.setColor(color);
        graphics2D.fill(double_);
        RoundRectangle2D.Double double_2 = new RoundRectangle2D.Double(1.0, 1.0, n3 - 2, n4 - 2, 6.0, 6.0);
        Point2D.Double double_3 = new Point2D.Double(0.0, double_2.getBounds2D().getMinY());
        Point2D.Double double_4 = new Point2D.Double(0.0, double_2.getBounds2D().getMaxY());
        Point2D.Double double_5 = new Point2D.Double(double_2.getCenterX(), double_2.getCenterY());
        float f = (float)Math.toDegrees(Math.atan((float)n4 / 8.0f / ((float)n3 / 2.0f)));
        switch (this.frameDesign) {
            case BLACK_METAL: {
                float[] fArray = new float[]{0.0f, 90.0f - 2.0f * f, 90.0f, 90.0f + 3.0f * f, 180.0f, 270.0f - 3.0f * f, 270.0f, 270.0f + 2.0f * f, 1.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(0, 0, 0, 255), new Color(153, 153, 153, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(153, 153, 153, 255), new Color(0, 0, 0, 255), new Color(254, 254, 254, 255)};
                paint = new ConicalGradientPaint(true, double_5, 0.0f, fArray, colorArray);
                break;
            }
            case METAL: {
                float[] fArray = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                paint = new LinearGradientPaint(double_3, double_4, fArray, colorArray);
                break;
            }
            case SHINY_METAL: {
                float[] fArray = new float[]{0.0f, 90.0f - 2.0f * f, 90.0f, 90.0f + 3.0f * f, 180.0f, 270.0f - 3.0f * f, 270.0f, 270.0f + 2.0f * f, 1.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(179, 179, 179, 255), new Color(238, 238, 238, 255), new Color(179, 179, 179, 255), new Color(179, 179, 179, 255), new Color(179, 179, 179, 255), new Color(238, 238, 238, 255), new Color(179, 179, 179, 255), new Color(254, 254, 254, 255)};
                paint = new ConicalGradientPaint(true, double_5, 0.0f, fArray, colorArray);
                break;
            }
            default: {
                float[] fArray = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                paint = new LinearGradientPaint(double_3, double_4, fArray, colorArray);
            }
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(double_2);
        RoundRectangle2D.Double double_6 = new RoundRectangle2D.Double(((RectangularShape)double_2).getX() + 16.0, ((RectangularShape)double_2).getY() + 16.0, ((RectangularShape)double_2).getWidth() - 32.0, ((RectangularShape)double_2).getHeight() - 32.0, 4.0, 4.0);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(double_6);
        RoundRectangle2D.Double double_7 = new RoundRectangle2D.Double(((RectangularShape)double_6).getX() + 1.0, ((RectangularShape)double_6).getY() + 1.0, ((RectangularShape)double_6).getWidth() - 2.0, ((RectangularShape)double_6).getHeight() - 2.0, 3.0, 3.0);
        Point2D.Double double_8 = new Point2D.Double(0.0, double_7.getBounds2D().getMinY());
        Point2D.Double double_9 = new Point2D.Double(0.0, double_7.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.4f, 1.0f};
        Color[] colorArray = new Color[]{this.backgroundColor.GRADIENT_START_COLOR, this.backgroundColor.GRADIENT_FRACTION_COLOR, this.backgroundColor.GRADIENT_STOP_COLOR};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_8, double_9, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_7);
        BufferedImage bufferedImage2 = Shadow.INSTANCE.createInnerShadow(double_7, linearGradientPaint, 0, 0.65f, Color.BLACK, 20, 315);
        graphics2D.drawImage((Image)bufferedImage2, double_7.getBounds().x, double_7.getBounds().y, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage create_FOREGROUND_Image(int n, int n2) {
        Point2D.Double double_;
        Point2D.Double double_2;
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        if (n >= n2) {
            generalPath.moveTo(18.0f, n4 - 18);
            generalPath.lineTo(n3 - 18, n4 - 18);
            generalPath.curveTo((double)(n3 - 18), (double)(n4 - 18), (double)(n3 - 27), (double)n4 * 0.7, (double)(n3 - 27), (double)n4 * 0.5);
            generalPath.curveTo(n3 - 27, 27.0f, n3 - 18, 18.0f, n3 - 18, 18.0f);
            generalPath.lineTo(18.0f, 18.0f);
            generalPath.curveTo(18.0, 18.0, 27.0, (double)n4 * 0.2857142857142857, 27.0, (double)n4 * 0.5);
            generalPath.curveTo(27.0, (double)n4 * 0.7, 18.0, (double)(n4 - 18), 18.0, (double)(n4 - 18));
            generalPath.closePath();
            double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
            double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        } else {
            generalPath.setWindingRule(0);
            generalPath.moveTo(18.0f, 18.0f);
            generalPath.lineTo(18.0f, n4 - 18);
            generalPath.curveTo(18.0, (double)(n4 - 18), 27.0, (double)(n4 - 27), (double)n3 * 0.5, (double)(n4 - 27));
            generalPath.curveTo(n3 - 27, n4 - 27, n3 - 18, n4 - 18, n3 - 18, n4 - 18);
            generalPath.lineTo(n3 - 18, 18.0f);
            generalPath.curveTo((double)(n3 - 18), 18.0, (double)(n3 - 27), 27.0, (double)n3 * 0.5, 27.0);
            generalPath.curveTo(27.0f, 27.0f, 18.0f, 18.0f, 18.0f, 18.0f);
            generalPath.closePath();
            double_2 = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
            double_ = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
        }
        float[] fArray = new float[]{0.0f, 0.06f, 0.07f, 0.12f, 0.17f, 0.1701f, 0.79f, 0.8f, 0.84f, 0.93f, 0.94f, 0.96f, 0.97f, 1.0f};
        Color[] colorArray = new Color[]{new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 3), new Color(255, 255, 255, 5), new Color(255, 255, 255, 5), new Color(255, 255, 255, 5), new Color(255, 255, 255, 20), new Color(255, 255, 255, 73), new Color(255, 255, 255, 76), new Color(255, 255, 255, 30), new Color(255, 255, 255, 10), new Color(255, 255, 255, 5)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public String toString() {
        return "FrameRectangular";
    }
}

