/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.tools.BackgroundColor;
import eu.hansolo.steelseries.tools.ConicalGradientPaint;
import eu.hansolo.steelseries.tools.FrameDesign;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.Shadow;
import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class DisplayRectangular
extends AbstractGauge {
    private String unitString = "unit";
    private LcdColor lcdColor = LcdColor.WHITE_LCD;
    private int lcdDecimals = 1;
    private boolean unitStringVisible = true;
    private boolean digitalFont = false;
    private Font lcdValueFont;
    private Font lcdUnitFont;
    private final Font LCD_STANDARD_FONT = new Font("Verdana", 1, 24);
    private final Font LCD_DIGITAL_FONT = Util.INSTANCE.getDigitalFont().deriveFont(24);
    private BackgroundColor backgroundColor = BackgroundColor.DARK_GRAY;
    private FrameDesign frameDesign = FrameDesign.METAL;
    private BufferedImage backgroundImage;
    private BufferedImage lcdImage;
    private BufferedImage foregroundImage;

    public DisplayRectangular() {
        this.addComponentListener(this);
        this.setMinimumSize(new Dimension(140, 140));
        this.setPreferredSize(new Dimension(140, 140));
        this.setSize(this.getPreferredSize());
        this.init((int)this.getPreferredSize().getWidth(), (int)this.getPreferredSize().getHeight());
    }

    @Override
    public final void init(int n, int n2) {
        this.backgroundImage = this.create_BACKGROUND_Image(n, n2);
        this.lcdImage = this.create_LCD_Image(n, n2);
        if (this.isDigitalFont()) {
            this.lcdValueFont = this.LCD_DIGITAL_FONT.deriveFont(0.75f * (float)(n2 - 38));
            this.lcdUnitFont = this.LCD_STANDARD_FONT.deriveFont(0.25f * (float)(n2 - 38));
        } else {
            this.lcdValueFont = this.LCD_STANDARD_FONT.deriveFont(0.7f * (float)(n2 - 38));
            this.lcdUnitFont = this.LCD_STANDARD_FONT.deriveFont(0.2f * (float)(n2 - 38));
        }
        this.foregroundImage = this.create_FOREGROUND_Image(n, n2);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        double d;
        Rectangle2D rectangle2D;
        TextLayout textLayout;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.drawImage((Image)this.backgroundImage, 0, 0, null);
        graphics2D.drawImage((Image)this.lcdImage, 0, 0, null);
        graphics2D.setColor(this.lcdColor.TEXT_COLOR);
        graphics2D.setFont(this.lcdUnitFont);
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        if (this.unitStringVisible) {
            textLayout = new TextLayout(this.getUnitString(), graphics2D.getFont(), fontRenderContext);
            rectangle2D = textLayout.getBounds();
            graphics2D.drawString(this.getUnitString(), (int)((double)this.getWidth() - rectangle2D.getWidth() - (double)this.getWidth() * 0.03 - 19.0), (int)((double)this.getHeight() - rectangle2D.getHeight() / 2.0) - 19);
            d = rectangle2D.getWidth();
        } else {
            d = 0.0;
        }
        graphics2D.setFont(this.lcdValueFont);
        textLayout = new TextLayout(this.formatLcdValue(this.getValue()), graphics2D.getFont(), fontRenderContext);
        rectangle2D = textLayout.getBounds();
        graphics2D.drawString(this.formatLcdValue(this.getValue()), (int)((double)this.getWidth() - d - rectangle2D.getWidth() - (double)this.getWidth() * 0.09), (int)(((double)this.getHeight() - rectangle2D.getHeight() - 38.0) / 2.0 + rectangle2D.getHeight() + 19.0));
        graphics2D.drawImage((Image)this.foregroundImage, 0, 0, null);
    }

    @Override
    public void setValue(double d) {
        super.setValue(d);
        this.repaint();
    }

    public BackgroundColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(BackgroundColor backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    public FrameDesign getFrameDesign() {
        return this.frameDesign;
    }

    public void setFrameDesign(FrameDesign frameDesign) {
        this.frameDesign = frameDesign;
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    public int getLcdDecimals() {
        return this.lcdDecimals;
    }

    public void setLcdDecimals(int n) {
        this.lcdDecimals = n;
        this.repaint();
    }

    public boolean isUnitStringVisible() {
        return this.unitStringVisible;
    }

    public void setUnitStringVisible(boolean bl) {
        this.unitStringVisible = bl;
        this.repaint();
    }

    public boolean isDigitalFont() {
        return this.digitalFont;
    }

    public void setDigitalFont(boolean bl) {
        this.digitalFont = bl;
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    public String getUnitString() {
        return this.unitString;
    }

    public void setUnitString(String string) {
        this.unitString = string;
        this.repaint();
    }

    public LcdColor getLcdColor() {
        return this.lcdColor;
    }

    public void setLcdColor(LcdColor lcdColor) {
        this.lcdColor = lcdColor;
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    public String formatLcdValue(double d) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("0");
        if (this.lcdDecimals > 0) {
            stringBuilder.append(".");
        }
        for (int i = 0; i < this.lcdDecimals; ++i) {
            stringBuilder.append("0");
        }
        DecimalFormat decimalFormat = new DecimalFormat(stringBuilder.toString(), new DecimalFormatSymbols(Locale.US));
        return decimalFormat.format(d);
    }

    private BufferedImage create_BACKGROUND_Image(int n, int n2) {
        Paint paint;
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, n3, n4, 7.0, 7.0);
        Color color = new Color(0x848484);
        graphics2D.setColor(color);
        graphics2D.fill(double_);
        RoundRectangle2D.Double double_2 = new RoundRectangle2D.Double(1.0, 1.0, n3 - 2, n4 - 2, 6.0, 6.0);
        Point2D.Double double_3 = new Point2D.Double(0.0, double_2.getBounds2D().getMinY());
        Point2D.Double double_4 = new Point2D.Double(0.0, double_2.getBounds2D().getMaxY());
        Point2D.Double double_5 = new Point2D.Double(double_2.getCenterX(), double_2.getCenterY());
        float f = (float)Math.toDegrees(Math.atan((float)n4 / 8.0f / ((float)n3 / 2.0f)));
        switch (this.frameDesign) {
            case BLACK_METAL: {
                float[] fArray = new float[]{0.0f, 90.0f - 2.0f * f, 90.0f, 90.0f + 3.0f * f, 180.0f, 270.0f - 3.0f * f, 270.0f, 270.0f + 2.0f * f, 1.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(0, 0, 0, 255), new Color(153, 153, 153, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(0, 0, 0, 255), new Color(153, 153, 153, 255), new Color(0, 0, 0, 255), new Color(254, 254, 254, 255)};
                paint = new ConicalGradientPaint(true, double_5, 0.0f, fArray, colorArray);
                break;
            }
            case METAL: {
                float[] fArray = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                paint = new LinearGradientPaint(double_3, double_4, fArray, colorArray);
                break;
            }
            case SHINY_METAL: {
                float[] fArray = new float[]{0.0f, 90.0f - 2.0f * f, 90.0f, 90.0f + 3.0f * f, 180.0f, 270.0f - 3.0f * f, 270.0f, 270.0f + 2.0f * f, 1.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(179, 179, 179, 255), new Color(238, 238, 238, 255), new Color(179, 179, 179, 255), new Color(179, 179, 179, 255), new Color(179, 179, 179, 255), new Color(238, 238, 238, 255), new Color(179, 179, 179, 255), new Color(254, 254, 254, 255)};
                paint = new ConicalGradientPaint(true, double_5, 0.0f, fArray, colorArray);
                break;
            }
            default: {
                float[] fArray = new float[]{0.0f, 0.07f, 0.12f, 1.0f};
                Color[] colorArray = new Color[]{new Color(254, 254, 254, 255), new Color(210, 210, 210, 255), new Color(179, 179, 179, 255), new Color(213, 213, 213, 255)};
                paint = new LinearGradientPaint(double_3, double_4, fArray, colorArray);
            }
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(double_2);
        RoundRectangle2D.Double double_6 = new RoundRectangle2D.Double(((RectangularShape)double_2).getX() + 16.0, ((RectangularShape)double_2).getY() + 16.0, ((RectangularShape)double_2).getWidth() - 32.0, ((RectangularShape)double_2).getHeight() - 32.0, 4.0, 4.0);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(double_6);
        RoundRectangle2D.Double double_7 = new RoundRectangle2D.Double(((RectangularShape)double_6).getX() + 1.0, ((RectangularShape)double_6).getY() + 1.0, ((RectangularShape)double_6).getWidth() - 2.0, ((RectangularShape)double_6).getHeight() - 2.0, 3.0, 3.0);
        Point2D.Double double_8 = new Point2D.Double(0.0, double_7.getBounds2D().getMinY());
        Point2D.Double double_9 = new Point2D.Double(0.0, double_7.getBounds2D().getMaxY());
        float[] fArray = new float[]{0.0f, 0.4f, 1.0f};
        Color[] colorArray = new Color[]{this.backgroundColor.GRADIENT_START_COLOR, this.backgroundColor.GRADIENT_FRACTION_COLOR, this.backgroundColor.GRADIENT_STOP_COLOR};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_8, double_9, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_7);
        BufferedImage bufferedImage2 = Shadow.INSTANCE.createInnerShadow(double_7, linearGradientPaint, 0, 0.65f, Color.BLACK, 20, 315);
        graphics2D.drawImage((Image)bufferedImage2, double_7.getBounds().x, double_7.getBounds().y, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_FOREGROUND_Image(int n, int n2) {
        Point2D.Double double_;
        Point2D.Double double_2;
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        GeneralPath generalPath = new GeneralPath();
        generalPath.setWindingRule(0);
        if (n >= n2) {
            generalPath.moveTo(18.0f, n4 - 18);
            generalPath.lineTo(n3 - 18, n4 - 18);
            generalPath.curveTo((double)(n3 - 18), (double)(n4 - 18), (double)(n3 - 27), (double)n4 * 0.7, (double)(n3 - 27), (double)n4 * 0.5);
            generalPath.curveTo(n3 - 27, 27.0f, n3 - 18, 18.0f, n3 - 18, 18.0f);
            generalPath.lineTo(18.0f, 18.0f);
            generalPath.curveTo(18.0, 18.0, 27.0, (double)n4 * 0.2857142857142857, 27.0, (double)n4 * 0.5);
            generalPath.curveTo(27.0, (double)n4 * 0.7, 18.0, (double)(n4 - 18), 18.0, (double)(n4 - 18));
            generalPath.closePath();
            double_2 = new Point2D.Double(0.0, generalPath.getBounds2D().getMaxY());
            double_ = new Point2D.Double(0.0, generalPath.getBounds2D().getMinY());
        } else {
            generalPath.setWindingRule(0);
            generalPath.moveTo(18.0f, 18.0f);
            generalPath.lineTo(18.0f, n4 - 18);
            generalPath.curveTo(18.0, (double)(n4 - 18), 27.0, (double)(n4 - 27), (double)n3 * 0.5, (double)(n4 - 27));
            generalPath.curveTo(n3 - 27, n4 - 27, n3 - 18, n4 - 18, n3 - 18, n4 - 18);
            generalPath.lineTo(n3 - 18, 18.0f);
            generalPath.curveTo((double)(n3 - 18), 18.0, (double)(n3 - 27), 27.0, (double)n3 * 0.5, 27.0);
            generalPath.curveTo(27.0f, 27.0f, 18.0f, 18.0f, 18.0f, 18.0f);
            generalPath.closePath();
            double_2 = new Point2D.Double(generalPath.getBounds2D().getMinX(), 0.0);
            double_ = new Point2D.Double(generalPath.getBounds2D().getMaxX(), 0.0);
        }
        float[] fArray = new float[]{0.0f, 0.06f, 0.07f, 0.12f, 0.17f, 0.1701f, 0.79f, 0.8f, 0.84f, 0.93f, 0.94f, 0.96f, 0.97f, 1.0f};
        Color[] colorArray = new Color[]{new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 0), new Color(255, 255, 255, 3), new Color(255, 255, 255, 5), new Color(255, 255, 255, 5), new Color(255, 255, 255, 5), new Color(255, 255, 255, 20), new Color(255, 255, 255, 73), new Color(255, 255, 255, 76), new Color(255, 255, 255, 30), new Color(255, 255, 255, 10), new Color(255, 255, 255, 5)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_2, double_, fArray, colorArray);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(generalPath);
        graphics2D.dispose();
        return bufferedImage;
    }

    private BufferedImage create_LCD_Image(int n, int n2) {
        if (n <= 0) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        Point2D.Double double_ = new Point2D.Double(0.0, 18.0);
        Point2D.Double double_2 = new Point2D.Double(0.0, n4 - 18);
        float[] fArray = new float[]{0.0f, 0.08f, 0.92f, 1.0f};
        Color[] colorArray = new Color[]{new Color(0.4f, 0.4f, 0.4f, 1.0f), new Color(0.5f, 0.5f, 0.5f, 1.0f), new Color(0.5f, 0.5f, 0.5f, 1.0f), new Color(0.9f, 0.9f, 0.9f, 1.0f)};
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(double_, double_2, fArray, colorArray);
        RoundRectangle2D.Double double_3 = new RoundRectangle2D.Double(18.0, 18.0, n3 - 36, n4 - 36, 3.0, 3.0);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(double_3);
        Point2D.Double double_4 = new Point2D.Double(0.0, 19.0);
        Point2D.Double double_5 = new Point2D.Double(0.0, n4 - 19);
        float[] fArray2 = new float[]{0.0f, 0.03f, 0.49f, 0.5f, 1.0f};
        Color[] colorArray2 = new Color[]{this.lcdColor.GRADIENT_START_COLOR, this.lcdColor.GRADIENT_FRACTION1_COLOR, this.lcdColor.GRADIENT_FRACTION2_COLOR, this.lcdColor.GRADIENT_FRACTION3_COLOR, this.lcdColor.GRADIENT_STOP_COLOR};
        LinearGradientPaint linearGradientPaint2 = new LinearGradientPaint(double_4, double_5, fArray2, colorArray2);
        RoundRectangle2D.Double double_6 = new RoundRectangle2D.Double(19.0, 19.0, n3 - 38, n4 - 38, 2.0, 2.0);
        graphics2D.setPaint(linearGradientPaint2);
        graphics2D.fill(double_6);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.init(this.getWidth(), this.getHeight());
        this.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public String toString() {
        return "DisplayRectangular";
    }
}

